<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\{
    PageController,
    ProfileController,
    // PatientsController,
    RoutingtoContentController,
    HomepageController,
    ServicesController,
    FacilitiyController,
    NewsController,
    ContactController,
    AboutController,
    // FounderController,
    TechController,
    BoardOfDirectorController,
    BoardOfDirectorCategoryController,
    ContactBannerController,
    DoctorsDumpController,
    TestimonialController,
    NewsletterController
};

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
// */
// pages/ Public Routes
Route::get('/', [PageController::class, 'homepage'])->name('homepage');

Route::get('/patientsportal/login', [PageController::class, 'patientsPortalLogin'])->name('patientsPortalLogin');
Route::get('/patientsportal/register', [PageController::class, 'patientsPortalRegister'])->name('patientsPortalRegister');
Route::get('/doctorsportal', [PageController::class, 'doctorsPortal'])->name('doctorsPortal');

Route::get('/about/companyProfile', [PageController::class, 'companyProfile'])->name('companyProfile');
Route::get('/about/foundersCommitees', [PageController::class, 'foundersCommitees'])->name('foundersCommitees');

Route::get('/services/servicesoffered', [PageController::class, 'serviceOffered'])->name('servicesOffered');

Route::get('/services/servicesoffered/item1', [PageController::class, 'serviceOfferedItem'])->name('servicesOfferedItems');
Route::get('/services/servicesoffered/item2', [PageController::class, 'serviceOfferedItem'])->name('servicesOfferedItems');
Route::get('/services/servicesoffered/item3', [PageController::class, 'serviceOfferedItem'])->name('servicesOfferedItems');
Route::get('/services/servicesoffered/item4', [PageController::class, 'serviceOfferedItem'])->name('servicesOfferedItems');
Route::get('/services/servicesoffered/item5', [PageController::class, 'serviceOfferedItem'])->name('servicesOfferedItems');
Route::get('/services/servicesoffered/item6', [PageController::class, 'serviceOfferedItem'])->name('servicesOfferedItems');

Route::get('/services/servicesprivateandvisitors', [PageController::class, 'servicePV'])->name('servicesPV');

Route::get('/services/service_detail/{slug_title}', [PageController::class, 'service_detail'])->name('service_detail');

Route::get('/services/servicesTechnologyandFacilities', [PageController::class, 'serviceTech'])->name('servicesTech');
Route::get('/services/servicesTechnologyandFacilities/doctorsearch', [PageController::class, 'doctorSearch'])->name('doctorSearch');


Route::get('/doctors-search-result', [PageController::class, 'docSearchResult'])->name('docsearch');



Route::get('/newsandinsights', [PageController::class, 'newsAndInsight'])->name('newsAndInsight');
Route::get('/newsandinsights/{slug_title}', [PageController::class, 'newsItem'])->name('newsItem');

Route::get('/contact', [PageController::class, 'contact'])->name('contact');



Route::get('/search-doctors', [PageController::class, 'docSearchResult'])->name('doctors.search');
Route::get('/doctor-details/{id}', [PageController::class, 'doctorsDetail'])->name('doctors.details');


Route::post('/contact/store', [PageController::class, 'storeContact'])->name('store.contact');

Route::middleware(['auth'])->group(function () {
    Route::get('/newsletter', [NewsletterController::class, 'index'])->name('newsletter.index');
    Route::post('/newsletter', [NewsletterController::class, 'store'])->name('newsletter.store');
    Route::delete('/newsletter/{id}', [NewsletterController::class, 'destroy'])->name('newsletter.destroy');
    Route::get('admin/dashboard', [RoutingtoContentController::class, 'index'])->name('dashboard');
    Route::prefix('profile')->group(function () {
        Route::get('/', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::patch('/', [ProfileController::class, 'update'])->name('profile.update');
        Route::delete('/', [ProfileController::class, 'destroy'])->name('profile.destroy');
    });
    // ✅ **Superadmin Routes** (Protected by Middleware)
    Route::middleware('role:admin')->prefix('admin')->name('admin.')->group(function () {
        Route::resource('homepage', HomepageController::class);

        Route::resource('board-of-directors', BoardOfDirectorController::class);
        Route::resource('board-of-director-categories', BoardOfDirectorCategoryController::class);

        Route::resource('about', AboutController::class);
        // Route::resource('founders', FounderController::class);
        Route::resource('services', ServicesController::class);
        Route::resource('tech', TechController::class);
        Route::resource('facilities', FacilitiyController::class);
        Route::resource('news', NewsController::class);
        Route::resource('testimonial', TestimonialController::class);
        Route::resource('contact', ContactController::class);
        Route::resource('contactbanner', ContactBannerController::class);

        Route::resource('doctor', DoctorsDumpController::class);
        Route::resource('newsletter', NewsletterController::class);
        Route::post('/newsletter', [NewsletterController::class, 'destroy'])->name('newsletter.destroy');


        // Route::get('index', RoutingDashboardController::class ,"supperadmin")->name('index_admin'); 
    });
});

require __DIR__ . '/auth.php';
