@extends('layouts.main-app')

@section('content')

@section('meta_title', 'Prime Hospital and Medical Center')
@section('meta_description',
    'Prime Hospital is a dynamic pillar of the community, delivering compassionate care and
    advanced medical expertise. With proactive innovation and modern practices, it provides exemplary, up-to-date care
    tailored to meet every patient’s needs')
@section('meta_keywords',
    '
    "Prime"
    "Hospital"
    "Compassionate"
    "Care"
    "Innovation"
    "Modern"
    "Exemplary"
    "Community"
    "Wellness"
    "Quality"
    "Expertise"
    "Dynamic"
    "Proactive"
    "Patients"
    "Advanced"
    "Relevant"
    "Excellence"
    ')





    {{-- <div class="swiper bannerSwiper">
    <div class="swiper-wrapper">
        @foreach ($banners as $banner)
        <div class="swiper-slide">
            @include('layouts.navbar', [
                'headerTitle' => '
                    <span class="text-bold"></span>
                    <span class="text-[#0b5cb5] font-black">Your Health,</span><br>
                    <span class="text-bold">' . e($banner->header) . '</span>
                ',
                'headerDescription' => $banner->subheader ?? '',
                'isHomepage' => true
            ])
            <img src="{{ asset($banner->image) }}" alt="Healthcare" class="w-full h-[400px] sm:h-[600px] object-cover object-top">
        </div>
        @endforeach
    </div>
    <div class="swiper-pagination"></div>
</div> --}}

    @include('layouts.navbar')

    <div class="relative">
        <div class="swiper bannerSwiper">
            <div class="swiper-wrapper">
                @foreach ($banners as $banner)
                    <div class="border swiper-slide" data-header="{{ $banner->header }}"
                        data-subheader="{{ $banner->subheader }}">

                        <div>
                            {{-- This could be your text or overlay inside the slide --}}
                        </div>

                        <img src="{{ asset($banner->image) }}" alt="Healthcare"
                            class="w-full h-[400px] sm:h-[600px] object-cover object-top">
                    </div>
                @endforeach
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>

    {{-- Outside div that receives the data --}}
    <div id="banner-info"
        class="lg:absolute mt-4 top-[25%] lg:left-1/2 lg:transform lg:-translate-x-1/2 px-4 sm:px-6 text-center mb-4 
            w-full max-w-5xl">
        <div class="flex flex-col items-center justify-center gap-4 text-center lg:flex-row lg:gap-6">
            <div class="whitespace-normal lg:whitespace-nowrap">
                <span class="text-3xl font-bold text-blue-700 sm:text-4xl lg:text-5xl lg:flex lg:items-start lg:justify-start">Your Health,&nbsp;</span>
                <div id="banner-header" class="text-3xl font-bold sm:text-4xl lg:text-5xl"></div>
            </div>
            <div id="banner-subheader"
                class="flex items-center justify-center text-lg font-bold text-center lg:items-start lg:justify-start sm:text-xl lg:text-2xl lg:w-1/2 lg:text-left">
            </div>
        </div>
    </div>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />


    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const swiper = new Swiper(".bannerSwiper", {
                slidesPerView: 1,
                spaceBetween: 30,
                loop: true,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: ".swiper-pagination",
                    clickable: true,
                },
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                },
                on: {
                    init: function() {
                        updateBannerInfo(this.slides[this.activeIndex]);
                    },
                    slideChange: function() {
                        updateBannerInfo(this.slides[this.activeIndex]);
                    }
                }
            });

            function updateBannerInfo(activeSlide) {
                if (!activeSlide) return;
                const header = activeSlide.getAttribute("data-header") || "";
                const subheader = activeSlide.getAttribute("data-subheader") || "";

                document.getElementById("banner-header").textContent = header;
                document.getElementById("banner-subheader").textContent = subheader;

                adjustBannerFontSize();
            }

            function adjustBannerFontSize() {
                const bannerHeader = document.getElementById("banner-header");
                const maxLength = 20; // adjust this threshold

                if (bannerHeader.textContent.length > maxLength) {
                    bannerHeader.classList.remove("text-5xl");
                    bannerHeader.classList.add("text-4xl"); // smaller font for long text
                } else {
                    bannerHeader.classList.remove("text-4xl");
                    bannerHeader.classList.add("text-5xl"); // restore big font
                }
            }
        });
    </script>



    <style>
        .bannerSwiper {
            width: 100%;
            height: 100%;
        }

        .swiper-button-next,
        .swiper-button-prev {
            color: white;
            /* background: rgba(0, 0, 0, 0.3); */
            padding: 30px;
            /* border-radius: 50%; */
        }

        .swiper-button-next:hover,
        .swiper-button-prev:hover {
            /* background: rgba(0, 0, 0, 0.5); */
        }

        .swiper-pagination-bullet {
            background: white;
            opacity: 0.5;
        }

        .swiper-pagination-bullet-active {
            opacity: 1;
        }
    </style>



    @include('frontend.components.healthcareservice.healthcareservice')
    @include('frontend.components.about.about')
    @include('frontend.components.providing')
    @include('frontend.components.doctors.doctors')
    @include('frontend.components.testimonial.testimonial')
    @include('frontend.components.newsudpate.news')






@endsection
