<?php

namespace App\Http\Controllers;

use App\Models\About;
use Illuminate\Http\Request;

class AboutController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $abouts = About::get();
        return view('backend.aboutpage.backend.index', ['abouts' => $abouts]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.aboutpage.backend.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'header'    => 'required|string|max:255',
            'subheader' => 'required|string|max:255',
            'image'     => 'required|image|mimes:jpg,jpeg,png,gif|max:2048',
        ]);

        if ($request->hasFile('image')) {
            // Create unique filename
            $filename = time() . '_' . $request->file('image')->getClientOriginalName();

            // Move file to public/images/uploads
            $request->file('image')->move(public_path('images/uploads'), $filename);

            // Save relative path in DB
            $data['image'] = 'images/uploads/' . $filename;
        }

        About::create($data);

        $abouts = About::get();

        return view('backend.aboutpage.backend.index', compact('abouts'))->with('success', 'About created successfully!');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $abouts = About::findOrFail($id);

        return view('backend.aboutpage.backend.edit', compact('abouts'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $about = About::findOrFail($id);

        $data = $request->validate([
            'header'    => 'required|string|max:255',
            'subheader' => 'required|string|max:255',
            'image'     => 'nullable|image|mimes:jpg,jpeg,png,gif|max:2048',
        ]);

        // If a new image is uploaded
        if ($request->hasFile('image')) {
            // Delete old image if it exists
            if ($about->image && file_exists(public_path($about->image))) {
                unlink(public_path($about->image));
            }

            // Save new image
            $filename = time() . '_' . $request->file('image')->getClientOriginalName();
            $request->file('image')->move(public_path('images/uploads'), $filename);

            $data['image'] = 'images/uploads/' . $filename;
        } else {
            // Keep old image if no new one is uploaded
            $data['image'] = $about->image;
        }

        $about->update($data);

        $abouts = About::get();

        return view('backend.aboutpage.backend.index', compact('abouts'))->with('success', 'About updated successfully!');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $about = About::findOrFail($id);

        // Delete the image file if it exists
        if ($about->image && file_exists(public_path($about->image))) {
            unlink(public_path($about->image));
        }

        // Delete the record
        $about->delete();
        $abouts = About::get();

        return view('backend.aboutpage.backend.index', compact('abouts'))->with('success', 'About deleted successfully!');
    }
}
