<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="styles.css">
    <title>Styled Table</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Mono&display=swap" rel="stylesheet">

</head>
<style>
    body,
    table {
        margin: 0;
        padding: 0;
        font-family: 'Roboto Mono', 'Courier New', monospace;
    }

    table {
        width: 100%;
        font-size: 12px;
        margin: 0;
        padding: 0;
        table-layout: fixed;
        /* Ensures even spacing */
    }

    /* Set specific column widths */
    th:nth-child(1),
    td:nth-child(1) {
        width: 70%;
        /* Wider Product column */
        text-align: left;
        /* Align product name to the left */
        padding-left: 10px;
        padding: 0;
        /* Add spacing inside */
    }

    th:nth-child(2),
    td:nth-child(2) {
        width: 30%;
        /* Smaller Amount column */
        text-align: right;
        /* Align amounts to the right */
        padding-right: 10px;
        padding: 0;
    }

    /* Table headers */
    th {
        background-color: #f3f4f6;
        text-align: center;
        padding: 0;

    }

    /* Table cells */
    td {
        padding: 0;
    }

    /* Alternate row background */
    tbody tr:nth-child(even) {
        background-color: #f9fafb;
    }

    /* Hover effect (only for screen, not print) */
    tbody tr:hover {
        background-color: #e5e7eb;
    }

    /* PRINT STYLING */
    @media print {

        body,
        table {
            margin: 0;
            padding: 0;
        }

        table {
            width: 90%;
            font-size: 11px;
            font-family: 'Roboto Mono', 'Courier New', monospace;
        }

        /* Hide any buttons or unnecessary elements */
        button {
            display: none;
        }
    }
</style>

<body>
    <table>
        <thead>
            <tr>
                <th>Product</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>Product 1</td>
                <td>3,000</td>
            </tr>
            <tr>
                <td>Product 2</td>
                <td>3,000</td>
            </tr>
            <tr>
                <td>Product 3</td>
                <td>3,000</td>
            </tr>
            <tr>
                <td>Product 4</td>
                <td>3,000</td>
            </tr>
            <tr>
                <td>Product 5</td>
                <td>3,000</td>
            </tr>
            <tr>
                <td>Product 6</td>
                <td>3,000</td>
            </tr>
        </tbody>
    </table>
</body>

</html>
