<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Sidebar Layout')</title>

    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">


    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>

    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- Include Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    {{-- <link rel="stylesheet" href="{{ asset('build/assets/app-0fb16b19.css') }}">
    <script type="module" src="{{ asset('build/assets/app-db336233.js') }}"></script> --}}

    <meta name="csrf-token" content="{{ csrf_token() }}">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    {{-- <link rel="stylesheet" href="{{ asset('build/assets/app-0fb16b19.css') }}">
    <script type="module" src="{{ asset('build/assets/app-db336233.js') }}"></script> --}}
    <style>
        table.dataTable thead th {
            border-bottom: 1px solid #d1d5db;
            border-left: 1px solid #d1d5db;
            /* Left side border */
            border-right: 1px solid #d1d5db;
            /* Right side border */
            font-size: 12px;
            /* Text size for header cells */
            font-weight: bold;
            padding: 4px;
            /* Optional for bold headers */
        }


        table.dataTable thead th:first-of-type {
            border-left: none;
        }

        /* Body Cell Styling */
        table.dataTable td {
            border-bottom: 1px solid #d1d5db;
            border-left: 1px solid #d1d5db;
            /* Left side border */
            border-right: 1px solid #d1d5db;
            /* Right side border */
            font-size: 11px;
            /* Text size for header cells */
            font-weight: normal;
            padding: 0;
            /* Text size for body cells */
        }

        /* Footer Styling */
        table.dataTable tfoot th,
        table.dataTable tfoot td {
            border-top: 2px solid #d1d5db;
            /* Border at the top of footer cells */
            border-left: 1px solid #d1d5db;
            /* Left side border */
            border-right: 1px solid #d1d5db;
            /* Right side border */
            font-size: 11px;
            /* Text size for footer cells */
            font-weight: bold;
            /* Normal weight for footer cells */
        }


        /* Optional: Remove the border for the first footer cell to prevent double borders */
        table.dataTable tfoot th:first-of-type,
        table.dataTable tfoot td:first-of-type {
            border-left: none;
        }
    </style>



    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
</head>


<body class="bg-gray-100">






    <nav class="fixed z-50 w-full text-white bg-gray-900 shadow-lg ">
        <div class="container flex items-center justify-between px-4 py-1 mx-auto">
            <!-- Logo -->
            <div class="text-sm font-bold">
                @if (Auth::check())
                    <span class="hover:text-gray-300">{{ Auth::user()->name }}</span>
                @else
                    <a href="/login" class="hover:text-gray-300">Login</a>
                @endif
            </div>
            <div class="flex items-center gap-5 ">
                <div>
                    <div class="relative">
                        @if (!in_array('Employee UserInterface', $privileges))
                            <button id="notif-btn"
                                class="relative flex items-center gap-2 px-4 py-2 text-gray-700 hover:text-gray-900">
                                <svg class="w-6 h-6 text-gray-200 hover:text-white" fill="none" stroke="currentColor"
                                    stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M15 17h5l-1.405-1.405C18.214 14.835 18 14.091 18 13.318V11c0-2.485-1.343-4.635-3.5-5.74V5a2.5 2.5 0 00-5 0v.26C7.343 6.365 6 8.515 6 11v2.318c0 .773-.214 1.517-.595 2.277L4 17h5">
                                    </path>
                                </svg>
                                <span id="notif-count"
                                    class="absolute hidden px-2 py-1 text-xs font-bold text-white bg-red-500 rounded-full -top-1 -right-1">0</span>
                            </button>
                        @endif
                        <!-- Notification Dropdown -->
                        <div id="notif-dropdown"
                            class="absolute right-0 hidden mt-2 bg-white rounded-lg shadow-lg w-80">
                            <div class="p-2 font-semibold text-gray-700 border-b">Notifications</div>
                            <ul id="notification-list" class="overflow-auto divide-y divide-gray-200 max-h-64"></ul>
                            <div id="loading-spinner" class="hidden p-3 text-center text-gray-500">Loading...</div>
                        </div>
                    </div>


                </div>
                <div>
                    <button onclick="toggleSidebar()" type="button"
                        class="inline-flex items-center p-2 mt-2 text-sm border-b rounded-lg ms-3 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-gray-700 dark:focus:ring-gray-600">
                        <span class="sr-only">Open sidebar</span>
                        <svg class="w-6 h-6" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path clip-rule="evenodd" fill-rule="evenodd"
                                d="M2 4.75A.75.75 0 012.75 4h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 4.75zm0 10.5a.75.75 0 01.75-.75h7.5a.75.75 0 010 1.5h-7.5a.75.75 0 01-.75-.75zM2 10a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 10z">
                            </path>
                        </svg>
                    </button>
                </div>
            </div>

        </div>
    </nav>
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const content = document.getElementById('content');

            // Toggle sidebar visibility
            if (sidebar.classList.contains('translate-x-0')) {
                sidebar.classList.remove('translate-x-0');
                sidebar.classList.add('-translate-x-full');
            } else {
                sidebar.classList.remove('-translate-x-full');
                sidebar.classList.add('translate-x-0');
            }

            // Adjust content padding
            content.classList.toggle('lg:pl-[15rem]');
        }
    </script>
    <aside id="sidebar"
        class="fixed top-0 left-0   bg-gray-50 h-screen  transition-transform duration-300 transform translate-x-0  shadow-2xl">


        <div class=" px-3 py-4 mt-16 ">



            <ul class="space-y-2 font-medium  w-[14rem] h-[50rem] overflow-y-auto">

                @if (in_array('View Dashboard', $privileges))
                    <li>
                        <a href="{{ route('dashboard.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('dashboard.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class="text-2xl text-gray-500 transition duration-75 hover:text-white bx bxs-home"></i>

                            <span class="text-sm ms-3">Dashboard</span>
                        </a>
                    </li>
                @endif
                @if (in_array('Manage Agency', $privileges))
                    <li>
                        <a href="{{ route('agencies.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('agencies.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i
                                class='text-2xl text-gray-500 transition duration-75 bx bxs-envelope hover:text-white'></i>
                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Agency</span>

                        </a>
                    </li>
                @endif
                @if (in_array('Manage Company', $privileges))
                    <li>
                        <a href="{{ route('clients.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('clients.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">

                            <i
                                class='text-2xl text-gray-500 transition duration-75 bx bxs-buildings hover:text-white'></i>
                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Company</span>

                        </a>
                    </li>
                @endif
                @if (in_array('Manage Client', $privileges))
                    <li>
                        <a href="{{ route('departments.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('departments.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bx-box hover:text-white'></i>

                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Client</span>
                        </a>
                    </li>
                @endif

                @if (in_array('Manage Requisition', $privileges))
                    <li>
                        <a href="{{ route('requisitions.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('requisitions.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i
                                class='text-2xl text-gray-500 transition duration-75 bx bx-git-pull-request hover:text-white'></i>

                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">MRF</span>
                        </a>
                    </li>
                @endif
                @if (in_array('Manage Requisition', $privileges))
                    <li>
                        <a href="{{ route('store_menu.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('store_menu.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bxs-store hover:text-white'></i>

                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Store</span>
                        </a>
                    </li>
                @endif

                @if (in_array('Manage Employee', $privileges))
                    <li>
                        <button id="employeeDropdown" data-dropdown-toggle="dropdownMenu"
                            class="flex items-center w-full p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white modal-button {{ request()->routeIs('shifts.index') || request()->routeIs('forapproval.index') || request()->routeIs('employees.index') || request()->routeIs('leaves.index') || request()->routeIs('clearance.index') || request()->routeIs('bank.index') || request()->routeIs('employees.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i
                                class="text-2xl text-gray-500 transition duration-75 bx bxs-briefcase-alt-2 hover:text-white"></i>
                            <span class="block px-4 py-2 text-sm">Employees</span>
                        </button>
                        <div id="dropdownMenu"
                            class="{{ request()->routeIs('forapproval.index') || request()->routeIs('leaves.index') || request()->routeIs('shifts.index') || request()->routeIs('clearance.index') || request()->routeIs('bank.index') || request()->routeIs('employees.index') ? '' : 'hidden' }} mt-2 w-full bg-white rounded-md">
                            <ul class="py-1 ml-10 text-sm">
                                <!-- Approval Link -->
                                <li class="my-2">
                                    <a href="{{ route('forapproval.index') }}"
                                        class="block px-4 py-2   text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('forapproval.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        Applicants
                                    </a>
                                </li>
                                <!-- Employee List Link -->
                                <li class="my-2">
                                    <a href="{{ route('employees.index') }}"
                                        class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('employees.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        Employee List
                                    </a>
                                </li>
                                @if (in_array('Manage Banks', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('bank.index') }}"
                                            class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('bank.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Bank
                                        </a>
                                    </li>
                                @endif
                                <li class="my-2">
                                    <a href="{{ route('leaves.index') }}"
                                        class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('leaves.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        Leave
                                    </a>
                                </li>

                                <li class="my-2">
                                    <a href="{{ route('over_under_time_request.index') }}"
                                        class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('over_under_time_request.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        Request
                                    </a>
                                </li>


                                @if (in_array('Manage Clearance', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('clearance.index') }}"
                                            class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('clearance.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Clearance
                                        </a>
                                    </li>
                                @endif
                                @if (in_array('Employee Schedule', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('shifts.index') }}"
                                            class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('shifts.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Work Periods
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </div>
                    </li>
                @endif




                @if (in_array('wage management', $privileges))
                    <li>
                        <button id="WageDropdown" data-dropdown-toggle="dropdownMenuwage"
                            class="flex items-center w-full p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white modal-button {{ request()->routeIs('Employee_wage.index') || request()->routeIs('assignwage.get') || request()->routeIs('regiontable.get') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i
                                class="text-2xl text-gray-500 transition duration-75 bx bx-dollar-circle hover:text-white"></i>
                            <span class="block px-4 py-2 text-sm">Wage</span>
                        </button>
                        <div id="dropdownMenuwage"
                            class="{{ request()->routeIs('Employee_wage.index') || request()->routeIs('regiontable.get') || request()->routeIs('assignwage.get') ? '' : 'hidden' }} mt-2 w-full bg-white rounded-md">
                            <ul class="py-1 ml-10 text-sm">
                                @if (in_array('Regions', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('regiontable.get') }}"
                                            class="block px-4 py-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white {{ request()->routeIs('regiontable.get') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Rates
                                        </a>
                                    </li>
                                @endif
                                @if (in_array('Regional wage rates', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('Employee_wage.index') }}"
                                            class="block px-4 py-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white {{ request()->routeIs('Employee_wage.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Rates Adjustment
                                        </a>
                                    </li>
                                @endif
                                @if (in_array('Wage Assigning', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('assignwage.get') }}"
                                            class="block px-4 py-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white {{ request()->routeIs('assignwage.get') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Wage Assignments
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </div>
                    </li>
                @endif
                @if (in_array('Manage Attendance', $privileges))
                    <li>
                        <button id="attendanceDropdown" data-dropdown-toggle="dropdownMenu1"
                            class="flex items-center w-full p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white modal-button {{ request()->routeIs('deduction') || request()->routeIs('payroll.summary') || request()->routeIs('attendance.index') || request()->routeIs('attendance.index1') || request()->routeIs('overtime.index') || request()->routeIs('ptsr.index') || request()->routeIs('ptsr.index') || request()->routeIs('earnings') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i
                                class='text-2xl text-gray-500 transition duration-75 bx bxs-book-content hover:text-white'></i>
                            <span class="block px-4 py-2 text-sm">Time Keeping</span>
                        </button>
                        <div id="dropdownMenu1"
                            class="{{ request()->routeIs('deduction') || request()->routeIs('earnings') || request()->routeIs('attendance.index') || request()->routeIs('payroll.summary') || request()->routeIs('attendance.index1') || request()->routeIs('overtime.index') || request()->routeIs('ptsr.index') || request()->routeIs('ptsr.index') ? '' : 'hidden' }} mt-2 w-full bg-white rounded-md">
                            <ul class="py-1 ml-10 text-sm">
                                <!-- Approval Link -->
                                <li class="my-2">
                                    <a href="{{ route('attendance.index') }}"
                                        class="block px-4 py-2  text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('attendance.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        DTR
                                    </a>
                                </li>
                                <!-- Employee List Link -->
                                {{-- <li class="my-2">
                                    <a href="{{ route('attendance.index1') }}"
                                        class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('attendance.index1') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        Incomplete (Missing Time In/Out)
                                    </a>
                                </li> --}}
                                @if (in_array('View Dashboard', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('overtime.index') }}"
                                            class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('overtime.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Overtime Request
                                        </a>
                                    </li>
                                @endif

                                <li class="my-2">
                                    <a href="{{ route('ptsr.index') }}"
                                        class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('ptsr.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        PTSR
                                    </a>
                                </li>
                                <li class="my-2">
                                    <a href="{{ route('payroll.summary') }}"
                                        class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('payroll.summary') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        Payroll Summary
                                    </a>
                                </li>
                                <li class="my-2">
                                    <a href="{{ route('earnings', ['status' => 'earning']) }}"
                                        class="block px-4 py-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white 
                                        {{ request()->routeIs('earnings') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        Earnings
                                    </a>
                                </li>
                                <li class="my-2">
                                    <a href="{{ route('deduction', ['status' => 'deduction']) }}"
                                        class="block px-4 py-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white 
                                        {{ request()->routeIs('deduction') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        Deduction
                                    </a>
                                </li>

                            </ul>
                        </div>
                    </li>
                @endif
                @if (in_array('Dtr Request', $privileges))
                    <li>
                        <a href="{{ route('dtr_requests.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('dtr_requests.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bx-git-pull-request hover:text-white'></i>

                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">DTR Request</span>
                        </a>
                    </li>
                @endif
                @if (in_array('Manage Payroll', $privileges))
                    <li>
                        <button id="PayrollDropdown" data-dropdown-toggle="dropdownMenupayroll"
                            class="flex items-center w-full p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white modal-button {{ request()->routeIs('payrollchecking.index') || request()->routeIs('payrollchecking.index') || request()->routeIs('payrolls.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bx-money hover:text-white'></i>
                            <span class="block px-4 py-2 text-sm">Payroll</span>
                        </button>
                        <div id="dropdownMenupayroll"
                            class="{{ request()->routeIs('payrollchecking.index') || request()->routeIs('payrolls.index') || request()->routeIs('finalpayroll.index') || request()->routeIs('mortuaries.index') || request()->routeIs('loans.index') || request()->routeIs('payroll.get') || (request()->routeIs('deduction.get') && request()->route('id')) ? 'bg-gray-900 text-white font-semibold' : 'hidden' }}  mt-2 w-full bg-white rounded-md">
                            <ul class="py-1 ml-10 text-sm">
                                <!-- Approval Link -->
                                @if (in_array('Create Payroll', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('payrolls.index') }}"
                                            class="block px-4 py-2  text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('payrolls.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Payroll Creation
                                        </a>
                                    </li>
                                @endif
                                @if (in_array('Payroll Checking', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('payrollchecking.index') }}"
                                            class="block px-4 py-2  text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('payrollchecking.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Payroll (for Checking)
                                        </a>
                                    </li>
                                @endif
                                @if (in_array('Payroll Approve', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('finalpayroll.index') }}"
                                            class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('finalpayroll.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Payroll (final)
                                        </a>
                                    </li>
                                @endif
                                {{-- <li class="my-2">
                                    <a href="{{ route('loans.index') }}"
                                        class="block px-4 py-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white 
                                        {{ request()->routeIs('loans.index') || request()->routeIs('mortuaries.index') || (request()->routeIs('deduction.get') && request()->route('id')) ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                        Payroll Deduction
                                    </a>
                                </li> --}}


                            </ul>
                        </div>
                    </li>
                @endif


                @if (in_array('Manage Billing', $privileges))
                    <li>
                        <button id="billingDropdown" data-dropdown-toggle="dropdownMenubilling"
                            class="{{ request()->routeIs('billings.index') ||
                            request()->routeIs('final.index') ||
                            request()->routeIs('billings.get')
                                ? 'bg-gray-900 text-white font-semibold'
                                : '' }} flex items-center w-full p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white modal-button">
                            <i
                                class='text-2xl text-gray-500 transition duration-75 bx bxs-file-blank hover:text-white'></i>
                            <span class="block px-4 py-2 text-sm">Billing</span>
                        </button>

                        <div id="dropdownMenubilling"
                            class="{{ request()->routeIs('billings.index') || request()->routeIs('billings.index') || request()->routeIs('final.index') || request()->routeIs('billings.get') ? '' : 'hidden' }} mt-2 w-full bg-white rounded-md">
                            <ul class="py-1 ml-10 text-sm">
                                @if (in_array('Billing Checking', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('billings.index') }}"
                                            class="block px-4 py-2  text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('billings.index') || request()->routeIs('billings.get') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            For Checking
                                        </a>
                                    </li>
                                @endif
                                @if (in_array('Billing Approval', $privileges))
                                    <li class="my-2">
                                        <a href="{{ route('final.index') }}"
                                            class="block px-4 py-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('final.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                                            Final Billing
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </div>
                    </li>
                @endif


                {{-- @if (in_array('Manage Users', $privileges))
                    <li>
                        <a href="{{ route('users.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('setting.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i
                                class='text-2xl text-gray-500 transition duration-75 bx bxs-dock-left hover:text-white'></i>

                            <span class="flex-1 ms-3 whitespace-nowrap">Billings</span>

                        </a>
                    </li>
                @endif --}}

                @if (in_array('Manage Users', $privileges))
                    <li>
                        <a href="{{ route('users.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('users.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bx-user hover:text-white'></i>
                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">User</span>

                        </a>
                    </li>
                @endif
                @if (in_array('Trx', $privileges))
                    <li>
                        <a href="{{ route('trx_groupcodes.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('trx_groupcodes.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bx-box hover:text-white'></i>

                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">TRX</span>
                        </a>
                    </li>
                @endif
                @if (in_array('Manage Settings', $privileges))
                    <li>
                        <a href="{{ route('settings.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('settings.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bx-cog hover:text-white'></i>
                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Setting</span>

                        </a>
                    </li>
                @endif
                @if (in_array('Scanner', $privileges))
                    <li>
                        <a href="{{ url('admin/scanner') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg  hover:bg-gray-900 hover:text-white {{ request()->routeIs('setting.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bx-scan hover:text-white'></i>
                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Scanner</span>

                        </a>
                    </li>
                @endif






                @if (in_array('Employee UserInterface', $privileges))
                    <div class="flex justify-center">
                        @php
                            // Fetch the employee using 'first()' to get the first (or only) matching record
                            $employee = \App\Models\Employee::where('user_id', Auth::user()->id)->first();
                        @endphp

                        {{-- @if ($employee)
                            <img src="https://api.qrserver.com/v1/create-qr-code/?data={{ urlencode($employee->id) }}&size=500x500"
                                alt="QR Code for Employee ID" title="QR Code for Employee ID" class="w-32 h-32">
                        @else
                            <p>No employee found for the current user.</p>
                        @endif --}}
                    </div>
                    <li>
                        <a href="{{ route('pre.profile1') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white {{ request()->routeIs('pre.profile1') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bx-box hover:text-white'></i>
                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Profile</span>
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('settings.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white {{ request()->routeIs('settings.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bx-box hover:text-white'></i>
                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Change Pass</span>
                        </a>
                    </li>
                @endif
                @if (in_array('Client Interface', $privileges))
                    <li>
                        <a href="{{ route('departments1.employees.show') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white {{ request()->routeIs('departments1.employees.show') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bx-box hover:text-white'></i>
                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Profile</span>
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('final.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white {{ request()->routeIs('final.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i
                                class='text-2xl text-gray-500 transition duration-75 bx bxs-book-content hover:text-white'></i>
                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Billing</span>
                        </a>
                    </li>
                @endif
                @if (in_array('Reports', $privileges))
                    <li>
                        <a href="{{ route('reports.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white {{ request()->routeIs('reports.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i
                                class='text-2xl text-gray-500 transition duration-75 bx bxs-book-content hover:text-white'></i>
                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Reports</span>
                        </a>
                    </li>
                @endif
                @if (in_array('Manage Client Banks', $privileges))
                    <li>
                        <a href="{{ route('bank-profiles.index') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white {{ request()->routeIs('bank-profiles.index') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i class='text-2xl text-gray-500 transition duration-75 bx bxs-bank hover:text-white'></i>

                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Banks</span>
                        </a>
                    </li>
                @endif
                @if (in_array('Custom Benefits Setup', $privileges))
                    <li>
                        <a href="{{ route('benefits.createBenegfits') }}"
                            class="flex items-center p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white {{ request()->routeIs('benefits.createBenegfits') ? 'bg-gray-900 text-white font-semibold' : '' }}">
                            <i
                                class='text-2xl text-gray-500 transition duration-75 bx bx-customize hover:text-white'></i>




                            <span class="flex-1 text-sm ms-3 whitespace-nowrap">Cutom Benefits Setup</span>
                        </a>
                    </li>
                @endif
                <li>
                    <button id="logout-button"
                        class="p-2 text-gray-900 rounded-lg hover:bg-gray-900 hover:text-white">
                        <i class='text-2xl text-gray-500 bx bx-log-in hover:text-white'></i>
                        <span class="px-4 py-2 text-sm">Log Out</span>
                    </button>
                </li>


            </ul>
        </div>

    </aside>


    @if (in_array('Toggle Button', $privileges))
        <div class="fixed z-50 flex items-center justify-center w-16 h-16 text-white transition-transform transform bg-blue-500 rounded-full shadow-lg cursor-pointer bottom-5 right-5 draggable"
            id="floating-btn">
            <i class="fas fa-plus"></i>
        </div>
    @endif
    <!-- This is the new div that will appear near the floating button when clicked -->
    <div id="popup-div"
        class="fixed z-40 hidden p-5 text-black bg-white border-2 border-black rounded-lg shadow-lg right-5">
        <div class="overflow-auto">
            <p class="p-4 font-bold"> Employee List</p>
            <table id="employed-table1" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
                <thead>
                    <tr class="h-12 text-sm leading-normal ">
                        <th class="px-6 py-1">ID</th>
                        <th class="px-6 py-1">Profile</th>
                        <th class="px-6 py-1">Name</th>
                        <th class="px-6 py-1">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                </tbody>
            </table>
        </div>
        <script>
            var employedTable = $('#employed-table1').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('employees.index') }}",
                    data: function(d) {
                        d.status = '1'; // Filter by Employed status
                    }
                },
                columns: [{
                        data: 'id',
                        name: 'id'
                    },

                    {
                        data: 'profile',
                        name: 'profile'
                    },
                    {
                        data: 'employee_name',
                        name: 'employee_name'
                    },

                    {
                        data: 'action1',
                        name: 'action1',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });
        </script>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/js/all.min.js"></script>

    <script>
        // JavaScript to make the button draggable
        const btn = document.getElementById('floating-btn');
        const popupDiv = document.getElementById('popup-div');

        btn.onmousedown = function(e) {
            let offsetX = e.clientX - btn.getBoundingClientRect().left;
            let offsetY = e.clientY - btn.getBoundingClientRect().top;

            document.onmousemove = function(e) {
                btn.style.left = e.clientX - offsetX + 'px';
                btn.style.top = e.clientY - offsetY + 'px';
                popupDiv.style.left = e.clientX - offsetX + 'px'; // Move popup with button
                popupDiv.style.top = e.clientY - offsetY + 24 + 'px'; // Adjust position to be next to button
            };

            document.onmouseup = function() {
                document.onmousemove = null;
                document.onmouseup = null;
            };

            // Prevents text selection while dragging
            e.preventDefault();
        };

        // JavaScript to show the popup when the button is clicked
        btn.onclick = function() {
            if (popupDiv.classList.contains('hidden')) {
                popupDiv.classList.remove('hidden');
            } else {
                popupDiv.classList.add('hidden');
            }
        };
    </script>



    <div id="content" class="pt-16 transition-all duration-300 lg:pl-[15rem]">

        <div class="p-4">

            @yield('content')
        </div>
    </div>

    @include('layouts.notification')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const dropdownToggles = document.querySelectorAll('[data-dropdown-toggle]');

            dropdownToggles.forEach(button => {
                const menuId = button.getAttribute('data-dropdown-toggle');
                const menu = document.getElementById(menuId);

                button.addEventListener('click', function(e) {
                    e.stopPropagation(); // Prevent click from bubbling
                    menu.classList.toggle('hidden');
                });

                document.addEventListener('click', function(event) {
                    if (!button.contains(event.target) && !menu.contains(event.target)) {
                        menu.classList.add('hidden');
                    }
                });
            });
        });
    </script>


    <div class="relative w-full ">
        <div id="logout-form-modal"
            class="pd-overlay  hidden w-full h-full fixed top-0 left-0 z-[100]   overflow-x-hidden overflow-y-auto flex items-start justify-center bg-opacity-60 bg-black ">
            <div class="w-full max-w-md p-6 mt-10 bg-white rounded-lg shadow-lg">
                <div class="flex items-center justify-between mb-4">
                    <h5 class="text-lg font-semibold" id="logoutModalLabel">Confirm Logout</h5>

                </div>
                <div class="mb-4">
                    <p>Are you sure you want to log out?</p>
                </div>
                <div class="flex justify-end gap-4">
                    <button type="button"
                        class="py-2.5 px-5 text-xs bg-indigo-50 text-indigo-500  rounded cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-100 close-modal-button"
                        id="cancel-button">Cancel</button>
                    <form action="{{ route('logout') }}" method="POST" id="logout-form">
                        @csrf
                        <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Logout</button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script>
        const modal = document.getElementById('logout-form-modal');
        document.getElementById('logout-button').onclick = () => modal.classList.toggle('hidden');
        document.getElementById('cancel-button').onclick = () => modal.classList.add('hidden');
    </script>

</body>

</html>
