<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'pre-employement form')</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/pagedone@1.2.2/src/css/pagedone.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/pagedone@1.2.2/src/js/pagedone.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css" rel="stylesheet">
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    @vite('resources/css/app.css')
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
</head>

<body class="bg-gray-100">
    <div class="container p-5 mx-auto">
        <h2 class="mb-5 text-2xl font-bold text-center">Pre Onboard</h2>

        <form action="{{ route('addnewemployee') }}" enctype="multipart/form-data" method="POST">
            @csrf
            @if ($errors->any())
                <div class="alert alert-danger text-red-600 text-center">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="flex flex-col gap-10 md:flex-row">
                <div class="w-[20rem]   h-[40rem] ">
                    <div class="flex flex-col p-4 bg-white border-2 border-black">
                        <p class="text-xl font-bold">PERSONAL DATA</p>
                        <div id="imagePreview" class="flex justify-center mt-2">
                            <img id="preview" src="#" alt="Image Preview"
                                class="object-cover h-48 border border-gray-300 w-44" />
                        </div>
                        <div class="mt-4">
                            <label for="imageUpload" class="block mb-2 text-sm font-medium text-gray-700">Attach
                                Image:</label>
                            <input type="file" id="imageUpload" name="profile" accept="image/*"
                                class="w-full p-2 mb-4 border border-gray-300" onchange="previewImage(event)">
                        </div>
                    </div>
                    <script>
                        function previewImage(event) {
                            const preview = document.getElementById('preview');
                            const imagePreview = document.getElementById('imagePreview');
                            const file = event.target.files[0];

                            if (file) {
                                const reader = new FileReader();
                                reader.onload = function(e) {
                                    preview.src = e.target.result;
                                    preview.classList.remove('hidden');
                                };
                                reader.readAsDataURL(file);
                            } else {
                                preview.src = "#";
                                preview.classList.add('hidden');
                            }
                        }
                    </script>


                    <div class="bg-white p-2 mt-5 border-2 border-black rounded-md">
                        <div>
                            <label class="block mb-1 text-gray-600" for="pwd">Select Disability Status</label>
                            <select id="pwd" name="pwd" class="w-full p-2 border-2 border-black rounded-md"
                                required onchange="toggleFileInput()">
                                <option value="" disabled {{ old('pwd') == '' ? 'selected' : '' }}>Please select
                                    an
                                    option</option>
                                <option value="PWD" {{ old('pwd') == 'PWD' ? 'selected' : '' }}>Person with
                                    Disability
                                    (PWD)</option>
                                <option value="Not PWD" {{ old('pwd') == 'Not PWD' ? 'selected' : '' }}>Not a Person
                                    with
                                    Disability</option>
                            </select>
                            @error('pwd')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- This is the file input, initially hidden -->
                        <div id="file-input-container" class="hidden mt-4">
                            <label class="block mb-1 text-gray-600" for="file">Upload Supporting Document
                                (Optional)</label>
                            <input type="file" id="file" name="file"
                                class="w-full p-2 border-2 border-black rounded-md">
                            @error('file')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                    </div>
                    <div class="bg-white p-2 mt-5 border-2 border-black rounded-md">
                        <div>
                            <input hidden name="Name" value="Resume">
                        </div>
                        <div class=" mt-4">
                            <label class="block mb-1 text-gray-600" for="resume">Upload Resume File</label>
                            <input type="file" id="file" name="resume"
                                class="w-full p-2 border-2 border-black rounded-md">
                            @error('resume')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                    </div>
                    <script>
                        function toggleFileInput() {
                            var pwdSelect = document.getElementById('pwd');
                            var fileInputContainer = document.getElementById('file-input-container');
                            if (pwdSelect.value === 'PWD') {
                                fileInputContainer.classList.remove('hidden');
                            } else {
                                fileInputContainer.classList.add('hidden');
                            }
                        }
                        window.onload = function() {
                            toggleFileInput();
                        };
                    </script>



                </div>
                <div class="p-2 ">
                    <h3 class="mb-4 text-xl font-semibold">Personal Details</h3>
                    <div class="p-4 ">
                        <div
                            class="grid grid-cols-1 gap-4 p-4 mb-4 bg-white border-2 border-black lg:grid-cols-2 rounded-xl">
                            <div class="p-2">
                                <label for="last_name" class="block mb-1">Last Name:</label>
                                <input type="text" name="last_name" id="last_name"
                                    class="w-full p-2 border border-black rounded-md"
                                    placeholder="Surname, Given Name, Extension, Middle Name"
                                    value="{{ old('last_name') }}" />
                                @error('last_name')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="p-2 ">
                                <label for="first_name" class="block mb-1">First Name:</label>
                                <input type="text" name="first_name" id="first_name"
                                    class="w-full p-2 border border-black rounded-md"
                                    placeholder="Surname, Given Name, Extension, Middle Name"
                                    value="{{ old('first_name') }}" />
                                @error('first_name')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="p-2 ">
                                <label for="middle_name" class="block mb-1">Middle Name (optional):</label>
                                <input type="text" name="middle_name" id="middle_name"
                                    class="w-full p-2 border border-black rounded-md"
                                    placeholder="Surname, Given Name, Extension, Middle Name"
                                    value="{{ old('middle_name') }}" />
                                @error('middle_name')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="p-2 ">
                                <label for="email" class="block mb-1">Email:</label>
                                <input type="email" name="email" id="email" c
                                    class="w-full p-2 border border-black rounded-md"
                                    placeholder="Surname, Given Name, Extension, Middle Name"
                                    value="{{ old('email') }}" />
                                @error('email')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                        </div>

                        <div
                            class="grid grid-cols-1 gap-4 p-4 mb-4 bg-white border-2 border-black lg:grid-cols-2 rounded-xl">
                            <div class="p-2 ">
                                <label for="present_address" class="block mb-1">Present Address:</label>
                                <input type="text" name="present_address" id="present_address"
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('present_address') }}" />
                                @error('present_address')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="p-2 ">
                                <label for="provincial_address" class="block mb-1">Provincial Address:</label>
                                <input type="text" name="provincial_address" id="provincial_address"
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('provincial_address') }}" />
                                @error('provincial_address')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="p-2">
                                <label for="mobile_number" class="block mb-1">Mobile No:</label>
                                <input type="text" name="mobile_number" id="mobile_number"
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('mobile_no') }}" />
                                @error('mobile_number')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="p-2 ">
                                <label for="alternative_number" class="block mb-1">Alternative Number:</label>
                                <input type="text" name="alternative_number" id="alternative_number"
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('alternative_number') }}" />
                                @error('alternative_number')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="p-4 mb-4 bg-white border-2 border-black rounded-xl">
                            <div class="grid grid-cols-1 gap-4  lg:grid-cols-3 ">
                                <div class="p-2">
                                    <label for="date_of_birth" class="block mb-1">Date of Birth:</label>
                                    <input type="date" name="date_of_birth" id="date_of_birth"
                                        class="w-full p-2 border border-black rounded-md"
                                        value="{{ old('date_of_birth') }}" />
                                    @error('date_of_birth')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="p-2">
                                    <label for="age" class="block mb-1">Age:</label>
                                    <input type="number" name="age" id="age"
                                        class="w-full p-2 border border-black rounded-md" value="{{ old('age') }}"
                                        readonly />
                                    @error('age')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>
                                <script>
                                    document.getElementById('date_of_birth').addEventListener('change', function() {
                                        const dob = new Date(this.value);
                                        const today = new Date();
                                        let age = today.getFullYear() - dob.getFullYear();
                                        const m = today.getMonth() - dob.getMonth();
                                        if (m < 0 || (m === 0 && today.getDate() < dob.getDate())) {
                                            age--;
                                        }

                                        if (!isNaN(age)) {
                                            document.getElementById('age').value = age;
                                        } else {
                                            document.getElementById('age').value = '';
                                        }
                                    });

                                    // Optional: Trigger calculation on page load if date is already filled
                                    window.addEventListener('DOMContentLoaded', function() {
                                        const dobField = document.getElementById('date_of_birth');
                                        if (dobField.value) {
                                            dobField.dispatchEvent(new Event('change'));
                                        }
                                    });
                                </script>

                                <div class="p-2 ">
                                    <label for="place_of_birth" class="block mb-1">Place of Birth:</label>
                                    <input type="text" name="place_of_birth" id="place_of_birth"
                                        class="w-full p-2 border border-black rounded-md"
                                        value="{{ old('place_of_birth') }}" />
                                    @error('place_of_birth')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="p-4">
                                <div class="space-y-2 flex items-center flex-col justify-center">
                                    <p class="text-sm font-medium text-gray-700">Sex</p>
                                    <div class="flex flex-col space-y-2 md:flex-row md:space-y-0 md:space-x-4">
                                        <label for="male"
                                            class="flex items-center px-4 py-2 border-2 border-black rounded-md cursor-pointer">
                                            <input type="radio" name="sex" id="male" value="M"
                                                class="form-radio text-blue-600"
                                                {{ old('sex') == 'M' ? 'checked' : '' }}>
                                            <span class="ml-2 text-gray-800">Male</span>
                                        </label>

                                        <label for="F"
                                            class="flex items-center px-4 py-2 border-2 border-black rounded-md cursor-pointer">
                                            <input type="radio" name="sex" id="F" value="F"
                                                class="form-radio text-pink-600"
                                                {{ old('sex') == 'F' ? 'checked' : '' }}>
                                            <span class="ml-2 text-gray-800">Female</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="p-4 mb-4 bg-white border-2 border-black rounded-xl">

                            <div class="h-auto p-2">
                                <label class="block mb-1">Civil Status:</label>

                                <div class="flex flex-col justify-between px-20 space-x-4 md:flex-row">
                                    <div class="flex items-center w-full p-2 border border-black rounded-md">
                                        <input type="radio" name="civil_status" value="single" id="single"
                                            {{ old('civil_status') == 'single' ? 'checked' : '' }}>
                                        <label for="single" class="ml-2">Single</label>
                                    </div>
                                    <div class="flex items-center w-full p-2 border border-black rounded-md">
                                        <input type="radio" name="civil_status" value="married" id="married"
                                            {{ old('civil_status') == 'married' ? 'checked' : '' }}>
                                        <label for="married" class="ml-2">Married</label>
                                    </div>
                                    <div class="flex items-center w-full p-2 border border-black rounded-md">
                                        <input type="radio" name="civil_status" value="head_of_family"
                                            id="head_of_family"
                                            {{ old('civil_status') == 'head_of_family' ? 'checked' : '' }}>
                                        <label for="head_of_family" class="ml-2">Head of the Family</label>
                                    </div>
                                    <div class="flex items-center w-full p-2 border border-black rounded-md">
                                        <input type="radio" name="civil_status" value="widow" id="widow"
                                            {{ old('civil_status') == 'widow' ? 'checked' : '' }}>
                                        <label for="widow" class="ml-2">Widow/er</label>
                                    </div>
                                </div>

                                @error('civil_status')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                        </div>

                        <div
                            class="grid grid-cols-1 gap-4 p-4 mb-4 bg-white border-2 border-black lg:grid-cols-4 rounded-xl">



                            <div class="p-2 ">
                                <label for="nationality" class="block mb-1">Nationality:</label>
                                <select name="nationality" id="nationality"
                                    class="w-full p-2 border border-black rounded-md">
                                    <option value="">Loading nationalities...</option>
                                </select>
                                @error('nationality')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>



                            <script>
                                document.addEventListener('DOMContentLoaded', function() {
                                    fetch('https://restcountries.com/v3.1/all?fields=name,demonyms')
                                        .then(response => response.json())
                                        .then(data => {
                                            const select = document.getElementById('nationality');
                                            select.innerHTML = '<option value="">-- Select Nationality --</option>';

                                            // Create a Set to avoid duplicates
                                            const nationalities = new Set();

                                            data.forEach(country => {
                                                const demonym = country?.demonyms?.eng?.m;
                                                if (demonym) nationalities.add(demonym);
                                            });

                                            // Sort and add to select
                                            Array.from(nationalities).sort().forEach(nationality => {
                                                const option = document.createElement('option');
                                                option.value = nationality;
                                                option.textContent = nationality;
                                                select.appendChild(option);
                                            });
                                        })
                                        .catch(error => {
                                            console.error('Error fetching nationalities:', error);
                                            document.getElementById('nationality').innerHTML =
                                                '<option value="">Failed to load nationalities</option>';
                                        });
                                });
                            </script>



                            <div class="p-2">
                                <label for="religion" class="block mb-1">Religion:</label>
                                <select name="religion" id="religion" class="w-full p-2 border-2 border-black">
                                    <option value="">-- Select Religion --</option>

                                    <option value="Roman Catholic"
                                        {{ old('religion') == 'Roman Catholic' ? 'selected' : '' }}>
                                        Roman Catholic
                                    </option>

                                    <option value="Iglesia ni Cristo"
                                        {{ old('religion') == 'Iglesia ni Cristo' ? 'selected' : '' }}>
                                        Iglesia ni Cristo
                                    </option>

                                    <option value="Evangelical Christianity"
                                        {{ old('religion') == 'Evangelical Christianity' ? 'selected' : '' }}>
                                        Evangelical Christianity
                                    </option>

                                    <option value="Protestant"
                                        {{ old('religion') == 'Protestant' ? 'selected' : '' }}>
                                        Protestant
                                    </option>

                                    <option value="Islam" {{ old('religion') == 'Islam' ? 'selected' : '' }}>
                                        Islam (Muslim)
                                    </option>

                                    <option value="Aglipayan" {{ old('religion') == 'Aglipayan' ? 'selected' : '' }}>
                                        Aglipayan (Philippine Independent Church)
                                    </option>

                                    <option value="Buddhism" {{ old('religion') == 'Buddhism' ? 'selected' : '' }}>
                                        Buddhism
                                    </option>

                                    <option value="Hinduism" {{ old('religion') == 'Hinduism' ? 'selected' : '' }}>
                                        Hinduism
                                    </option>

                                    <option value="Judaism" {{ old('religion') == 'Judaism' ? 'selected' : '' }}>
                                        Judaism
                                    </option>

                                    <option value="Atheism" {{ old('religion') == 'Atheism' ? 'selected' : '' }}>
                                        Atheism / Non-religious
                                    </option>

                                    <option value="Other" {{ old('religion') == 'Other' ? 'selected' : '' }}>
                                        Other
                                    </option>
                                </select>
                                @error('religion')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="p-2">
                                <label for="height" class="block mb-1">Height (cm):</label>
                                <input type="number" name="height" id="height" step="0.1" min="0"
                                    class="w-full p-2 border border-black rounded-md" value="{{ old('height') }}" />
                                @error('height')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="p-2">
                                <label for="weight" class="block mb-1">Weight (kg):</label>
                                <input type="number" name="weight" id="weight" step="0.1" min="0"
                                    class="w-full p-2 border border-black rounded-md" value="{{ old('weight') }}" />
                                @error('weight')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                        </div>
                        <div
                            class="grid grid-cols-1 gap-4 p-4 mb-4 bg-white border-2 border-black lg:grid-cols-2 rounded-xl">
                            <div class="p-2 ">
                                <label for="spouse_name" class="block mb-1">Name of Spouse (if married):</label>
                                <input type="text" name="spouse_name" id="spouse_name"
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('spouse_name') }}" />
                                @error('spouse_name')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="p-2 ">
                                <label for="spouse_occupation" class="block mb-1">Occupation:</label>
                                <input type="text" name="spouse_occupation" id="spouse_occupation"
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('spouse_occupation') }}" />
                                @error('spouse_occupation')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="p-2 ">
                                <label for="mother_maiden_name"
                                    class="block text-sm font-medium text-gray-700">Mother's
                                    Maiden
                                    Name</label>
                                <input type="text" name="mother_maiden_name" id="mother_maiden_name" required
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('mother_maiden_name') }}" />
                                @if ($errors->has('mother_maiden_name'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('mother_maiden_name') }}</span>
                                @endif
                            </div>

                            <div class="p-2 ">
                                <label for="mother_occupation"
                                    class="block text-sm font-medium text-gray-700">Mother's
                                    Occupation</label>
                                <input type="text" name="mother_occupation" id="mother_occupation" required
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('mother_occupation') }}" />
                                @if ($errors->has('mother_occupation'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('mother_occupation') }}</span>
                                @endif
                            </div>

                            <div class="p-2 ">
                                <label for="father_name" class="block text-sm font-medium text-gray-700">Father's
                                    Name</label>
                                <input type="text" name="father_name" id="father_name" required
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('father_name') }}" />
                                @if ($errors->has('father_name'))
                                    <span class="text-sm text-red-500">{{ $errors->first('father_name') }}</span>
                                @endif
                            </div>

                            <div class="p-2 ">
                                <label for="father_occupation"
                                    class="block text-sm font-medium text-gray-700">Father's
                                    Occupation</label>
                                <input type="text" name="father_occupation" id="father_occupation" required
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('father_occupation') }}" />
                                @if ($errors->has('father_occupation'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('father_occupation') }}</span>
                                @endif
                            </div>

                            <div class="p-2 ">
                                <label for="sss_no" class="block text-sm font-medium text-gray-700">SSS
                                    No.</label>
                                <input type="text" name="sss_no" id="sss_no" required
                                    class="w-full p-2 border border-black rounded-md" value="{{ old('sss_no') }}" />
                                @if ($errors->has('sss_no'))
                                    <span class="text-sm text-red-500">{{ $errors->first('sss_no') }}</span>
                                @endif
                            </div>

                            <div class="p-2 ">
                                <label for="tin_no" class="block text-sm font-medium text-gray-700">TIN
                                    No.</label>
                                <input type="text" name="tin_no" id="tin_no" required
                                    class="w-full p-2 border border-black rounded-md" value="{{ old('tin_no') }}" />
                                @if ($errors->has('tin_no'))
                                    <span class="text-sm text-red-500">{{ $errors->first('tin_no') }}</span>
                                @endif
                            </div>

                            <div class="p-2 ">
                                <label for="pagibig_no" class="block text-sm font-medium text-gray-700">Pag-IBIG
                                    No.</label>
                                <input type="text" name="pagibig_no" id="pagibig_no" required
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('pagibig_no') }}" />
                                @if ($errors->has('pagibig_no'))
                                    <span class="text-sm text-red-500">{{ $errors->first('pagibig_no') }}</span>
                                @endif
                            </div>

                            <div class="p-2">
                                <label for="dependents"
                                    class="block text-sm font-medium text-gray-700">Dependents</label>
                                <input type="number" name="dependents" id="dependents" required min="0"
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('dependents') }}" />
                                @if ($errors->has('dependents'))
                                    <span class="text-sm text-red-500">{{ $errors->first('dependents') }}</span>
                                @endif
                            </div>


                            <div class="p-2 ">
                                <label for="philhealth_no" class="block text-sm font-medium text-gray-700">PhilHealth
                                    No.</label>
                                <input type="text" name="philhealth_no" id="philhealth_no" required
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('philhealth_no') }}" />
                                @if ($errors->has('philhealth_no'))
                                    <span class="text-sm text-red-500">{{ $errors->first('philhealth_no') }}</span>
                                @endif
                            </div>
                            <div class="p-2">
                                <label for="blood_type" class="block text-sm font-medium text-gray-700">
                                    Blood Type
                                </label>
                                <select name="blood_type" id="blood_type" required
                                    class="w-full p-2 border border-black rounded-md">
                                    <option value="">-- Select Blood Type --</option>
                                    @foreach (['A+', 'A-', 'B+', 'B-', 'AB+', 'AB-', 'O+', 'O-'] as $type)
                                        <option value="{{ $type }}"
                                            {{ old('blood_type') == $type ? 'selected' : '' }}>
                                            {{ $type }}
                                        </option>
                                    @endforeach
                                </select>
                                @if ($errors->has('blood_type'))
                                    <span class="text-sm text-red-500">{{ $errors->first('blood_type') }}</span>
                                @endif
                            </div>

                        </div>




                    </div>




                    <h3 class="mt-10 mb-4 text-xl font-semibold">Educational Background</h3>
                    <div class="p-4 ">
                        <div
                            class="grid grid-cols-1 gap-4 p-4 mb-4 bg-white border-2 border-black lg:grid-cols-2 rounded-xl">
                            <div class="p-2 ">
                                <label for="education_school"
                                    class="block text-sm font-medium text-gray-700">School</label>
                                <input type="text" name="education_school" id="education_school" required
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('education_school') }}" />
                                @if ($errors->has('education_school'))
                                    <span class="text-sm text-red-500">{{ $errors->first('education_school') }}</span>
                                @endif
                            </div>

                            <div class="p-2 ">
                                <label for="education_course_level"
                                    class="block text-sm font-medium text-gray-700">Course
                                    Level</label>
                                <input type="text" name="education_course_level" id="education_course_level"
                                    required class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('education_course_level') }}" />
                                @if ($errors->has('education_course_level'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('education_course_level') }}</span>
                                @endif
                            </div>

                            <div class="p-2 ">
                                <label for="education_year" class="block text-sm font-medium text-gray-700">Year
                                    of
                                    Graduation</label>
                                <input type="text" name="education_year" id="education_year" required
                                    class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('education_year') }}" />
                                @if ($errors->has('education_year'))
                                    <span class="text-sm text-red-500">{{ $errors->first('education_year') }}</span>
                                @endif
                            </div>

                            <div class="p-2 ">
                                <label for="relevant_qualifications"
                                    class="block text-sm font-medium text-gray-700">Relevant
                                    Qualifications</label>
                                <input type="text" name="relevant_qualifications" id="relevant_qualifications"
                                    required class="w-full p-2 border border-black rounded-md"
                                    value="{{ old('relevant_qualifications') }}" />
                                @if ($errors->has('relevant_qualifications'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('relevant_qualifications') }}</span>
                                @endif
                            </div>

                            <!-- Employment Information -->

                        </div>
                        <h3 class="mt-10 mb-4 text-xl font-semibold">Emergency Contact Information</h3>
                        <div class="p-4">
                            <div
                                class="grid grid-cols-1 gap-4 p-4 mb-4 bg-white border-2 border-black lg:grid-cols-2 rounded-xl">
                                <div class="p-2 ">
                                    <label for="emergency_contact_name" class="block mb-1">Name:</label>
                                    <input type="text" name="emergency_contact_name" id="emergency_contact_name"
                                        class="w-full p-2 border border-black rounded-md"
                                        value="{{ old('emergency_contact_name') }}" />
                                    @error('emergency_contact_name')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="p-2 ">
                                    <label for="emergency_contact_relation" class="block mb-1">Relationship:</label>
                                    <input type="text" name="emergency_contact_relation"
                                        id="emergency_contact_relation"
                                        class="w-full p-2 border border-black rounded-md"
                                        value="{{ old('emergency_contact_relation') }}" />
                                    @error('emergency_contact_relation')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>


                                <div class="p-2 ">
                                    <label for="emergency_contact_number" class="block mb-1">Contact
                                        Number:</label>
                                    <input type="text" name="emergency_contact_number"
                                        id="emergency_contact_number"
                                        class="w-full p-2 border border-black rounded-md"
                                        value="{{ old('emergency_contact_number') }}" />
                                    @error('emergency_contact_number')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>


                                <div class="p-2 ">
                                    <label for="emergency_contact_address"
                                        class="block text-sm font-medium text-gray-700">Emergency
                                        Contact Address</label>
                                    <input type="text" name="emergency_contact_address"
                                        id="emergency_contact_address" required
                                        class="w-full p-2 border border-black rounded-md"
                                        value="{{ old('emergency_contact_address') }}" />
                                    @if ($errors->has('emergency_contact_address'))
                                        <span
                                            class="text-sm text-red-500">{{ $errors->first('emergency_contact_address') }}</span>
                                    @endif
                                </div>

                                <div class="p-2 ">
                                    <label for="emergency_contact_occupation"
                                        class="block text-sm font-medium text-gray-700">Emergency
                                        Contact Occupation</label>
                                    <input type="text" name="emergency_contact_occupation"
                                        id="emergency_contact_occupation" required
                                        class="w-full p-2 border border-black rounded-md"
                                        value="{{ old('emergency_contact_occupation') }}" />
                                    @if ($errors->has('emergency_contact_occupation'))
                                        <span
                                            class="text-sm text-red-500">{{ $errors->first('emergency_contact_occupation') }}</span>
                                    @endif
                                </div>



                                <div class="p-2 ">
                                    <label for="emergency_contact_company"
                                        class="block text-sm font-medium text-gray-700">Emergency
                                        Contact Company</label>
                                    <input type="text" name="emergency_contact_company"
                                        id="emergency_contact_company"
                                        class="w-full p-2 border border-black rounded-md"
                                        value="{{ old('emergency_contact_company') }}" />
                                    @if ($errors->has('emergency_contact_company'))
                                        <span
                                            class="text-sm text-red-500">{{ $errors->first('emergency_contact_company') }}</span>
                                    @endif
                                </div>

                                <div class="p-2">
                                    <label for="emergency_contact_business_tel"
                                        class="block text-sm font-medium text-gray-700">Emergency
                                        Contact Business Tel</label>
                                    <input type="text" name="emergency_contact_business_tel"
                                        id="emergency_contact_business_tel"
                                        class="w-full p-2 border border-black rounded-md"
                                        value="{{ old('emergency_contact_business_tel') }}" />
                                    @if ($errors->has('emergency_contact_business_tel'))
                                        <span
                                            class="text-sm text-red-500">{{ $errors->first('emergency_contact_business_tel') }}</span>
                                    @endif
                                </div>

                            </div>
                            <div class="mt-6 text-center">
                                <button type="submit"
                                    class="p-2 w-[20rem] text-white bg-blue-500 rounded">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>

        </form>
    </div>
    @if (session('success'))
        <div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center bg-gray-900 bg-opacity-50">
            <div class="flex flex-col items-center justify-center w-full max-w-2xl p-6 bg-white rounded-lg shadow-lg">

                <i class='text-3xl bx bx-check-circle'></i>
                <p class="mb-5 text-lg font-semibold text-center">
                    Thank you for submitting your application and resume. We will review your documents and get back to
                    you shortly regarding the next steps in the process.
                </p>

            </div>
        </div>
        <script>
            // Automatically close the modal after 5 seconds
            setTimeout(function() {
                document.getElementById('successModal').style.display = 'none';
            }, 5000); // 5000 milliseconds = 5 seconds
        </script>
    @endif

</body>

</html>
