@extends('layouts.sidebar')
@section('title', 'Users')
@section('content')


    <div class="flex justify-between  p-5">


        <div> <span><a href="{{ route('users.index') }}"
                    class="inline-block transition-transform duration-300 hover:scale-110">
                    < User </a>
                        <a
                            href="{{ route('assigns.get', $user->user->id) }}"class="inline-block transition-transform duration-300 hover:scale-110">
                            < Agency Access </a>
            </span>
        </div>
        <div>
            <h1 class="mb-4 text-xl font-bold">User Company Access for {{ $user->user->name }}</h1>

        </div>

    </div>




    @if (session('success'))
        <div class="p-4 mb-4 text-white bg-green-500">
            {{ session('success') }}
        </div>
    @endif
    @if ($errors->any())
        <div class=" alert alert-dange">
            <ul class="p-4 mb-4 text-red-600">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <div class="grid grid-cols-1 gap-10 md:grid-cols-4">
        <div class="border-2 shadow-2xl">
            <form id="assignForm" action="{{ route('store_assigncompany') }}" method="POST">
                @csrf
                <div class="p-4 border-b">
                    <h5 class="text-lg font-semibold" id="assignLabel">Assign Company to user</h5>
                </div>
                <div class="p-4">
                    <input type="hidden" name="assign_id" id="" value="{{ $user->id }}"
                        class="border-2 border-black">

                    <div class="mb-4">
                        <label for="company_id" class="block text-sm font-medium text-gray-700">Company</label>
                        <select name="company_id" id="company_id"
                            class="block w-full px-4 py-2 mt-1 border-2 border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                            <option value="" disabled selected>Select Company</option>
                            @foreach ($company as $company)
                                <option value="{{ $company->id }}">{{ $company->business_name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="p-4 border-t">

                    <button type="submit" class="px-4 py-2 text-white bg-blue-600 rounded-lg">Assign</button>
                </div>
            </form>
        </div>

        <div class="col-span-3 p-2 overflow-auto border-2 border-black rounded-md ">
            <table id="assign-table" class="min-w-full bg-white border border-collapse border-gray-200 rounded shadow-md ">
                <thead>
                    <tr class="text-sm leading-normal  text-white uppercase bg-[#1d1d1d]">


                        <th>Company Name</th>
                        <th>Delete</th>

                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                    <!-- DataTables will populate this body -->
                </tbody>
            </table>
        </div>

    </div>


    <div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
            <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
            <p>Are you sure you want to delete this record?</p>
            <form id="deleteForm">
                @csrf
                <input type="hidden" id="deleteRecordId" name="id">
                <div class="flex justify-end mt-6">
                    <button type="button" onclick="closeModal('deleteModal')"
                        class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Open Delete Modal
            window.openDeleteModal = function(recordId) {
                $('#deleteRecordId').val(recordId);
                $('#deleteModal').removeClass('hidden');
            };

            // Submit Delete Form
            $('#deleteForm').on('submit', function(e) {
                e.preventDefault();
                let recordId = $('#deleteRecordId').val();
                let deleteUrl = "{{ route('assign-company.destroy', ':id') }}".replace(':id', recordId);

                $.ajax({
                    url: deleteUrl,
                    type: "DELETE",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.success) {

                            $('#deleteForm')[0].reset(); // Reset form
                            $('#deleteModal').addClass('hidden'); // Close modal
                            $('#assign-table').DataTable().ajax.reload(null,
                                false); // Reload table without resetting pagination
                        }
                    },
                    error: function(xhr) {
                        alert('Error deleting record.');
                    }
                });
            });

            // Close Modal Function
            window.closeModal = function(modalId) {
                $('#' + modalId).addClass('hidden');
            };
        });
    </script>



    <script>
        $(document).ready(function() {
            var userId = {{ $user->id }}; // Assuming you have a $client variable available

            var employedTable = $('#assign-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('get_companyassign', ['id' => ':id']) }}".replace(':id',
                        userId),

                },
                columns: [{
                        data: 'company.business_name',
                        name: 'company.business_name'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });
        });

        function openModal(modalId, userId = null) {
            const modal = document.getElementById(modalId);

            // Assign the user ID if the modal is for assigning
            if (modalId === 'assignModal' && userId) {
                document.getElementById('assignUserId').value = userId;
            }

            // Remove the `hidden` class to make the modal visible
            modal.classList.remove('hidden');
            modal.classList.add('flex');
        }

        function closeModal(modalId) {
            const modal = document.getElementById(modalId);

            // Add the `hidden` class to hide the modal
            modal.classList.add('hidden');
            modal.classList.remove('flex');
        }
    </script>


@endsection
