@if (in_array('Scanner', $privileges))
    @php
        $user = Auth::user();
        $agencyIds = $user->viewable_agency_ids;

        $query = App\Models\Department::with('client.agency')->withCount([
            'channels as active_employee_count' => function ($query) {
                $query->where('status', 1);
            },
        ]);

        if (!empty($agencyIds)) {
            $query->whereHas('client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });

            $assignIds = App\Models\Assign::where('user_id', $user->id)->whereIn('agency_id', $agencyIds)->pluck('id');

            $restrictedCompanyIds = App\Models\AssignCompany::whereIn('assign_id', $assignIds)->pluck('id');

            $restrictedDepartmentIds = App\Models\AssignCompanyDepartment::whereIn(
                'assigncompany_id',
                $restrictedCompanyIds,
            )
                ->pluck('department_id')
                ->unique();

            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereIn('id', $restrictedDepartmentIds);
            }
        }

        $data = $query->get();

        $currentclient = App\Models\Department::where('user_id', $user->id)->first();
    @endphp


    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title>QR Scanner with Attendance</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet" />
        @vite('resources/css/app.css')
        <style>
            body {
                font-family: 'Poppins', sans-serif;
            }

            .modal {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.5);
                justify-content: center;
                align-items: center;
                z-index: 1000;
            }

            .modal-content {
                background: white;
                padding: 20px;
                border-radius: 10px;
                width: 300px;
                text-align: center;
            }

            .modal-button {
                padding: 10px;
                background-color: #4caf50;
                color: white;
                border: none;
                cursor: pointer;
                border-radius: 5px;
                margin-top: 20px;
            }

            #selfie-video {
                display: block;
                width: 320px;
                height: 240px;
                border-radius: 10px;
                margin: 1rem auto 2rem auto;
                background: black;
                object-fit: cover;
                transform: scaleX(-1);
                /* <-- Mirror the video horizontally */
            }

            #my-qr-reader video {
                transform: scaleX(-1);
                -webkit-transform: scaleX(-1);
            }
        </style>
    </head>

    <body class="bg-gray-100 leading-normal tracking-wider">

        <div class="pl-5 pt-5">
            <a href="{{ url('admin/dashboard') }}"
                class="inline-block text-white bg-gray-800 hover:bg-gray-900 font-semibold text-lg py-2 px-6 rounded-lg shadow-md">
                Back
            </a>
        </div>

        <div class="container mx-auto p-4 max-w-xl">

            <div class="mt-2">
                <label for="time_type">Select Attendance Type:</label>
                <select id="time_type" class="w-full px-3 py-2 border border-gray-300 rounded-md">
                    <option value="time_in">Time In</option>
                    <option value="break_out">Break Out</option>
                    <option value="break_in">Break In</option>
                    <option value="time_out">Time Out</option>
                    <option value="ot_in">OT IN</option>
                    <option value="ot_out">OT Out</option>
                </select>
            </div>
            <div class="bg-white p-8 rounded-lg shadow-xl mt-2">
                <h2 class="text-3xl font-semibold text-center text-gray-800 mb-6">Scan Employee QR Code</h2>
                <div id="my-qr-reader" style="width: 100%; height: 400px;"></div>
            </div>
        </div>

        <div id="selfie-modal"
            class="modal fixed inset-0 bg-black bg-opacity-80 flex justify-center items-center hidden z-50">
            <div class="modal-content bg-white rounded-lg p-6 max-w-md w-full relative">
                <h3 class="text-xl font-semibold mb-4 text-center">Please look at the camera</h3>
                <video id="selfie-video" autoplay muted playsinline
                    class="w-full rounded-lg bg-black object-cover"></video>
                <p class="mt-4 text-center text-gray-600">
                    Taking your selfie in <span id="countdown">3</span> seconds...
                </p>
            </div>
        </div>



        <!-- Modal for success/error messages -->
        <div id="modal" class="modal">
            <div class="modal-content">
                <h3 id="modal-message">Attendance recorded successfully!</h3>
                <button id="modal-close" class="modal-button">Close</button>
            </div>
        </div>

        <!-- Scripts -->
        <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
        <script src="https://unpkg.com/html5-qrcode"></script>

        <script>
            function domReady(fn) {
                if (document.readyState === "complete" || document.readyState === "interactive") {
                    setTimeout(fn, 1000);
                } else {
                    document.addEventListener("DOMContentLoaded", fn);
                }
            }

            domReady(function() {
                const selfieModal = document.getElementById('selfie-modal');
                const selfieVideo = document.getElementById('selfie-video');
                const countdownEl = document.getElementById('countdown');
                let stream = null;

                async function startSelfieCamera() {
                    try {
                        stream = await navigator.mediaDevices.getUserMedia({
                            video: {
                                facingMode: "user"
                            }
                        });
                        selfieVideo.srcObject = stream;
                        await selfieVideo.play();
                    } catch (error) {
                        console.error("Error accessing camera: ", error);
                        showModal("Camera access denied or not available.");
                    }
                }

                function captureSelfie() {
                    const canvas = document.createElement('canvas');
                    canvas.width = selfieVideo.videoWidth || 320;
                    canvas.height = selfieVideo.videoHeight || 240;
                    const ctx = canvas.getContext('2d');
                    ctx.drawImage(selfieVideo, 0, 0, canvas.width, canvas.height);

                    return new Promise((resolve) => {
                        canvas.toBlob((blob) => {
                            resolve(blob); // Return the Blob object
                        }, 'image/jpeg', 0.7); // JPEG format, 70% quality
                    });
                }

                function showModal(message) {
                    const modal = document.getElementById('modal');
                    const modalMessage = document.getElementById('modal-message');
                    modalMessage.textContent = message;
                    modal.style.display = 'flex';

                    // Close modal after 3 seconds
                    setTimeout(() => {
                        modal.style.display = 'none';
                    }, 3000);
                }

                const modalCloseButton = document.getElementById('modal-close');
                modalCloseButton.addEventListener('click', () => {
                    const modal = document.getElementById('modal');
                    modal.style.display = 'none';
                });

                startSelfieCamera();

                let htmlscanner;

                function onScanSuccess(decodeText, decodeResult) {
                    if (htmlscanner) {
                        htmlscanner.pause();
                    }



                    const attendanceType = document.getElementById("time_type").value;

                    // Show selfie modal and start countdown
                    let countdown = 3;
                    countdownEl.textContent = countdown;
                    selfieModal.classList.remove('hidden');

                    const countdownInterval = setInterval(async () => {
                        countdown -= 1;
                        countdownEl.textContent = countdown;

                        if (countdown <= 0) {
                            clearInterval(countdownInterval);
                            selfieModal.classList.add('hidden');

                            const currentTime = new Date();
                            const localDate = currentTime.toISOString().slice(0, 10);
                            const localTime = currentTime.toTimeString().split(' ')[0];
                            const formattedTime = `${localDate} ${localTime}`;

                            const selfieBlob = await captureSelfie(); // <-- Await blob

                            // Prepare FormData
                            const formData = new FormData();
                            formData.append('employee_id', decodeText);

                            formData.append('date', localDate);
                            formData.append('time_type', attendanceType);
                            formData.append('time_in', formattedTime);
                            formData.append('time_out', formattedTime);
                            formData.append('selfie', selfieBlob, 'selfie.jpg'); // <- Important!

                            axios.post("{{ route('attendance.store.time') }}", formData, {
                                    headers: {
                                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                        'Content-Type': 'multipart/form-data',
                                    }
                                })
                                .then(response => {
                                    showModal(response.data.message ||
                                        "Attendance recorded with selfie.");
                                    setTimeout(() => htmlscanner.resume(), 2000);
                                })
                                .catch(error => {
                                    showModal(error.response?.data?.message ||
                                        "Error saving attendance.");
                                    htmlscanner.resume();
                                });
                        }
                    }, 1000);
                }


                htmlscanner = new Html5QrcodeScanner("my-qr-reader", {
                    fps: 30, // 30 fps is a good balance for performance and accuracy
                    qrbox: {
                        width: 250,
                        height: 250
                    }, // Smaller box can improve scan speed in focused area
                    aspectRatio: 1.0,
                    disableFlip: false, // Allow flipping for better device adaptability
                    rememberLastUsedCamera: true // Useful for faster repeat scans
                });

                htmlscanner.render(onScanSuccess);
            });
        </script>

    </body>

    </html>
@endif
