@foreach ($role as $data)
    <div id="updateroleModal{{ $data->id }}"
        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50 modal fade">
        <!-- Modal dialog -->
        <div
            class=" max-w-screen-2xl  md:h-[50rem] h-[50rem] mx-auto mt-5 overflow-y-auto bg-white rounded-lg shadow-xl">
            <!-- Modal header -->
            <div class="flex items-center justify-between px-4 py-2 ">
                <h5 class="font-bold text-black">Update Role</h5>
                <button onclick="closeModal('updateroleModal{{ $data->id }}')" class="text-black">&times;</button>
            </div>


            <!-- Modal footer -->
            <div class="flex items-center justify-center px-4 py-3 bg-gray-100">



                <form action="{{ route('roles.update', $data->id) }}" method="POST"
                    class="p-6 mt-4 bg-white rounded shadow">
                    @csrf
                    @method('PUT') <!-- Add this line to specify that this is a PUT request for updating -->

                    <div class="mb-4">
                        <label for="role_name" class="block text-sm font-medium text-gray-700">Role Name</label>
                        <input type="text" name="role_name" id="role_name" required
                            value="{{ old('role_name', $data->role_name) }}"
                            class="mt-1 block w-full border-black border-2 h-10 rounded-md shadow-sm {{ $errors->has('role_name') ? 'border-red-500' : '' }}">
                        @if ($errors->has('role_name'))
                            <p class="mt-1 text-xs text-red-500">{{ $errors->first('role_name') }}</p>
                        @endif
                    </div>
                    @php
                        $groupedPrivileges = $privileges1->groupBy('status');
                    @endphp
                    <div class="mb-4 ">
                        <label class="block text-sm font-medium text-gray-700">Privileges</label>
                        <div class="grid grid-cols-1 gap-3 mt-2 md:grid-cols-3">
                            @php
                                $groupedPrivileges = $privileges1
                                    ->groupBy('status')
                                    ->sortByDesc(fn($privileges) => $privileges->count());
                            @endphp

                            @foreach ($groupedPrivileges as $status => $privileges)
                                <div class="status-group">
                                    <h3 class="mb-2 text-lg font-semibold"> {{ $status }}</h3>

                                    @foreach ($privileges as $privilege)
                                        <div class="whitespace-nowrap">
                                            <input type="checkbox" name="privileges[]" value="{{ $privilege->id }}"
                                                id="privilege_{{ $privilege->id }}"
                                                class="w-4 h-4 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500"
                                                {{ in_array($privilege->id, $data->privileges->pluck('id')->toArray()) ? 'checked' : '' }}>
                                            <label for="privilege_{{ $privilege->id }}" class="text-sm text-gray-600">
                                                {{ $privilege->privilege_name }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            @endforeach
                        </div>

                    </div>

                    <button type="submit"
                        class="inline-flex justify-center px-4 py-2 mt-4 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        Update Role
                    </button>
                </form>

            </div>
        </div>
    </div>
@endforeach
<div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
        <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
        <p>Are you sure you want to delete this record?</p>
        <form id="deleteForm">
            @csrf
            <input type="hidden" id="deleteRecordId" name="id">
            <div class="flex justify-end mt-6">
                <button type="button" onclick="closeModal('deleteModal')"
                    class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
            </div>
        </form>
    </div>
</div>

<script>
    $(document).ready(function() {
        // Open Delete Modal
        window.openDeleteModal = function(recordId) {
            $('#deleteRecordId').val(recordId);
            $('#deleteModal').removeClass('hidden');
        };

        // Submit Delete Form
        $('#deleteForm').on('submit', function(e) {
            e.preventDefault();
            let recordId = $('#deleteRecordId').val();
            let deleteUrl = "{{ route('roles.destroy', ':id') }}".replace(':id', recordId);

            $.ajax({
                url: deleteUrl,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        $('#deleteForm')[0].reset(); // Reset form
                        $('#deleteModal').addClass('hidden'); // Close modal
                        $('#roleTable').DataTable().ajax.reload(null,
                            false); // Reload table without resetting pagination
                    }
                },
                error: function(xhr) {
                    alert('Error deleting record.');
                }
            });
        });

    });
</script>
