<div class="w-full col-span-3 p-6 mx-auto bg-white rounded-lg shadow-md space-y-10">

    <div class="p-6 mx-auto ">
        <h2 class="mb-4 text-2xl font-bold">SSS Contribution Table</h2>
        <input type="text" id="search" placeholder="Search salary range..." class="w-full p-2 mb-4 border rounded">
        <div class="overflow-x-auto">
            <table class="w-full text-xs text-center border-collapse border-black text-nowrap">
                <thead class="border-2 border-black">
                    <tr class="bg-gray-200 ">
                        <th class="p-2 "></th>
                        <th colspan="3" class="p-2 border-2 border-black">Monthly Salary Credit</th>

                        <th colspan="4" class="p-2 border-2 border-black ">Employer</th>

                        <th colspan="4" class="p-2 border-2 border-black">Employee</th>

                    </tr>
                    <tr class="bg-gray-200">
                        <th class="p-2 ">Range of Compensation</th>
                        <th class="p-2 border-2 border-black">Regular SS</th>

                        <th class="p-2 border-2 border-black">MPF</th>
                        <th class="p-2 border-2 border-black">Total</th>
                        <th class="p-2 border-2 border-black ">Employer (Regular SS)</th>
                        <th class="p-2 border-2 border-black">Employer (MPF)</th>
                        <th class="p-2 border-2 border-black">Employer (EC)</th>
                        <th class="p-2 border-2 border-black">Employer Total</th>
                        <th class="p-2 border-2 border-black">Employee (Regular SS)</th>
                        <th class="p-2 border-2 border-black">Employee (MPF)</th>
                        <th class="p-2 border-2 border-black">Employee Total</th>
                    </tr>
                </thead>
                <tbody id="table-body"></tbody>
            </table>
        </div>
    </div>

    <script>
        const sssBrackets = [
            ["Below 5,250", 5000, "-", 5000, 500, "-", 10, 510, 250, "-", 250],
            ["5,250 - 5,749.99", 5500, "-", 5500, 550, "-", 10, 560, 275, "-", 275],
            ["5,750 - 6,249.99", 6000, "-", 6000, 600, "-", 10, 610, 300, "-", 300],
            ["6,250 - 6,749.99", 6500, "-", 6500, 650, "-", 10, 660, 325, "-", 325],
            ["6,750 - 7,249.99", 7000, "-", 7000, 700, "-", 10, 710, 350, "-", 350],
            ["7,250 - 7,749.99", 7500, "-", 7500, 750, "-", 10, 760, 375, "-", 375],
            ["7,750 - 8,249.99", 8000, "-", 8000, 800, "-", 10, 810, 400, "-", 400],
            ["8,250 - 8,749.99", 8500, "-", 8500, 850, "-", 10, 860, 425, "-", 425],
            ["8,750 - 9,249.99", 9000, "-", 9000, 900, "-", 10, 910, 450, "-", 450],
            ["9,250 - 9,749.99", 9500, "-", 9500, 950, "-", 10, 960, 475, "-", 475],
            ["9,750 - 10,249.99", 10000, "-", 10000, 1000, "-", 10, 1010, 500, "-", 500],
            ["10,250 - 10,749.99", 10500, "-", 10500, 1050, "-", 10, 1060, 525, "-", 525],
            ["10,750 - 11,249.99", 11000, "-", 11000, 1100, "-", 10, 1110, 550, "-", 550],
            ["11,250 - 11,749.99", 11500, "-", 11500, 1150, "-", 10, 1160, 575, "-", 575],
            ["11,750 - 12,249.99", 12000, "-", 12000, 1200, "-", 10, 1210, 600, "-", 600],
            ["12,250 - 12,749.99", 12500, "-", 12500, 1250, "-", 10, 1260, 625, "-", 625],
            ["12,750 - 13,249.99", 13000, "-", 13000, 1300, "-", 10, 1310, 650, "-", 650],
            ["13,250 - 13,749.99", 13500, "-", 13500, 1350, "-", 10, 1360, 675, "-", 675],
            ["13,750 - 14,249.99", 14000, "-", 14000, 1400, "-", 10, 1410, 700, "-", 700],
            ["14,250 - 14,749.99", 14500, "-", 14500, 1450, "-", 30, 1480, 725, "-", 725],
            ["14,750 - 15,249.99", 15000, "-", 15000, 1500, "-", 30, 1530, 750, "-", 750],
            ["15,250 - 15,749.99", 15500, "-", 15500, 1550, "-", 30, 1580, 775, "-", 775],
            ["15,750 - 16,249.99", 16000, "-", 16000, 1600, "-", 30, 1630, 800, "-", 800],
            ["16,250 - 16,749.99", 16500, "-", 16500, 1650, "-", 30, 1680, 825, "-", 825],
            ["16,750 - 17,249.99", 17000, "-", 17000, 1700, "-", 30, 1730, 850, "-", 850],
            ["17,250 - 17,749.99", 17500, "-", 17500, 1750, "-", 30, 1780, 875, "-", 875],
            ["17,750 - 18,249.99", 18000, "-", 18000, 1800, "-", 30, 1830, 900, "-", 900],
            ["18,250 - 18,749.99", 18500, "-", 18500, 1850, "-", 30, 1880, 925, "-", 925],
            ["18,750 - 19,249.99", 19000, "-", 19000, 1900, "-", 30, 1930, 950, "-", 950],
            ["19,250 - 19,749.99", 19500, "-", 19500, 1950, "-", 30, 1980, 975, "-", 975],
            ["19,750 - 20,249.99", 20000, "-", 20000, 2000, "-", 30, 2030, 1000, "-", 1000],
            ["20,250 - 20,749.99", 20000, 500, 20500, 2000, 50, 30, 2080, 1000, 25, 1025],
            ["20,750 - 21,249.99", 20000, 1000, 21000, 2000, 100, 30, 2130, 1000, 50, 1050],
            ["21,250 - 21,749.99", 20000, 1500, 21500, 2000, 150, 30, 2180, 1000, 75, 1075],
            ["21,750 - 22,249.99", 20000, 2000, 22000, 2000, 200, 30, 2230, 1000, 100, 1100],
            ["22,250 - 22,749.99", 20000, 2500, 22500, 2000, 250, 30, 2280, 1000, 125, 1125],
            ["22,750 - 23,249.99", 20000, 3000, 23000, 2000, 300, 30, 2330, 1000, 150, 1150],
            ["23,250 - 23,749.99", 20000, 3500, 23500, 2000, 350, 30, 2380, 1000, 175, 1175],
            ["23,750 - 24,249.99", 20000, 4000, 24000, 2000, 400, 30, 2430, 1000, 200, 1200],
            ["24,250 - 24,749.99", 20000, 4500, 24500, 2000, 450, 30, 2480, 1000, 225, 1225],
            ["24,750 - 25,249.99", 20000, 5000, 25000, 2000, 500, 30, 2530, 1000, 250, 1250],
            ["25,250 - 25,749.99", 20000, 5500, 25500, 2000, 550, 30, 2580, 1000, 275, 1275],
            ["25,750 - 26,249.99", 20000, 6000, 26000, 2000, 600, 30, 2630, 1000, 300, 1300],
            ["26,250 - 26,749.99", 20000, 6500, 26500, 2000, 650, 30, 2680, 1000, 325, 1325],
            ["26,750 - 27,249.99", 20000, 7000, 27000, 2000, 700, 30, 2730, 1000, 350, 1350],
            ["27,250 - 27,749.99", 20000, 7500, 27500, 2000, 750, 30, 2780, 1000, 375, 1375],
            ["27,750 - 28,249.99", 20000, 8000, 28000, 2000, 800, 30, 2830, 1000, 400, 1400],
            ["28,250 - 28,749.99", 20000, 8500, 28500, 2000, 850, 30, 2880, 1000, 425, 1425],
            ["28,750 - 29,249.99", 20000, 9000, 29000, 2000, 900, 30, 2930, 1000, 450, 1450],
            ["29,250 - 29,749.99", 20000, 9500, 29500, 2000, 950, 30, 2980, 1000, 475, 1475],
            ["29,750 - 30,249.99", 20000, 10000, 30000, 2000, 1000, 30, 3030, 1000, 500, 1500],
            ["30,250 - 30,749.99", 20000, 10500, 30500, 2000, 1050, 30, 3080, 1000, 525, 1525],
            ["30,750 - 31,249.99", 20000, 11000, 31000, 2000, 1100, 30, 3130, 1000, 550, 1550],
            ["31,250 - 31,749.99", 20000, 11500, 31500, 2000, 1150, 30, 3180, 1000, 575, 1575],
            ["31,750 - 32,249.99", 20000, 12000, 32000, 2000, 1200, 30, 3230, 1000, 600, 1600],
            ["32,250 - 32,749.99", 20000, 12500, 32500, 2000, 1250, 30, 3280, 1000, 625, 1625],
            ["32,750 - 33,249.99", 20000, 13000, 33000, 2000, 1300, 30, 3330, 1000, 650, 1650],
            ["33,250 - 33,749.99", 20000, 13500, 33500, 2000, 1350, 30, 3380, 1000, 675, 1675],
            ["33,750 - 34,249.99", 20000, 14000, 34000, 2000, 1400, 30, 3430, 1000, 700, 1700],
            ["34,250 - 34,749.99", 20000, 14500, 34500, 2000, 1450, 30, 3480, 1000, 725, 1725]
        ];


        function loadTable(filter = "") {
            const tableBody = document.getElementById("table-body");
            tableBody.innerHTML = "";

            sssBrackets.forEach(row => {
                const range = row[0];
                if (filter && !range.includes(filter)) return;

                const tr = document.createElement("tr");
                tr.innerHTML = `
                    <td class="p-2 border-2 border-black ">${row[0]}</td>
                    <td class="p-2 border-2 border-black ">${row[1]}</td>
                    <td class="p-2 border-2 border-black ">${row[2]}</td>
                    <td class="p-2 border-2 border-black ">${row[3]}</td>
                    <td class="p-2 border-2 border-black ">${row[4]}</td>
                    <td class="p-2 border-2 border-black ">${row[5]}</td>
                    <td class="p-2 border-2 border-black ">${row[6]}</td>
                    <td class="p-2 border-2 border-black ">${row[7]}</td>
                    <td class="p-2 border-2 border-black ">${row[8]}</td>
                    <td class="p-2 border-2 border-black ">${row[9]}</td>
                    <td class="p-2 border-2 border-black ">${row[10]}</td>
                 
                `;
                tableBody.appendChild(tr);
            });
        }

        document.getElementById("search").addEventListener("input", function() {
            loadTable(this.value);
        });

        loadTable();
    </script>
    <!-- Modal -->
    <dialog id="pagibigModal" class="rounded-lg p-0 w-full max-w-lg">
        <form method="dialog" class="absolute top-3 right-3">
            <button class="text-gray-400 hover:text-gray-600 text-lg">✕</button>
        </form>
        <div class="bg-white rounded-lg shadow-lg p-6">
            <h2 class="text-xl font-semibold text-gray-700 mb-4">Add Rate</h2>

            <form action="{{ route('pagibig.store') }}" method="POST" class="space-y-4">
                @csrf

                <div>
                    <label class="block text-sm font-medium">Rate Type</label>
                    <select id="rateType" name="type"
                        class="w-full mt-1 p-2 border rounded-md focus:ring focus:ring-blue-300">
                        <option value="">-- Select --</option>
                        <option value="pagibig">Pag-IBIG</option>
                        <option value="philhealth">PhilHealth</option>
                    </select>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium">From</label>
                        <input type="number" step="0.01" name="from"
                            class="w-full mt-1 p-2 border rounded-md focus:ring focus:ring-blue-300" required>
                    </div>
                    <div>
                        <label class="block text-sm font-medium">To</label>
                        <input type="number" step="0.01" name="to"
                            class="w-full mt-1 p-2 border rounded-md focus:ring focus:ring-blue-300" required>
                    </div>
                </div>

                <!-- Employee Contribution -->
                <div id="employeeContribution">
                    <h3 class="text-md font-semibold text-gray-700 mb-2">Employee Contribution</h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div id="employeePercentDiv">
                            <label id="employeePercentLabel" class="block text-sm font-medium">Percentage (%)</label>
                            <input type="number" step="0.01" name="percent_employee"
                                class="w-full mt-1 p-2 border rounded-md focus:ring focus:ring-blue-300">
                        </div>
                        <div>
                            <label class="block text-sm font-medium">Fixed Amount (₱)</label>
                            <input type="number" step="0.01" name="employee_fixedamount"
                                class="w-full mt-1 p-2 border rounded-md focus:ring focus:ring-blue-300">
                        </div>
                    </div>
                </div>

                <!-- Employer Contribution -->
                <div>
                    <h3 class="text-md font-semibold text-gray-700 mb-2">Employer Contribution</h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label id="employerPercentLabel" class="block text-sm font-medium">Percentage (%)</label>
                            <input type="number" step="0.01" name="percent_employer"
                                class="w-full mt-1 p-2 border rounded-md focus:ring focus:ring-blue-300">
                        </div>
                        <div>
                            <label class="block text-sm font-medium">Fixed Amount (₱)</label>
                            <input type="number" step="0.01" name="employer_fixedamount"
                                class="w-full mt-1 p-2 border rounded-md focus:ring focus:ring-blue-300">
                        </div>
                    </div>
                </div>

                <!-- Buttons -->
                <div class="flex justify-end space-x-2 pt-4">
                    <button type="button" onclick="document.getElementById('pagibigModal').close()"
                        class="px-4 py-2 border rounded-md text-gray-600 hover:bg-gray-100">
                        Cancel
                    </button>
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">
                        Save
                    </button>
                </div>
            </form>

            <script>
                const rateType = document.getElementById('rateType');
                const employeePercentDiv = document.getElementById('employeePercentDiv');
                const employerPercentLabel = document.getElementById('employerPercentLabel');

                rateType.addEventListener('change', function() {
                    if (this.value === 'philhealth') {
                        // Hide Employee Percentage
                        employeePercentDiv.style.display = 'none';

                        // Change Employer label text
                        employerPercentLabel.textContent = 'Percentage';
                    } else {
                        // Show Employee Percentage
                        employeePercentDiv.style.display = 'block';

                        // Reset Employer label
                        employerPercentLabel.textContent = 'Percentage (%)';
                    }
                });
            </script>

        </div>
    </dialog>


    <!-- Pag-IBIG Rates -->
    <div>
        <div class="flex items-center justify-between flex-col md:flex-row">
            <h2 class="text-lg font-semibold text-gray-700 mb-4">Pag-IBIG Rates</h2>
            <div class="flex justify-end mb-4">
                <button onclick="document.getElementById('pagibigModal').showModal()"
                    class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">
                    + Add Rate
                </button>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="pagibigTable" class="min-w-full border border-gray-300 rounded-lg overflow-hidden text-sm">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-4 py-2 text-left">From</th>
                        <th class="px-4 py-2 text-left">To</th>
                        <th class="px-4 py-2 text-left">Emp. %</th>
                        <th class="px-4 py-2 text-center">Emp. Fixed?</th>
                        <th class="px-4 py-2 text-left">Emp. Amount</th>
                        <th class="px-4 py-2 text-left">Er. %</th>
                        <th class="px-4 py-2 text-center">Er. Fixed?</th>
                        <th class="px-4 py-2 text-left">Er. Amount</th>
                        <th class="px-4 py-2 text-center">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    @foreach ($pagibignew as $rate)
                        <tr>
                            <form action="{{ route('pagibig.update', $rate->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="from" value="{{ $rate->from }}"
                                        class="w-24 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="to" value="{{ $rate->to }}"
                                        class="w-24 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="percent_employee"
                                        value="{{ $rate->percent_employee ?? '' }}"
                                        class="w-20 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2 text-center">
                                    <input type="hidden" name="fixed1" value="0">
                                    <input type="checkbox" name="fixed1" value="1"
                                        {{ $rate->fixed1 ? 'checked' : '' }}>
                                </td>
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="employee_fixedamount"
                                        value="{{ $rate->employee_fixedamount ?? '' }}"
                                        class="w-20 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="percent_employer"
                                        value="{{ $rate->percent_employer ?? '' }}"
                                        class="w-20 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2 text-center">
                                    <input type="hidden" name="fixed2" value="0">
                                    <input type="checkbox" name="fixed2" value="1"
                                        {{ $rate->fixed2 ? 'checked' : '' }}>
                                </td>
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="employer_fixedamount"
                                        value="{{ $rate->employer_fixedamount ?? '' }}"
                                        class="w-20 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2 text-center flex space-x-2 justify-center">
                                    <button type="submit"
                                        class="bg-green-600 text-white px-3 py-1 rounded-md hover:bg-green-700 text-xs">
                                        Update
                                    </button>
                            </form>
                            <form action="{{ route('pagibig.destroy', $rate->id) }}" method="POST"
                                onsubmit="return confirm('Are you sure you want to delete this rate?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit"
                                    class="bg-red-600 text-white px-3 py-1 rounded-md hover:bg-red-700 text-xs">
                                    Delete
                                </button>
                            </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <script>
                $(document).ready(function() {
                    $('#pagibigTable').DataTable({
                        paging: true,
                        searching: true,
                        ordering: true,
                        columnDefs: [{
                                orderable: false,
                                targets: 8
                            } // Disable ordering on Actions column
                        ]
                    });
                });
            </script>
        </div>
    </div>
    <div>
        <div class="flex items-center justify-between flex-col md:flex-row">
            <h2 class="text-lg font-semibold text-gray-700 mb-4">PhilHealth Rates</h2>
            <div class="flex justify-end mb-4">
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="philhealth" class="min-w-full border border-gray-300 rounded-lg overflow-hidden text-sm">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-4 py-2 text-left">From</th>
                        <th class="px-4 py-2 text-left">To</th>
                        <th class="px-4 py-2 text-left">Emp. Amount</th>
                        <th class="px-4 py-2 text-left">Er. Amount</th>
                        <th class="px-4 py-2 text-left">Use. %</th>
                        <th class="px-4 py-2 text-left">%</th>
                        <th class="px-4 py-2 text-center">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    @foreach ($philhealthnew as $rate)
                        <tr>
                            <form action="{{ route('pagibig.update', $rate->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="from" value="{{ $rate->from }}"
                                        class="w-24 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="to" value="{{ $rate->to }}"
                                        class="w-24 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="employee_fixedamount"
                                        value="{{ $rate->employee_fixedamount ?? '' }}"
                                        class="w-20 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="employer_fixedamount"
                                        value="{{ $rate->employer_fixedamount ?? '' }}"
                                        class="w-20 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2 text-center">
                                    <input type="hidden" name="fixed1" value="0">
                                    <input type="checkbox" name="fixed1" value="1"
                                        {{ $rate->fixed1 ? 'checked' : '' }}>
                                </td>
                                <td class="px-4 py-2">
                                    <input type="number" step="0.01" name="percent_employer"
                                        value="{{ $rate->percent_employer ?? '' }}"
                                        class="w-20 p-1 border rounded-md text-sm">
                                </td>
                                <td class="px-4 py-2 text-center flex space-x-2 justify-center">
                                    <button type="submit"
                                        class="bg-green-600 text-white px-3 py-1 rounded-md hover:bg-green-700 text-xs">
                                        Update
                                    </button>
                            </form>
                            <form action="{{ route('pagibig.destroy', $rate->id) }}" method="POST"
                                onsubmit="return confirm('Are you sure you want to delete this rate?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit"
                                    class="bg-red-600 text-white px-3 py-1 rounded-md hover:bg-red-700 text-xs">
                                    Delete
                                </button>
                            </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <script>
                $(document).ready(function() {
                    $('#philhealth').DataTable({
                        paging: true,
                        searching: true,
                        ordering: true,
                        columnDefs: [{
                                orderable: false,
                                targets: 8
                            } // Disable ordering on Actions column
                        ]
                    });
                });
            </script>
        </div>
    </div>

</div>
