<div class="grid grid-cols-1 gap-4 mt-10 md:grid-cols-4">
    <div>
        <form action="{{ route('charges.store') }}" method="POST" class="space-y-6">
            @csrf
            <div>
                <label for="service_charge" class="block text-sm font-medium text-gray-700">Service Charge</label>
                <input type="number" name="service_charge" id="service_charge" step="0.01"
                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring focus:ring-blue-500 focus:border-blue-500"
                    value="{{ old('service_charge') }}" required />
            </div>

            <div>
                <label for="vat" class="block text-sm font-medium text-gray-700">VAT (12%)</label>
                <input type="number" name="vat" id="vat" step="0.01"
                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring focus:ring-blue-500 focus:border-blue-500"
                    value="{{ old('vat') }}" required />
            </div>

            <div>
                <label for="withholding_tax" class="block text-sm font-medium text-gray-700">Withholding Tax
                    (2%)</label>
                <input type="number" name="withholding_tax" id="withholding_tax" step="0.01"
                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring focus:ring-blue-500 focus:border-blue-500"
                    value="{{ old('withholding_tax') }}" required />
            </div>

            <div class="mt-6">
                <button type="submit"
                    class="inline-flex justify-center px-4 py-2 text-sm font-medium text-white bg-blue-600 border border-transparent rounded-md shadow-sm hover:bg-blue-700">
                    Add Charges
                </button>
            </div>

        </form>
    </div>
    <div class="w-full col-span-3 p-6 mx-auto bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table id="shiftTable" class="min-w-full border border-collapse border-gray-200 table-auto">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-4 py-2 border">ID</th>
                        <th class="px-4 py-2 border">Shift Name</th>
                        <th class="px-4 py-2 border">Shift Start</th>
                        <th class="px-4 py-2 border">Shift End</th>
                        <th class="px-4 py-2 border">Status</th>
                    </tr>
                </thead>
            </table>
        </div>



    </div>

</div>
<script>
    $(document).ready(function() {
        $('#shiftTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('shifts.index') }}",
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'shift_name',
                    name: 'shift_name'
                },
                {
                    data: 'shift_start',
                    name: 'shift_start'
                },
                {
                    data: 'shift_end',
                    name: 'shift_end'
                },
                {
                    data: 'status',
                    name: 'status'
                }
            ]
        });
    });
</script>
