<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Manpower Requisition Form</title>
    <style>
        body {
            font-family: 'Georgia', serif;
            font-size: 10pt;
            color: #000;
            margin: 5mm;
            background-color: #fff;
        }

        h1 {
            text-align: center;
            font-size: 12pt;
            margin-bottom: 2mm;
            text-transform: uppercase;
        }

        .sub-header {
            text-align: center;
            font-size: 9pt;
            font-style: italic;
            margin-bottom: 3mm;
        }

        table.form-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9pt;
        }

        table.form-table td {
            padding: 1.5mm 1mm;
            vertical-align: top;
        }

        .label {
            font-weight: bold;
            width: 25%;
            white-space: nowrap;
        }

        .value {
            border-bottom: 1px solid #ccc;
            display: inline-block;
            width: 100%;
        }

        .section-title {
            font-weight: bold;
            font-size: 10pt;
            background-color: #eee;
            text-transform: uppercase;
            padding: 1mm;
            margin-top: 4mm;
        }

        .signature-section {
            margin-top: 5mm;
            font-size: 9pt;
        }

        .signature-row td {
            text-align: center;
            padding-top: 10mm;
        }

        .signature-line {
            border-top: 1px solid #000;
            margin: 0 auto 2mm auto;
            height: 1px;
            width: 80%;
        }

        .printed-name {
            font-style: italic;
            font-size: 8pt;
        }

        .logo {
            text-align: center;
            margin-bottom: 3mm;
        }

        .logo img {
            max-height: 40px;
        }

        table.applicant-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 4mm;
            font-size: 9pt;
        }

        table.applicant-table th,
        table.applicant-table td {
            border: 1px solid #ccc;
            padding: 4px;
            text-align: center;
        }

        table.applicant-table th {
            background-color: #f5f5f5;
        }

        table.applicant-table tr:hover {
            background-color: #f9f9f9;
        }
    </style>
</head>

<body>
    <div class="logo">
        @if (!empty($requisition->client->agency->contact_person))
            <img src="{{ public_path($requisition->client->agency->contact_person) }}" alt="Agency Logo">
        @endif
    </div>

    <h1>Manpower Requisition Form</h1>
    <div class="sub-header">Date: {{ now()->format('F j, Y') }}</div>

    <div class="section-title">Requesting Details & Job Info</div>
    <table class="form-table">
        <tr>
            <td class="label">Agency:</td>
            <td class="value">{{ $requisition->client->agency->name ?? 'N/A' }}</td>
            <td class="label">Company:</td>
            <td class="value">{{ $requisition->client->business_name ?? 'N/A' }}</td>
        </tr>
        <tr>
            <td class="label">Department:</td>
            <td class="value">{{ $requisition->department->department_name ?? 'N/A' }}</td>
            <td class="label">Designation:</td>
            <td class="value">{{ $requisition->designation ?? 'N/A' }}</td>
        </tr>
        <tr>
            <td class="label">Date Requested:</td>
            <td class="value">{{ $requisition->created_at->timezone('Asia/Manila')->format('F j, Y \a\t g:i A') }}</td>
            <td class="label">Job Title:</td>
            <td class="value">{{ $requisition->job_title }}</td>
        </tr>
        <tr>
            <td class="label">Vacancies:</td>
            <td class="value">{{ $requisition->vacant_no }}</td>
            <td class="label">Recruitment Type:</td>
            <td class="value">{{ ucfirst($requisition->rec_type) }}</td>
        </tr>
        <tr>
            <td class="label">To Be Filled Before:</td>
            <td class="value">{{ \Carbon\Carbon::parse($requisition->filled_date)->format('F j, Y') }}</td>
            @if (in_array('MRF Form Status', $privileges))
                <td class="label">Status:</td>
                <td class="value">{{ $requisition->status ?? 'Open' }}</td>
            @else
                <td colspan="2"></td>
            @endif
        </tr>
    </table>

    <div class="section-title">Manpower Type & Schedule</div>
    <table class="form-table">
        @if ($details && $details->isNotEmpty())
            @foreach ($details as $detail)
                <tr>
                    <td class="label">Per Store:</td>
                    <td class="value">{{ $detail->per_store }}</td>
                    <td class="label">Frequency:</td>
                    <td class="value">{{ $detail->frequency }}</td>
                </tr>
            @endforeach
        @else
            <tr>
                <td class="label">Type:</td>
                <td class="value">Roving</td>
                <td colspan="2"></td>
            </tr>
        @endif
    </table>

    <div class="section-title">Additional Information</div>
    <table class="form-table">
        <tr>
            <td class="label">Project Name:</td>
            <td class="value">{{ $requisition->project_name }}</td>
            <td class="label">Replacement For:</td>
            <td class="value">{{ $requisition->replacement }}</td>
        </tr>
        <tr>
            <td class="label">Reason:</td>
            <td class="value">{{ ucfirst($requisition->reasons) }}</td>
            <td class="label">Vacancy From:</td>
            <td class="value">{{ ucfirst($requisition->vacant_form) }}</td>
        </tr>
    </table>

    <div class="section-title">Applicants</div>
    <table class="applicant-table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Current Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($requisition->mrfapplicant as $employee)
                <tr>
                    <td>
                        {{ $employee->employee->first_name }}
                        {{ $employee->employee->middle_name }}
                        {{ $employee->employee->last_name }}
                    </td>
                    <td>{{ $employee->status }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="section-title">Signatures</div>
    <table class="form-table signature-section">
        <tr class="signature-row">
            <td>
                <div class="signature-line"></div>
                <strong>Requested By</strong><br>
                <div class="printed-name">(Printed Name & Signature)</div>
            </td>
            <td>
                <div class="signature-line"></div>
                <strong>Approved By</strong><br>
                <div class="printed-name">(Printed Name & Signature)</div>
            </td>
            <td>
                <div class="signature-line"></div>
                <strong>HR Department</strong><br>
                <div class="printed-name">(Printed Name & Signature)</div>
            </td>
        </tr>
    </table>
</body>

</html>
