<div id="logsModal{{ $employee->id }}" class="fixed inset-0 z-50 hidden overflow-y-auto bg-gray-800 bg-opacity-50">
    <div class="flex items-start justify-center min-h-screen">
        <div class="bg-white mt-20 rounded-lg shadow-lg w-3/4 md:w-1/2">
            <!-- Modal Header -->
            <div class="flex justify-between items-center p-4 border-b">
                <h5 class="text-lg font-medium">
                    Logs for
                    {{ $employee->employee->first_name }}
                    {{ $employee->employee->last_name }}
                </h5>
                <button class="text-gray-600 hover:text-gray-800"
                    onclick="closeModal('logsModal{{ $employee->id }}')">&times;</button>
            </div>

            <!-- Modal Body -->
            <div class="p-4">
                <table class="w-full border-collapse border border-gray-200">
                    <thead>
                        <tr class="bg-gray-100">
                            <th class="p-2 border border-gray-300">
                                Assign User</th>
                            <th class="p-2 border border-gray-300">
                                Created At</th>
                            <th class="p-2 border border-gray-300">
                                Deadline</th>
                            <th class="p-2 border border-gray-300">
                                Remarks</th>
                            <th class="p-2 border border-gray-300">
                                Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($employee->applicantLogs as $log)
                            <tr>
                                <td class="p-2 border border-gray-300">
                                    @php
                                        $user = App\Models\User::find($log->user_id);
                                    @endphp
                                    {{ $user->name }}
                                </td>
                                <td class="p-2 border border-gray-300">
                                    {{ $log->created_at->format('F jS, Y \a\t g:i A') }}
                                </td>
                                <td class="p-2 border border-gray-300">
                                    {{ \Carbon\Carbon::parse($log->date)->format('F jS, Y') }}
                                </td>
                                <td class="p-2 border border-gray-300">
                                    {{ $log->remarks }}
                                </td>
                                <td class="p-2 border border-gray-300">
                                    {{ $log->action }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Modal Footer -->
            <div class="flex justify-end p-4 border-t">
                <button type="button" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600"
                    onclick="closeModal('logsModal{{ $employee->id }}')">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    function openModal(modalId) {
        document.getElementById(modalId).classList.remove('hidden');
    }

    function closeModal(modalId) {
        document.getElementById(modalId).classList.add('hidden');
    }
</script>
