<script>
    document.addEventListener('DOMContentLoaded', () => {
        const container = document.getElementById('dynamic-input-container');
        const addButton = document.getElementById('add-input');

        // Function to add a new input group
        addButton.addEventListener('click', () => {
            const inputGroup = document.createElement('div');
            inputGroup.classList.add('dynamic-input', 'mb-4');
            inputGroup.innerHTML = `
            <div class="grid grid-cols-1 md:grid-cols-5 gap-10 w-full">
                <div class="mb-4 col-span-2">
                    <label class="block mb-1 text-gray-600">Per Store</label>
                    <input type="text" name="per_store[]" 
                        class="w-full p-2 border border-gray-300 rounded-md">
                </div>
                <div class="mb-4 col-span-2">
                    <label class="block mb-1 text-gray-600">Frequency of Duty</label>
                    <input type="text" name="frequency[]" 
                        class="w-full p-2 border border-gray-300 rounded-md">
                </div>
                  <div class="flex items-center">
                <button type="button" class="remove-input bg-red-500 text-white px-3 py-1 rounded-md hover:bg-red-600">Remove</button></div>
                </div>
            `;
            container.appendChild(inputGroup);

            // Add event listener to the remove button
            inputGroup.querySelector('.remove-input').addEventListener('click', () => {
                inputGroup.remove();
            });
        });

        // Add event listener to existing remove buttons
        container.querySelectorAll('.remove-input').forEach(button => {
            button.addEventListener('click', () => {
                button.closest('.dynamic-input').remove();
            });
        });
    });
</script>
<!-- Your existing modal -->
<div id="statusModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-75">
    <div class="w-1/3 mt-20 bg-white rounded-lg shadow-lg">
        <div class="px-6 py-4">
            <h2 id="modalTitle" class="text-sm font-bold text-gray-800"></h2>
            <p id="modalMessage" class="mt-2 text-sm text-gray-600"></p>
        </div>
        <div class="flex justify-end px-6 py-4 border-t border-gray-200">
            <button onclick="closeStatusModal()"
                class="px-4 py-2 mr-2 text-gray-600 bg-gray-200 rounded-md hover:bg-gray-300">Cancel</button>
            <button id="confirmStatusButton"
                class="px-4 py-2 text-white bg-blue-600 rounded-md hover:bg-blue-700">Confirm</button>
        </div>
    </div>
</div>

<script>
    let requisitionId = null;
    let status = null;

    // This function shows the modal with data from the select + id
    function showStatusModalDynamic(id) {
        const select = document.getElementById('status-select-' + id);
        if (!select) {
            alert('Status selector not found!');
            return;
        }

        const selectedStatus = select.value;

        if (!selectedStatus || selectedStatus === 'Change status') {
            alert('Please select a status before saving.');
            return;
        }

        requisitionId = id;
        status = selectedStatus;

        const modalTitle = document.getElementById('modalTitle');
        const modalMessage = document.getElementById('modalMessage');
        const confirmButton = document.getElementById('confirmStatusButton');

        // Customize modal content
        modalTitle.textContent = `${status} Requisition`;
        modalMessage.textContent = `Are you sure you want to set this requisition to "${status}"?`;
        confirmButton.textContent = `Confirm ${status}`;
        confirmButton.setAttribute('data-id', requisitionId);
        confirmButton.setAttribute('data-status', status);

        // Adjust button styling dynamically
        confirmButton.className = `px-4 py-2 text-white ${
            status === 'Approved' ? 'bg-green-600 hover:bg-green-700' : 'bg-blue-600 hover:bg-blue-700'
        } rounded-md`;

        document.getElementById('statusModal').classList.remove('hidden');
    }

    // Your confirm button triggers the AJAX call
    document.getElementById('confirmStatusButton').addEventListener('click', function() {
        const requisitionId = this.getAttribute('data-id');
        const status = this.getAttribute('data-status');
        sendStatusChangeRequest(requisitionId, status);
    });

    // AJAX POST request to update status
    function sendStatusChangeRequest(id, status) {
        $.ajax({
            url: "{{ route('requisitions.status') }}",
            type: "POST",
            data: {
                id: id,
                status: status,
                _token: "{{ csrf_token() }}"
            },
            success: function(response) {

                closeStatusModal();

                // Reload DataTable dynamically if initialized
                if ($.fn.DataTable.isDataTable('#reqTable')) {
                    $('#reqTable').DataTable().ajax.reload(null, false); // keep current page
                }
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                alert('An error occurred while updating the requisition status.');
            }
        });
    }

    // Close modal function
    function closeStatusModal() {
        document.getElementById('statusModal').classList.add('hidden');
    }
</script>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const selectElement = document.getElementById('toggle-select');
        const options = ['option1', 'option2']; // Limit to only two options

        // Add event listener for the dropdown
        selectElement.addEventListener('change', (event) => {
            const selectedValue = event.target.value;

            // Loop through all options and toggle visibility
            options.forEach(option => {
                const div = document.getElementById(option);
                if (option === selectedValue) {
                    div.classList.remove('hidden'); // Show the selected div
                } else {
                    div.classList.add('hidden'); // Hide the other div
                }
            });
        });
    });
</script>
