@extends('layouts.sidebar')
@section('title', 'Requisitions')
@section('content')

    @if (in_array('Manage Requisition', $privileges))
        <div class="flex flex-col justify-between py-5 md:flex-row">
            <h1 class="mb-4 text-xl font-bold">MRF</h1>
            @if (in_array('Create Requisition', $privileges))
                <button type="button"
                    class="modal-button w-40 h-10 bg-[#1d1d1d] text-white rounded-md text-xs cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700 "
                    onclick="openModal('mrf')">
                    Add MRF
                </button>
            @endif
        </div>

        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        <div class="overflow-auto p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
            <table id="reqTable" class="min-w-full bg-white border border-collapse border-gray-200 rounded shadow-md ">
                <thead>
                    <tr class="text-sm leading-normal  text-white uppercase bg-[#1d1d1d]">
                        <th>MRF No.</th>
                        <th>Status</th>
                        <th>Agency</th>
                        <th>Company</th>
                        <th>Client</th>

                        <th>Date</th>
                        <th>Deadline</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                    <!-- DataTables will populate this body -->
                </tbody>
            </table>
        </div>
        <!-- Approve Modal -->

        @include('Admin.Requisition.modal')
















        <script>
            $(document).ready(function() {
                $('#reqTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "{{ route('requisitions.index') }}", // Pointing to the index route
                    columns: [{
                            data: 'id',
                            name: 'id'
                        }, {
                            data: 'acceptbutton',
                            name: 'acceptbutton',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'client.agency.name',
                            name: 'client.agency.name'
                        },

                        {
                            data: 'client.business_name',
                            name: 'client.business_name'
                        },
                        {
                            data: 'department',
                            name: 'department'
                        },
                        {
                            data: 'created_at',
                            name: 'created_at'
                        },
                        {
                            data: 'filled_date',
                            name: 'filled_date'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ]

                });
            });
        </script>


    @endif
@endsection
