@extends('layouts.sidebar')
@section('title', 'Requisitions')
@section('content')

    @if (in_array('Manage Requisition', $privileges))

        <div class=" text-sm">
            <div class="flex items-center justify-between">
                <div> <a href="{{ route('requisitions.index') }}"
                        class="px-4 py-2 text-center text-white bg-blue-600 rounded-lg hover:bg-blue-900">
                        < Back </a>
                </div>

            </div>



            <div id="update-form-modal" class="w-full h-full pd-overlay ">
                <div class="max-w-full p-8 mx-auto my-10 bg-white border border-gray-200 rounded-lg shadow-md">
                    <div class="flex flex-col px-5 py-4 bg-white rounded-2xl">
                        <div class="flex items-center justify-between pb-4 border-b border-gray-200">
                            <h4 class="text-sm font-medium text-gray-900">Update and View Manpower Requisition</h4>
                            <div> <a href="{{ route('requisitions.downloadmrf', ['requisition' => $requisition->id]) }}"
                                    class="inline-flex items-center px-4 py-2 text-white bg-green-600 rounded hover:bg-green-700">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" stroke-width="2"
                                        viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"></path>
                                    </svg>
                                    Download MRF PDF
                                </a></div>
                        </div>

                        <h1 class="mb-6 text-3xl font-bold text-center text-gray-800">Manpower Requisition
                            Form</h1>
                        <p class="mb-2 font-bold">MRF No. {{ $requisition->id }}</p>

                        <p class="mb-4 text-gray-600">
                            Notes: This MR must be updated with any changes in the requisition. Ensure all fields
                            are
                            accurate
                            before submitting.
                        </p>
                        <div class="grid grid-cols-1 gap-10 lg:grid-cols-3">
                            <div>

                                @if (session('success'))
                                    <div id="successModal"
                                        class="fixed inset-0 z-50 flex items-center justify-center bg-gray-900 bg-opacity-50">
                                        <div
                                            class="flex flex-col items-center justify-center w-full max-w-2xl p-6 bg-white rounded-lg shadow-lg">
                                            <i class="text-3xl bx bx-check-circle"></i>
                                            <p class="mb-5 text-lg font-semibold text-center">
                                                {{ session('success') }}
                                            </p>
                                        </div>
                                    </div>
                                    <script>
                                        // Automatically close the modal after 5 seconds
                                        setTimeout(function() {
                                            document.getElementById('successModal').style.display = 'none';
                                        }, 3000); // 5000 milliseconds = 5 seconds
                                    </script>
                                @endif

                                <form action="{{ route('requisitions.update', $requisition->id) }}" method="POST">
                                    @csrf
                                    @method('PUT')
                                    @if (!in_array('Client Interface', $privileges))
                                        <div class="mb-6">
                                            <h2 class="mb-2 text-2xl font-semibold text-gray-700">Manpower Required
                                                By:
                                            </h2>
                                            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">

                                                <div>
                                                    <label class="block mb-1 text-gray-600">Select Agency:</label>
                                                    <select id="agency" name="agency_id"
                                                        class="w-full p-2 border border-gray-300 rounded-md" required>
                                                        <option value="" disabled>Select an Agency</option>
                                                        @foreach ($agencies as $agency)
                                                            <option value="{{ $agency->id }}"
                                                                {{ $agency->id == $requisition->agency_id ? 'selected' : '' }}>
                                                                {{ $agency->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>



                                                <div>
                                                    <label class="block mb-1 text-gray-600">Select Company:</label>
                                                    <select id="clientAccount" name="client_id"
                                                        class="w-full p-2 border border-gray-300 rounded-md" required>
                                                        <option value="" disabled>Select a Company</option>
                                                        @foreach ($clients as $client)
                                                            <option value="{{ $client->id }}"
                                                                {{ $client->id == $requisition->client_id ? 'selected' : '' }}>
                                                                Client: {{ $client->business_name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div>
                                                    <label class="block mb-1 text-gray-600">Department:</label>
                                                    <select id="department_id" name="department_id"
                                                        class="w-full p-2 border border-gray-300">
                                                        <option value="" disabled>Select a Department</option>
                                                        @foreach ($departments as $department)
                                                            <option value="{{ $department->id }}"
                                                                {{ $department->id == $requisition->department_id ? 'selected' : '' }}>
                                                                {{ $department->department_name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div>
                                                    <label class="block mb-1 text-gray-600">Designation:</label>
                                                    <input type="text" name="designation"
                                                        class="w-full p-2 border border-gray-300 rounded-md"
                                                        value="{{ old('designation', $requisition->designation) }}"
                                                        required>
                                                </div>

                                                <script>
                                                    $(document).ready(function() {
                                                        $('#agency').change(function() {
                                                            var agencyId = $(this).val();
                                                            if (agencyId) {
                                                                var url = '{{ route('get_companies', ':agencyId') }}';
                                                                url = url.replace(':agencyId', agencyId);

                                                                $.ajax({
                                                                    url: url,
                                                                    type: 'GET',
                                                                    success: function(data) {
                                                                        $('#company').empty();
                                                                        $('#company').append(
                                                                            '<option value="" disabled selected>Select a Company</option>'
                                                                        );

                                                                        $.each(data, function(key, value) {
                                                                            $('#company').append('<option value="' + value.id +
                                                                                '">' + value.name + '</option>');
                                                                        });
                                                                    }
                                                                });
                                                            } else {
                                                                $('#company').empty().append(
                                                                    '<option value="" disabled selected>Select a Company</option>');
                                                            }
                                                        });

                                                        $('#company').change(function() {
                                                            var companyId = $(this).val();
                                                            if (companyId) {
                                                                var url = '{{ route('get_clients_by_company', ':companyId') }}';
                                                                url = url.replace(':companyId', companyId);

                                                                $.ajax({
                                                                    url: url,
                                                                    type: 'GET',
                                                                    success: function(data) {
                                                                        $('#clientAccount').empty();
                                                                        $('#clientAccount').append(
                                                                            '<option value="" disabled selected>Select a Client</option>'
                                                                        );

                                                                        $.each(data, function(key, value) {
                                                                            $('#clientAccount').append('<option value="' + value
                                                                                .id + '">Client: ' + value.business_name +
                                                                                '</option>');
                                                                        });
                                                                    }
                                                                });
                                                            } else {
                                                                $('#clientAccount').empty().append(
                                                                    '<option value="" disabled selected>Select a Client</option>');
                                                            }
                                                        });

                                                        $('#clientAccount').change(function() {
                                                            var clientId = $(this).val();
                                                            if (clientId) {
                                                                var url = '{{ route('get_department', ':clientId') }}';
                                                                url = url.replace(':clientId', clientId);

                                                                $.ajax({
                                                                    url: url,
                                                                    type: 'GET',
                                                                    success: function(data) {
                                                                        $('#department_id').empty();
                                                                        $('#department_id').append(
                                                                            '<option value="" disabled selected>Select a Department</option>'
                                                                        );

                                                                        $.each(data, function(key, value) {
                                                                            $('#department_id').append('<option value="' + value
                                                                                .id + '">' + value.department_name + '</option>'
                                                                            );
                                                                        });
                                                                    }
                                                                });
                                                            } else {
                                                                $('#department_id').empty().append(
                                                                    '<option value="" disabled selected>Select a Department</option>');
                                                            }
                                                        });
                                                    });
                                                </script>

                                                <div>
                                                    <label class="block mb-1 text-gray-600">Date:</label>
                                                    <div class="flex items-center pt-2">
                                                        {{ $requisition->created_at->timezone('Asia/Manila')->format('F jS, Y \a\t g:i A') }}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <h2 class="mb-2 text-2xl font-semibold text-gray-700">Manpower Details:</h2>
                                        @if ($details && $details->isNotEmpty())
                                            <h2 class="mb-2 text-sm font-semibold text-gray-700">Stationary</h2>
                                            <div class="mt-4 border-2 border-black p-3 rounded">
                                                @foreach ($details as $detail)
                                                    <div class="dynamic-input grid grid-cols-1 md:grid-cols-2 gap-10">
                                                        <div class="mb-4 ">
                                                            <label class="block mb-1 text-gray-600">Per
                                                                Store</label>
                                                            <input type="text" name="per_store[]"
                                                                class="w-full p-2 border border-gray-300 rounded-md"
                                                                value="{{ $detail->per_store }}">
                                                        </div>
                                                        <div class="mb-4 ">
                                                            <label class="block mb-1 text-gray-600">Frequency of
                                                                Duty</label>
                                                            <input type="text" name="frequency[]"
                                                                class="w-full p-2 border border-gray-300 rounded-md"
                                                                value="{{ $detail->frequency }}">
                                                        </div>

                                                    </div>
                                                @endforeach
                                            </div>
                                        @else
                                            <h2 class="mb-2 text-sm font-semibold text-gray-700">Roving</h2>
                                        @endif
                                        <div class="mb-6">

                                            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                                                <div class="mb-5">
                                                    <label for="toggle-select"
                                                        class="block mb-2 text-sm font-medium text-gray-700">Select
                                                        Store:</label>
                                                    <select name="store_id"
                                                        class="block w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring focus:ring-indigo-500">
                                                        <option value="">-- Select an Option --</option>
                                                        @foreach ($stores as $store)
                                                            <option value="{{ $store->id }}"
                                                                {{ $requisition->store_id == $store->id ? 'selected' : '' }}>
                                                                {{ $store->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div>
                                                    <label class="block mb-1 text-gray-600">Job Title:</label>
                                                    <input type="text" name="job_title"
                                                        class="w-full p-2 border border-gray-300 rounded-md"
                                                        value="{{ old('job_title', $requisition->job_title) }}" required>
                                                </div>
                                                <div>
                                                    <label class="block mb-1 text-gray-600">No. of
                                                        Vacancies:</label>
                                                    <input type="number" name="vacant_no"
                                                        class="w-full p-2 border border-gray-300 rounded-md"
                                                        value="{{ old('vacant_no', $requisition->vacant_no) }}" required>
                                                </div>
                                                <div>
                                                    <label class="block mb-1 text-gray-600">Recruitment
                                                        Type:</label>
                                                    <select name="rec_type"
                                                        class="w-full p-2 border border-gray-300 rounded-md" required>
                                                        <option value="project_based"
                                                            {{ $requisition->rec_type == 'project_based' ? 'selected' : '' }}>
                                                            Project
                                                            Based</option>
                                                        <option value="replacement"
                                                            {{ $requisition->rec_type == 'replacement' ? 'selected' : '' }}>
                                                            Replacement
                                                        </option>
                                                        <option value="seasonal"
                                                            {{ $requisition->rec_type == 'seasonal' ? 'selected' : '' }}>
                                                            Seasonal
                                                        </option>
                                                        <option value="direct_hire"
                                                            {{ $requisition->rec_type == 'direct_hire' ? 'selected' : '' }}>
                                                            Direct Hire
                                                        </option>
                                                        <option value="other"
                                                            {{ $requisition->rec_type == 'other' ? 'selected' : '' }}>
                                                            Other
                                                        </option>
                                                    </select>
                                                </div>
                                                <div>
                                                    <label class="block mb-1 text-gray-600">Project Name:</label>
                                                    <input type="text" name="project_name"
                                                        class="w-full p-2 border border-gray-300 rounded-md"
                                                        value="{{ old('project_name', $requisition->project_name) }}">
                                                </div>
                                                <div>
                                                    <label class="block mb-1 text-gray-600">To be filled before
                                                        (Date):</label>
                                                    <input type="date" name="filled_date"
                                                        class="w-full p-2 border border-gray-300 rounded-md"
                                                        value="{{ old('filled_date', $requisition->filled_date) }}">
                                                </div>

                                            </div>
                                            @if (in_array('MRF Form Status', $privileges))
                                                <div class="">
                                                    <label for="status" class="block mb-1 text-gray-600">Select
                                                        Status:</label>
                                                    <select id="status" name="status"
                                                        class="w-full p-2 border border-gray-300 rounded-md" required>
                                                        @if (in_array('MRF Open', $privileges))
                                                            <option value=" "
                                                                {{ old('status', $requisition->status) === null ? 'selected' : '' }}>
                                                                Open
                                                            </option>
                                                        @endif
                                                        @if (in_array('MRF Approved', $privileges))
                                                            <option value="Approved"
                                                                {{ old('status', $requisition->status) == 'Approved' ? 'selected' : '' }}>
                                                                Approved</option>
                                                        @endif
                                                        @if (in_array('MRF For Approval', $privileges))
                                                            <option value="For Approval"
                                                                {{ old('status', $requisition->status) == 'For Approval' ? 'selected' : '' }}>
                                                                For Approval</option>
                                                        @endif
                                                        @if (in_array('MRF Meet & Greet', $privileges))
                                                            <option value="Meet & Greet / Intro"
                                                                {{ old('status', $requisition->status) == 'Meet & Greet / Intro' ? 'selected' : '' }}>
                                                                Meet & Greet / Intro</option>
                                                        @endif
                                                        @if (in_array('MRF Process Requirement', $privileges))
                                                            <option value="Process Requirement"
                                                                {{ old('status', $requisition->status) == 'Process Requirement' ? 'selected' : '' }}>
                                                                Process Requirement</option>
                                                        @endif
                                                        @if (in_array('MRF Agency Orientation', $privileges))
                                                            <option value="Agency Orientation"
                                                                {{ old('status', $requisition->status) == 'Agency Orientation' ? 'selected' : '' }}>
                                                                Agency Orientation</option>
                                                        @endif
                                                        @if (in_array('MRF Client Orientation', $privileges))
                                                            <option value="Client Orientation"
                                                                {{ old('status', $requisition->status) == 'Client Orientation' ? 'selected' : '' }}>
                                                                Client Orientation</option>
                                                        @endif
                                                        @if (in_array('MRF Store Orientation', $privileges))
                                                            <option value="Store Orientation"
                                                                {{ old('status', $requisition->status) == 'Store Orientation' ? 'selected' : '' }}>
                                                                Store Orientation</option>
                                                        @endif
                                                        @if (in_array('MRF Deploy', $privileges))
                                                            <option value="Deploy"
                                                                {{ old('status', $requisition->status) == 'Deploy' ? 'selected' : '' }}>
                                                                Deploy</option>
                                                        @endif
                                                        @if (in_array('MRF Disapproved', $privileges))
                                                            <option value="Disapproved"
                                                                {{ old('status', $requisition->status) == 'Disapproved' ? 'selected' : '' }}>
                                                                Disapproved</option>
                                                        @endif
                                                        @if (in_array('MRF Cancel', $privileges))
                                                            <option value="Cancel"
                                                                {{ old('status', $requisition->status) == 'Cancel' ? 'selected' : '' }}>
                                                                Cancel</option>
                                                        @endif
                                                        @if (in_array('MRF Back Out', $privileges))
                                                            <option value="Back out"
                                                                {{ old('status', $requisition->status) == 'Back out' ? 'selected' : '' }}>
                                                                Back out</option>
                                                        @endif
                                                    </select>
                                                </div>
                                            @endif
                                            <div>
                                                <div class="space-y-2">
                                                    <p class="text-sm font-medium text-gray-700">Gender</p>
                                                    <div class="flex text-sm p-2 rounded-md items-center space-x-4">
                                                        <label class="inline-flex items-center">
                                                            <input type="radio" name="gender" value="male"
                                                                {{ $requisition->gender == 'male' ? 'checked' : '' }}
                                                                class="form-radio text-blue-600">
                                                            <span class="ml-2 text-gray-700">Male</span>
                                                        </label>
                                                        <label class="inline-flex items-center">
                                                            <input type="radio" name="gender" value="female"
                                                                {{ $requisition->gender == 'female' ? 'checked' : '' }}
                                                                class="form-radio text-pink-600">
                                                            <span class="ml-2 text-gray-700">Female</span>
                                                        </label>
                                                        <label class="inline-flex items-center">
                                                            <input type="radio" name="gender" value="female_or_male"
                                                                {{ $requisition->gender == 'other' ? 'checked' : '' }}
                                                                class="form-radio text-green-600">
                                                            <span class="ml-2 text-gray-700">Both Female and
                                                                Male</span>
                                                        </label>
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="mb-6">
                                                <h2 class="mb-2 text-2xl font-semibold text-gray-700 ">Additional
                                                    Details:
                                                </h2>
                                                <div class="mb-4">
                                                    <label class="block mb-1 text-gray-600">Project Name (if
                                                        project
                                                        based):</label>
                                                    <input type="text" name="project_name"
                                                        class="w-full p-2 border border-gray-300 rounded-md"
                                                        value="{{ old('project_name', $requisition->project_name) }}">
                                                </div>
                                                <div class="mb-4">
                                                    <label class="block mb-1 text-gray-600">Replacement for (name
                                                        of
                                                        employee):</label>
                                                    <input type="text" name="replacement"
                                                        class="w-full p-2 border border-gray-300 rounded-md"
                                                        value="{{ old('replacement', $requisition->replacement) }}">
                                                </div>
                                                <div class="mb-4">
                                                    <label for="reasons" class="block mb-1 text-gray-600">Reasons
                                                        for
                                                        Additional Position:</label>
                                                    <select name="reasons" id="reasons"
                                                        class="w-full p-2 border border-gray-300 rounded-md" required>
                                                        <option value="resignation"
                                                            {{ old('reasons', $requisition->reasons) === 'resignation' ? 'selected' : '' }}>
                                                            Resignation
                                                        </option>
                                                        <option value="termination"
                                                            {{ old('reasons', $requisition->reasons) === 'termination' ? 'selected' : '' }}>
                                                            Termination
                                                        </option>
                                                        <option value="promotion"
                                                            {{ old('reasons', $requisition->reasons) === 'promotion' ? 'selected' : '' }}>
                                                            Promotion
                                                        </option>
                                                        <option value="transfer"
                                                            {{ old('reasons', $requisition->reasons) === 'transfer' ? 'selected' : '' }}>
                                                            Transfer
                                                        </option>
                                                    </select>
                                                </div>

                                                <div class="mb-4">
                                                    <label for="vacant_form" class="block mb-1 text-gray-600">Vacancy
                                                        to
                                                        be
                                                        filled from:</label>
                                                    <select name="vacant_form" id="vacant_form"
                                                        class="w-full p-2 border border-gray-300 rounded-md" required>
                                                        <option value="within"
                                                            {{ old('vacant_form', $requisition->vacant_form) === 'within' ? 'selected' : '' }}>
                                                            Within
                                                        </option>
                                                        <option value="outside"
                                                            {{ old('vacant_form', $requisition->vacant_form) === 'outside' ? 'selected' : '' }}>
                                                            Outside
                                                        </option>
                                                    </select>
                                                </div>

                                            </div>
                                        </div>
                                    @else
                                        @include('Admin.Requisition.clientversion')
                                    @endif

                                    <div class="flex items-center justify-center gap-5 mt-6">
                                        @if (in_array('MRF Open', $privileges))
                                            <button type="submit"
                                                class="px-4 py-2 text-white bg-blue-600 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-75">
                                                Update
                                            </button>
                                        @endif
                                    </div>
                                </form>
                            </div>
                            <div class="text-xs col-span-2">



                                @if (in_array('MRF Add Applicant', $privileges))
                                    @include('Admin.Requisition.parts.add')
                                @endif
                                <form class="mt-4" action="{{ route('requisition.updateapplicant.submit') }}"
                                    method="POST">
                                    @csrf
                                    <div class="mb-6">
                                        <h2 class="mb-2 text-2xl font-semibold text-gray-700"> Applicants
                                            Details:</h2>
                                        <div class="overflow-x-auto">
                                            <table
                                                class="min-w-full text-center border border-gray-300 rounded-md shadow-sm">
                                                <thead>
                                                    <tr class="text-gray-700 bg-gray-100">
                                                        <th class="px-4 py-2 border-b">Name</th>
                                                        <th class="px-4 py-2 border-b">View More Details</th>
                                                        <th class="px-4 py-2 border-b">Current Status</th>

                                                        <th class="px-4 py-2 border-b">Update Status</th>
                                                        <th class="px-4 py-2 border-b">Set Deadline</th>
                                                        <th class="px-4 py-2 border-b">Special Remarks</th>
                                                        <th class="px-4 py-2 border-b">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($requisition->mrfapplicant as $employee)
                                                        <tr class="border-b hover:bg-gray-50">
                                                            <td class="px-4 py-2">
                                                                {{ $employee->employee->first_name }}
                                                                {{ $employee->employee->middle_name }}
                                                                {{ $employee->employee->last_name }}
                                                            </td>
                                                            <td class="px-4 py-2">
                                                                <div class="flex items-center justify-center"> <a
                                                                        href="{{ url('admin/pre-profile/' . Crypt::encrypt($employee->employee->id)) }}"
                                                                        class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit"><i
                                                                            class="text-xl bx bx-show"></i></a>
                                                                </div>

                                                            </td>

                                                            <td class="px-4 py-2">
                                                                {{ $employee->status }}

                                                            </td>




                                                            <td class="px-4 py-2">
                                                                <select name="update_status[{{ $employee->id }}]"
                                                                    class="w-[5rem] p-2 border border-gray-300 rounded-md">
                                                                    @if (in_array('MRF Open', $privileges))
                                                                        <option value="open"
                                                                            {{ $employee->status == 'open' ? 'selected' : '' }}>
                                                                            Open</option>
                                                                    @endif
                                                                    @if (in_array('MRF Approved', $privileges))
                                                                        <option value="approved"
                                                                            {{ $employee->status == 'approved' ? 'selected' : '' }}>
                                                                            Approved</option>
                                                                    @endif
                                                                    @if (in_array('MRF For Approval', $privileges))
                                                                        <option value="for_approval"
                                                                            {{ $employee->status == 'for_approval' ? 'selected' : '' }}>
                                                                            For Approval</option>
                                                                    @endif
                                                                    @if (in_array('MRF Meet & Greet', $privileges))
                                                                        <option value="meet_greet_intro"
                                                                            {{ $employee->status == 'meet_greet_intro' ? 'selected' : '' }}>
                                                                            Meet & Greet / Intro</option>
                                                                    @endif
                                                                    @if (in_array('MRF Process Requirement', $privileges))
                                                                        <option value="process_requirement"
                                                                            {{ $employee->status == 'process_requirement' ? 'selected' : '' }}>
                                                                            Process Requirement</option>
                                                                    @endif
                                                                    @if (in_array('MRF Agency Orientation', $privileges))
                                                                        <option value="agency_orientation"
                                                                            {{ $employee->status == 'agency_orientation' ? 'selected' : '' }}>
                                                                            Agency Orientation</option>
                                                                    @endif
                                                                    @if (in_array('MRF Client Orientation', $privileges))
                                                                        <option value="client_orientation"
                                                                            {{ $employee->status == 'client_orientation' ? 'selected' : '' }}>
                                                                            Client Orientation</option>
                                                                    @endif
                                                                    @if (in_array('MRF Store Orientation', $privileges))
                                                                        <option value="store_orientation"
                                                                            {{ $employee->status == 'store_orientation' ? 'selected' : '' }}>
                                                                            Store Orientation</option>
                                                                    @endif
                                                                    @if (in_array('MRF Deploy', $privileges))
                                                                        <option value="deploy"
                                                                            {{ $employee->status == 'deploy' ? 'selected' : '' }}>
                                                                            Deploy</option>
                                                                    @endif
                                                                    @if (in_array('MRF Disapproved', $privileges))
                                                                        <option value="disapproved"
                                                                            {{ $employee->status == 'disapproved' ? 'selected' : '' }}>
                                                                            Disapproved</option>
                                                                    @endif
                                                                    @if (in_array('MRF Cancel', $privileges))
                                                                        <option value="cancel"
                                                                            {{ $employee->status == 'cancel' ? 'selected' : '' }}>
                                                                            Cancel</option>
                                                                    @endif
                                                                    @if (in_array('MRF Cancel', $privileges))
                                                                        <option value="delete"
                                                                            {{ $employee->status == 'delete' ? 'selected' : '' }}>
                                                                            Delete</option>
                                                                    @endif
                                                                    @if (in_array('MRF Back Out', $privileges))
                                                                        <option value="Back out"
                                                                            {{ old('status', $employee->status) == 'Back out' ? 'selected' : '' }}>
                                                                            Back out</option>
                                                                    @endif
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <input type="date"
                                                                    name="update_date[{{ $employee->id }}]"
                                                                    class="border-2 border-black" value="">
                                                            </td>
                                                            <td class="px-4 py-2">
                                                                <textarea name="remarks[{{ $employee->id }}]" class="border-2 border-black" rows="3" cols="30"></textarea>

                                                            </td>
                                                            <td>
                                                                <button type="button"
                                                                    class="bg-blue-500 text-white px-3 py-1 rounded"
                                                                    onclick="openModal('logsModal{{ $employee->id }}')">
                                                                    <i class="text-xl bx bx-show"></i>
                                                                </button>
                                                                <button type="button"
                                                                    class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600"
                                                                    data-route="{{ route('applicants.destroy', $employee->id) }}"
                                                                    onclick="openDeleteModal(this)">
                                                                    <i class="text-xl bx bx-trash"></i>
                                                                </button>
                                                                @include('Admin.Requisition.parts.modal')

                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <p class="mt-2 text-sm text-gray-500">Update the status of the existing
                                            employees as needed.</p>
                                        @if (in_array('MRF Form Status', $privileges) || $requisition->status == 'For Approval')
                                            <button type="submit"
                                                class="w-full p-2 my-5 text-white bg-blue-500 rounded-md hover:bg-blue-600">Update</button>
                                        @endif
                                    </div>
                                </form>
                                <div id="globalDeleteModal"
                                    class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                    <div class="bg-white rounded-lg shadow-lg p-6 w-full max-w-md">
                                        <h2 class="text-xl font-semibold mb-4 text-gray-800">Confirm Deletion</h2>
                                        <p class="mb-6 text-gray-600">Are you sure you want to delete this
                                            applicant? This action cannot be undone.</p>
                                        <form id="deleteApplicantForm" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <div class="flex justify-end space-x-3">
                                                <button type="button" onclick="closeDeleteModal()"
                                                    class="px-4 py-2 bg-gray-300 text-gray-800 rounded hover:bg-gray-400">
                                                    Cancel
                                                </button>
                                                <button type="submit"
                                                    class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700">
                                                    Confirm Delete
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <script>
                                    function openDeleteModal(button) {
                                        const route = button.getAttribute('data-route');
                                        const form = document.getElementById('deleteApplicantForm');
                                        form.action = route;
                                        document.getElementById('globalDeleteModal').classList.remove('hidden');
                                    }

                                    function closeDeleteModal() {
                                        document.getElementById('globalDeleteModal').classList.add('hidden');
                                    }
                                </script>
                            </div>
                        </div>
                    </div>

                    <div class="flex items-center justify-center">
                        @include('Admin.Requisition.parts.statuses')
                    </div>
                    @foreach ($mrf as $action)
                        <div class="mb-2 p-2 border-b border-gray-200">


                            <p><strong>User:</strong> {{ $action->user->name ?? 'Unknown User' }}</p>
                            <p><strong>Action:</strong>
                                @if (!in_array($action->action, ['Cancel', 'Approved', 'Disapproved']))
                                    Proceed to {{ $action->action ?? 'Open' }}
                                @else
                                    {{ $action->action ?? 'Open' }}
                                @endif
                            </p>

                            <p><strong>Timestamp:</strong>
                                {{ $action->created_at->timezone('Asia/Manila')->format('F jS, Y \a\t g:i A') }}
                            </p>

                            </p>
                        </div>
                    @endforeach

                    <!-- Confirmation Modal -->
                    <div id="confirmationModal"
                        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50">
                        <div class="w-1/3 p-6 mt-20 bg-white rounded-md shadow-md">
                            <h3 class="mb-4 text-lg font-semibold">Confirmation</h3>
                            <p class="mb-4">Are you sure you want to proceed with this action?</p>
                            <div class="flex justify-end">
                                <button id="cancelButton" class="px-4 py-2 mr-2 bg-gray-300 rounded-md"
                                    onclick="closeConfirmationModal()">Cancel</button>
                                <button id="confirmButton" class="px-4 py-2 text-white bg-red-600 rounded-md"
                                    onclick="submitForm()">Confirm</button>
                            </div>
                        </div>
                    </div>

                </div>

            </div>


        </div>


        <script>
            let formToSubmit = null;

            function showConfirmationModal(formId) {
                formToSubmit = document.getElementById(formId);
                document.getElementById('confirmationModal').classList.remove('hidden');
            }

            function closeConfirmationModal() {
                document.getElementById('confirmationModal').classList.add('hidden');
            }

            function submitForm() {
                if (formToSubmit) {
                    formToSubmit.submit();
                }
            }
        </script>

    @endif
@endsection
