<div class="mb-6">
    <h2 class="mb-2 text-2xl font-semibold text-gray-700">Manpower Required
        By:</h2>
    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
        <div>
            <label class="block mb-1 text-gray-600">Selected
                Agency:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ $requisition->client->agency->name ?? 'N/A' }}
            </p>
        </div>
        <div>
            <label class="block mb-1 text-gray-600">Selected
                Company:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ $requisition->client->business_name ?? 'N/A' }}
            </p>
        </div>
        <div>
            <label class="block mb-1 text-gray-600">Department:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ $requisition->department->department_name ?? 'N/A' }}
            </p>
        </div>
        <div>
            <label class="block mb-1 text-gray-600">Designation:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ $requisition->designation ?? 'N/A' }}
            </p>
        </div>
        <div>
            <label class="block mb-1 text-gray-600">Date:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ $requisition->created_at->timezone('Asia/Manila')->format('F jS, Y \a\t g:i A') }}
            </p>
        </div>
    </div>
</div>
<h2 class="mb-2 text-2xl font-semibold text-gray-700">Manpower Details:
</h2>
@if ($details && $details->isNotEmpty())
    <h2 class="mb-2 text-sm font-semibold text-gray-700">Stationary</h2>
    <div class="mt-4 border-2 border-black p-3 rounded">
        @foreach ($details as $detail)
            <div class="dynamic-input grid grid-cols-1 md:grid-cols-2 gap-10">
                <div class="mb-4">
                    <label class="block mb-1 text-gray-600">Per
                        Store</label>
                    <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                        {{ $detail->per_store }}
                    </p>
                </div>
                <div class="mb-4">
                    <label class="block mb-1 text-gray-600">Frequency of
                        Duty</label>
                    <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                        {{ $detail->frequency }}
                    </p>
                </div>
            </div>
        @endforeach
    </div>
@else
    <h2 class="mb-2 text-sm font-semibold text-gray-700">Roving</h2>
@endif
<div class="mb-6">
    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
        <div>
            <label class="block mb-1 text-gray-600">Job Title:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ $requisition->job_title }}
            </p>
        </div>
        <div>
            <label class="block mb-1 text-gray-600">No. of
                Vacancies:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ $requisition->vacant_no }}
            </p>
        </div>
        <div>
            <label class="block mb-1 text-gray-600">Recruitment
                Type:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ ucfirst($requisition->rec_type) }}
            </p>
        </div>
        <div>
            <label class="block mb-1 text-gray-600">Project Name:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ $requisition->project_name }}
            </p>
        </div>
        <div>
            <label class="block mb-1 text-gray-600">To be filled before
                (Date):</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ \Carbon\Carbon::parse($requisition->filled_date)->format('F j, Y') }}
            </p>
        </div>
        @if (in_array('MRF Form Status', $privileges))
            <div>
                <label for="status" class="block mb-1 text-gray-600">Select Status:</label>
                <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                    {{ $requisition->status ?? 'Open' }}
                </p>
            </div>
        @endif
    </div>

    <div class="mb-6">
        <h2 class="mb-2 text-2xl font-semibold text-gray-700">Additional
            Details:</h2>
        <div class="mb-4">
            <label class="block mb-1 text-gray-600">Project Name (if
                project based):</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ $requisition->project_name }}
            </p>
        </div>
        <div class="mb-4">
            <label class="block mb-1 text-gray-600">Replacement for (name
                of employee):</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ $requisition->replacement }}
            </p>
        </div>
        <div class="mb-4">
            <label for="reasons" class="block mb-1 text-gray-600">Reasons
                for Additional Position:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ ucfirst($requisition->reasons) }}
            </p>
        </div>

        <div class="mb-4">
            <label for="vacant_form" class="block mb-1 text-gray-600">Vacancy to be filled
                from:</label>
            <p class="w-full p-2 border border-gray-300 rounded-md bg-gray-100">
                {{ ucfirst($requisition->vacant_form) }}
            </p>
        </div>
    </div>
</div>
