@extends('layouts.sidebar')
@section('title', 'Users')
@section('content')
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <div class="min-h-screen p-6 text-gray-800 bg-white" x-data="{ selectedReport: null }">
        <div class="flex flex-col w-full h-full p-6 border rounded-lg shadow-md">

            <!-- Header -->
            <div class="mb-6">
                <h1 class="text-3xl font-bold text-center">Payroll Reports</h1>
                <p class="mt-1 text-sm text-center text-gray-600">Internal System - Generate Payroll Report</p>
            </div>

            <!-- Main Content -->
            <div class="flex flex-1 gap-6 overflow-hidden">

                <!-- Sidebar: Reports List -->
                <div class="w-1/4 p-4 overflow-y-auto border rounded-lg">
                    <h2 class="mb-4 text-lg font-semibold">Choose a Report</h2>
                    <ul class="space-y-2 text-sm">
                        <li @click="selectedReport = 1"
                            :class="selectedReport === 1 ? 'bg-gray-200 font-semibold' : 'hover:bg-gray-100'"
                            class="p-2 border rounded cursor-pointer">01. Dtr</li>
                        <li @click="selectedReport = 2"
                            :class="selectedReport === 2 ? 'bg-gray-200 font-semibold' : 'hover:bg-gray-100'"
                            class="p-2 border rounded cursor-pointer">02. Payslips</li>
                        <li @click="selectedReport = 3"
                            :class="selectedReport === 3 ? 'bg-gray-200 font-semibold' : 'hover:bg-gray-100'"
                            class="p-2 border rounded cursor-pointer">03. Employees</li>
                        <li @click="selectedReport = 4"
                            :class="selectedReport === 4 ? 'bg-gray-200 font-semibold' : 'hover:bg-gray-100'"
                            class="p-2 border rounded cursor-pointer">04. Premium Benefits</li>
                        {{-- <li @click="selectedReport = 5"
                            :class="selectedReport === 5 ? 'bg-gray-200 font-semibold' : 'hover:bg-gray-100'"
                            class="p-2 border rounded cursor-pointer">05. Contribution Lists</li>
                        <li @click="selectedReport = 6"
                            :class="selectedReport === 6 ? 'bg-gray-200 font-semibold' : 'hover:bg-gray-100'"
                            class="p-2 border rounded cursor-pointer">06. Remittance Disk</li>
                        <li @click="selectedReport = 7"
                            :class="selectedReport === 7 ? 'bg-gray-200 font-semibold' : 'hover:bg-gray-100'"
                            class="p-2 border rounded cursor-pointer">07. History of Payroll</li> --}}
                    </ul>
                </div>

                <!-- Main Panel: Dynamic Options -->
                <div class="flex flex-col  flex-1 space-y-6 overflow-y-auto">

                    <!-- Report 01: Transaction Summary -->
                    <!-- Report 01: Attendance Report -->
                    <!-- Report 01: Attendance Report -->
                    <section x-show="selectedReport === 1" x-transition class="p-6 bg-white rounded-lg shadow-sm border">

                        <!-- Form Title -->
                        <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center gap-2 border-b pb-2">
                            <i class="fas fa-user-clock text-blue-500"></i>
                            Generate Attendance Report
                        </h2>

                        <form action="{{ route('attendance.pdf') }}" method="GET">
                            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-end">
                                <div class="">
                                    <label for="department_id" class="mb-1 font-medium text-gray-700">Department <span
                                            class="text-red-500">*</span></label>
                                    <select name="department_id" id="department_id" required
                                        class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-blue-500 hover:border-gray-400 transition">
                                        <option value="">Select Department</option>
                                        @foreach ($client as $dept)
                                            <option value="{{ $dept->id }}"
                                                {{ request('department_id') == $dept->id ? 'selected' : '' }}>
                                                {{ $dept->department_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Employee Filter -->
                                <div class="">
                                    <label for="employee_id" class="mb-1 font-medium text-gray-700">Employee</label>
                                    <select name="employee_id" id="employee_id"
                                        class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-blue-500 hover:border-gray-400 transition">
                                        <option value="">All Employees</option>
                                        @foreach ($employees as $emp)
                                            <option value="{{ $emp->id }}"
                                                {{ request('employee_id') == $emp->id ? 'selected' : '' }}>
                                                {{ $emp->last_name }}, {{ $emp->first_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Start Date -->
                                <div class="">
                                    <label for="startDate" class="mb-1 font-medium text-gray-700">Start Date</label>
                                    <input type="date" name="startDate" id="startDate" value="{{ request('startDate') }}"
                                        class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-blue-500 hover:border-gray-400 transition">
                                </div>

                                <!-- End Date -->
                                <div class="">
                                    <label for="endDate" class="mb-1 font-medium text-gray-700">End Date</label>
                                    <input type="date" name="endDate" id="endDate" value="{{ request('endDate') }}"
                                        class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-blue-500 hover:border-gray-400 transition">
                                </div>
                            </div>
                            <div class="flex justify-center mt-4">
                                <button type="submit"
                                    class="flex items-center justify-center gap-2 bg-blue-600 text-white font-semibold px-5 py-2 rounded-md hover:bg-blue-700 focus:ring-2 focus:ring-blue-400 transition">
                                    <i class="fas fa-file-pdf"></i>
                                    Export PDF / ZIP
                                </button>
                            </div>
                        </form>
                    </section>


                    <!-- Report 02: Payroll Summary -->
                    <section x-show="selectedReport === 2" x-transition class="p-6 bg-white rounded-lg shadow-sm border">

                        <!-- Form Title -->
                        <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center gap-2 border-b pb-2">
                            <i class="fas fa-file-invoice-dollar text-blue-500"></i>
                            Download Payroll Report
                        </h2>

                        <form action="{{ route('payslips.download') }}" method="GET" x-data="{ departmentId: '', format: 'pdf' }"
                            class="grid grid-cols-1 md:grid-cols-2 gap-6">

                            <!-- Department Selection -->
                            <div class="flex flex-col">
                                <label for="departmentId" class="mb-1 font-medium text-gray-700">Select Department <span
                                        class="text-red-500">*</span></label>
                                <select name="departmentId" id="departmentId" x-model="departmentId" required
                                    class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-blue-500 hover:border-gray-400 transition">
                                    <option value="">Choose a Department</option>
                                    @foreach ($client as $dept)
                                        <option value="{{ $dept->id }}">{{ $dept->department_name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Batch Selection -->
                            <div class="flex flex-col">
                                <label for="batchId" class="mb-1 font-medium text-gray-700">Select Batch <span
                                        class="text-red-500">*</span></label>
                                <select name="batchId" id="batchId" required
                                    class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-blue-500 hover:border-gray-400 transition">
                                    <option value="">Choose a Batch</option>
                                    @foreach ($batches as $batch)
                                        <option value="{{ $batch->id }}"
                                            x-show="departmentId == '{{ $batch->department_id }}'">
                                            {{ \Carbon\Carbon::parse($batch->pay_period_start)->format('M d, Y') }} -
                                            {{ \Carbon\Carbon::parse($batch->pay_period_end)->format('M d, Y') }}
                                            ({{ $batch->contributiontype }} payroll {{ $batch->description }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Format Selection -->
                            <div class="flex flex-col">
                                <label for="format" class="mb-1 font-medium text-gray-700">Download As <span
                                        class="text-red-500">*</span></label>
                                <select name="format" id="format" x-model="format" required
                                    class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-blue-500 hover:border-gray-400 transition">
                                    <option value="pdf">PDF</option>
                                    <option value="excel">Excel</option>
                                </select>
                            </div>

                            <!-- Submit Button -->
                            <div class="col-span-2 flex justify-center">
                                <button type="submit"
                                    class="flex items-center justify-center gap-2 bg-blue-600 text-white font-semibold px-5 py-2 rounded-md hover:bg-blue-700 focus:ring-2 focus:ring-blue-400 transition">
                                    <i class="fas fa-download"></i>
                                    Download Payroll Report
                                </button>
                            </div>
                        </form>
                    </section>



                    <!-- Report 03: Payslips -->
                    <!-- Report 03: Employee Department Report -->
                    <section x-show="selectedReport === 3" x-transition class="p-6 bg-white rounded-lg shadow-sm border">

                        <!-- Form Title -->
                        <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center gap-2 border-b pb-2">
                            <i class="fas fa-users text-blue-500"></i>
                            Employee Department Report
                        </h2>

                        <!-- Filter Form -->
                        <form action="{{ route('reports.employee.departments') }}" method="GET"
                            class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">

                            <!-- Department Filter -->
                            <div class="col-span-2">
                                <label for="department_id" class="block mb-1 font-medium text-gray-700">Department</label>
                                <select name="department_id" id="department_id"
                                    class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-blue-500 hover:border-gray-400 transition">
                                    <option value="">All Departments</option>
                                    @foreach ($client as $dept)
                                        <option value="{{ $dept->id }}"
                                            {{ request('department_id') == $dept->id ? 'selected' : '' }}>
                                            {{ $dept->department_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Export Format -->
                            <div>
                                <label for="export" class="block mb-1 font-medium text-gray-700">Export Format</label>
                                <select name="export" id="export"
                                    class="w-full border border-gray-300 rounded-md p-2 focus:ring-2 focus:ring-blue-500 hover:border-gray-400 transition">
                                    <option value="">View Only</option>
                                    <option value="pdf" {{ request('export') == 'pdf' ? 'selected' : '' }}>PDF</option>
                                    <option value="excel" {{ request('export') == 'excel' ? 'selected' : '' }}>Excel
                                    </option>
                                </select>
                            </div>

                            <!-- Submit -->
                            <div class="flex items-end">
                                <button type="submit"
                                    class="flex items-center justify-center gap-2 bg-blue-600 text-white font-semibold px-4 py-2 rounded-md hover:bg-blue-700 focus:ring-2 focus:ring-blue-400 transition">
                                    <i class="fas fa-filter"></i>
                                    Apply
                                </button>
                            </div>
                        </form>
                    </section>


                    <!-- Report 04: Payroll Register -->
                    <section x-show="selectedReport === 4" x-transition class="p-6 border rounded-2xl bg-white shadow-sm">
                        <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center gap-2 border-b pb-2">
                            <i class="fas fa-file-invoice-dollar text-blue-500"></i>
                            Benefits Report
                        </h2>

                        <!-- Form -->
                        <form action="{{ route('reports.benefits') }}" method="GET"
                            class="grid grid-cols-1 md:grid-cols-4 gap-4">

                            <div class="col-span-5 w-full">
                                <label class="block mb-1 font-medium text-gray-700">Employee</label>
                                <select id="employee_id1" name="employee_id"
                                    class="w-full border border-gray-300 rounded-lg text-sm">
                                    <option value="">All Employees</option>
                                    @foreach ($employees as $employee)
                                        @php
                                            // Collect all department_ids this employee belongs to via channelclient
                                            $employeeDepartments = $employee->channelclient
                                                ->pluck('department_id')
                                                ->filter()
                                                ->toArray();
                                        @endphp

                                        <option value="{{ $employee->id }}"
                                            x-show="departmentId == '' || {{ json_encode($employeeDepartments) }}.includes(parseInt(departmentId))"
                                            {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                            {{ $employee->last_name }}, {{ $employee->first_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div>
                                <label class="block mb-1 font-medium text-gray-700">Start Date</label>
                                <input type="date" name="start_date" value="{{ request('start_date') }}"
                                    class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>

                            <!-- End Date -->
                            <div>
                                <label class="block mb-1 font-medium text-gray-700">End Date</label>
                                <input type="date" name="end_date" value="{{ request('end_date') }}"
                                    class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>

                            <div>
                                <label class="block mb-1 font-medium text-gray-700">Contribution Type</label>
                                <select name="type"
                                    class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                    <option value="">All</option>
                                    <option value="SSS" {{ request('type') == 'SSS' ? 'selected' : '' }}>SSS</option>
                                    <option value="Pag-IBIG" {{ request('type') == 'Pag-IBIG' ? 'selected' : '' }}>
                                        Pag-IBIG</option>
                                    <option value="PhilHealth" {{ request('type') == 'PhilHealth' ? 'selected' : '' }}>
                                        PhilHealth</option>
                                </select>
                            </div>

                            <!-- Export -->
                            <div>
                                <label class="block mb-1 font-medium text-gray-700">Export</label>
                                <select name="export"
                                    class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                    <option value="pdf">PDF</option>
                                    <option value="excel">Excel</option>
                                </select>
                            </div>

                            <!-- Submit Button -->
                            <div class="flex justify-center col-span-5">
                                <button type="submit"
                                    class="flex items-center gap-2 bg-blue-600 text-white px-4 py-2 rounded-lg text-sm font-medium hover:bg-blue-700 transition">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
                                    </svg>
                                    Generate
                                </button>
                            </div>
                        </form>
                    </section>

                    <!-- Put these at the bottom of your Blade layout (before </body>) -->
                    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css"
                        rel="stylesheet" />
                    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

                    <script>
                        document.addEventListener("DOMContentLoaded", function() {
                            function initSelect2() {
                                const $sel = $('#employee_id1');
                                if ($sel.length && !$sel.data('select2')) {
                                    $sel.select2({
                                        placeholder: "Select an employee",
                                        allowClear: true,
                                        width: '100%',
                                        dropdownParent: $sel.parent()
                                    });
                                }
                            }

                            // Initialize immediately if visible
                            initSelect2();

                            // Re-initialize when Alpine shows this section
                            document.addEventListener("alpine:init", () => {
                                Alpine.effect(() => {
                                    if (Alpine.store('selectedReport') === 4) {
                                        setTimeout(initSelect2, 100);
                                    }
                                });
                            });
                        });
                    </script>



                    <!-- Report 05: Contribution Lists -->
                    <section x-show="selectedReport === 5" x-transition class="p-6 border rounded-lg bg-gray-50">
                        <h2 class="mb-4 text-lg font-semibold">Contribution Lists Options</h2>
                        <!-- Add inputs -->
                    </section>

                    <!-- Report 06: Remittance Disk -->
                    <section x-show="selectedReport === 6" x-transition class="p-6 border rounded-lg bg-gray-50">
                        <h2 class="mb-4 text-lg font-semibold">Remittance Disk Options</h2>
                        <!-- Add inputs -->
                    </section>

                    <!-- Report 07: History of Payroll -->
                    <section x-show="selectedReport === 7" x-transition class="p-6 border rounded-lg bg-gray-50">
                        <h2 class="mb-4 text-lg font-semibold">History of Payroll Options</h2>
                        <!-- Add inputs -->
                    </section>

                </div>
            </div>
        </div>
    </div>

@endsection
