<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payroll Report</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        @page {
            size: 8.5in 13in;
            margin: 10px;
        }

        body {
            font-family: 'Poppins', sans-serif;
            margin: 10px;
            padding: 0;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 6px;
        }

        th,
        td {
            padding: 3px;
            text-align: left;
            border: 1px solid #ddd;
            font-size: 8px;
        }

        th {
            background-color: #f2f2f2;
            text-transform: uppercase;
            font-weight: 600;
        }

        .client-info {
            text-align: center;
            font-weight: 600;
            font-size: 0.9em;
            margin-bottom: 4px;
        }

        .client-info p {
            margin: 1px 0;
        }

        .employee-box {
            margin-top: 6px;
            padding: 0.3rem;
            border: 1px solid #000;
        }

        .logo {
            width: 6rem;
            margin-bottom: 4px;
        }

        .bank-info {
            font-size: 0.50rem;
            font-weight: bold;
        }
    </style>
</head>

<body>
    @foreach ($payrollData->chunk(6) as $chunk)
        <div class="client-info">
            <img class="logo" src="{{ $client->client->agency->contact_person }}">
            <p>{{ $client->client->agency->name }}</p>
            <p>{{ $client->department_name }} Summary Payroll Report (Batch ID: {{ $batchCode->id }})</p>
            <p>Period Cover: {{ \Carbon\Carbon::parse($batchCode->pay_period_start)->format('F j, Y') }}
                to {{ \Carbon\Carbon::parse($batchCode->pay_period_end)->format('F j, Y') }}</p>
        </div>

        @foreach ($chunk as $data)
            @php $payroll = $data['payroll']; @endphp
            <div class="employee-box">
                <table>
                    <thead>
                        <tr>
                            <th>Employee</th>
                            <th>Rate</th>
                            <th>Earnings</th>
                            <th>Deductions</th>
                            <th>Net Pay</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{{ $payroll->employee->last_name }}, {{ $payroll->employee->first_name }}
                                {{ $payroll->employee->middle_name ? $payroll->employee->middle_name[0] . '.' : '' }}
                            </td>
                            <td>{{ $payroll->rate }}</td>
                            <td>{{ number_format($data['gross'], 2) }}</td>
                            <td>{{ number_format($data['deductions'], 2) }}</td>
                            <td>{{ number_format($payroll->earnings, 2) }}</td>
                        </tr>
                    </tbody>
                </table>

                <div class="bank-info">
                    {{ optional($payroll->employee->channelBank?->bankprofile)->name ?? 'No Bank' }}
                    - {{ $payroll->employee->channelBank?->bankaccount ?? 'No Account' }}
                </div>

                <table class="min-w-full border border-gray-300">
                    <thead class="bg-gray-100 text-gray-700 text-sm">
                        <tr>
                            <th>Gross Pay & Allowances</th>
                            <th>Benefits</th>
                            <th>Deductions</th>
                            <th>Loans</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            {{-- Gross & Allowances --}}
                            <td>
                                <p>Basic Salary: P{{ number_format($payroll->basic_salary, 2) }}</p>
                                @foreach ($payroll->othersForPayroll as $other)
                                    <p>{{ $other->name }}: P{{ number_format($other->amount, 2) }}</p>
                                @endforeach
                            </td>

                            {{-- Benefits --}}
                            <td>
                                @foreach ($data['benefits'] as $benefit)
                                    <p>{{ $benefit['type'] }}: P{{ number_format($benefit['amount'], 2) }}</p>
                                @endforeach
                            </td>

                            {{-- Deductions --}}
                            <td>
                                @foreach ($payroll->trxConstantDeductions as $deduction)
                                    <p>{{ $deduction->trxConstant->trxCode->description ?? 'Deduction' }}:
                                        P{{ number_format($deduction->E_Amount, 2) }}</p>
                                @endforeach
                                @foreach ($data['nonStandardDeductions'] as $ns)
                                    <p>{{ $ns['type'] }}: P{{ number_format($ns['amount'], 2) }}</p>
                                @endforeach
                            </td>

                            {{-- Loans --}}
                            <td>
                                @foreach ($payroll->trxLoanDeductions as $loan)
                                    <p>{{ $loan->trxLoan->trxCode->description ?? 'Loan' }}:
                                        P{{ number_format($loan->Amount, 2) }}</p>
                                @endforeach
                            </td>
                        </tr>
                    </tbody>
                </table>

            </div>
        @endforeach
        <div style="page-break-after: always;"></div>
    @endforeach

    {{-- Summary Table --}}
    <table class="max-w-full min-w-full rounded-lg shadow-md">
        <thead class="border-2 border-black">
            <tr class="text-sm text-gray-700">
                <th>Trx Name</th>
                <th>Earnings</th>
                <th>Deduction</th>
            </tr>
        </thead>
        <tbody class="text-xs font-light text-center text-gray-600 border-b-2 border-black ">
            @php
                $earningsRows = [];
                $deductionRows = [];
                $totalEarnings = 0;
                $totalDeductions = 0;

                foreach ($payrollData as $data) {
                    $payroll = $data['payroll'];

                    $basic = $payroll->days_worked_withdeduction * $payroll->rate;
                    $earningsRows['Basic Salary'] = ($earningsRows['Basic Salary'] ?? 0) + $basic;
                    $totalEarnings += $basic;

                    foreach ($payroll->othersForPayroll as $other) {
                        $earningsRows[$other->name] = ($earningsRows[$other->name] ?? 0) + $other->amount;
                        $totalEarnings += $other->amount;
                    }

                    foreach ($data['benefits'] as $benefit) {
                        $deductionRows[$benefit['type']] = ($deductionRows[$benefit['type']] ?? 0) + $benefit['amount'];
                        $totalDeductions += $benefit['amount'];
                    }

                    foreach ($data['nonStandardDeductions'] as $ns) {
                        $deductionRows[$ns['type']] = ($deductionRows[$ns['type']] ?? 0) + $ns['amount'];
                        $totalDeductions += $ns['amount'];
                    }

                    foreach ($payroll->trxConstantDeductions as $deduction) {
                        $desc = $deduction->trxConstant->trxCode->description ?? 'Unknown';
                        if ($deduction->status == 1) {
                            $earningsRows[$desc] = ($earningsRows[$desc] ?? 0) + $deduction->E_Amount;
                            $totalEarnings += $deduction->E_Amount;
                        } else {
                            $deductionRows[$desc] = ($deductionRows[$desc] ?? 0) + $deduction->E_Amount;
                            $totalDeductions += $deduction->E_Amount;
                        }
                    }

                    foreach ($payroll->trxLoanDeductions as $loan) {
                        $desc = $loan->trxLoan->trxCode->description ?? 'Loan';
                        $deductionRows[$desc] = ($deductionRows[$desc] ?? 0) + $loan->Amount;
                        $totalDeductions += $loan->Amount;
                    }
                }

                ksort($earningsRows, SORT_NATURAL | SORT_FLAG_CASE);
                ksort($deductionRows, SORT_NATURAL | SORT_FLAG_CASE);
            @endphp

            {{-- Earnings --}}
            @foreach ($earningsRows as $name => $amount)
                <tr>
                    <td>{{ $name }}</td>
                    <td>P{{ number_format($amount, 2) }}</td>
                    <td></td>
                </tr>
            @endforeach

            {{-- Deductions --}}
            @foreach ($deductionRows as $name => $amount)
                <tr>
                    <td>{{ $name }}</td>
                    <td></td>
                    <td>P{{ number_format($amount, 2) }}</td>
                </tr>
            @endforeach
        </tbody>

        <tfoot class="text-sm font-bold text-center text-gray-700 bg-gray-100">
            <tr>
                <td>Total</td>
                <td>P{{ number_format($totalEarnings, 2) }}</td>
                <td>P{{ number_format($totalDeductions, 2) }}</td>
            </tr>
        </tfoot>
    </table>

</body>

</html>
