<div id="deletePayrollModal" class="fixed inset-0 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="w-1/3 p-6 bg-white rounded-lg shadow-lg">
        <h2 class="mb-4 text-xl font-bold">Confirm Delete</h2>
        <p class="mb-4">Are you sure you want to delete this payroll? This action cannot be undone.</p>
        <div class="flex justify-end space-x-4">
            <button type="button" id="deleteCancelBtn" class="px-4 py-2 text-white bg-gray-500 rounded">Cancel</button>
            <button type="button" id="deleteConfirmBtn" class="px-4 py-2 text-white bg-red-500 rounded">Delete</button>
        </div>
    </div>
</div>
<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    function confirmDeletePayroll(payrollId) {
        $('#deletePayrollModal').removeClass('hidden');

        $('#deleteConfirmBtn').off('click').on('click', function() {
            deletePayroll(payrollId);
        });

        $('#deleteCancelBtn').off('click').on('click', function() {
            $('#deletePayrollModal').addClass('hidden');
        });
    }

    // Function to perform the deletion via AJAX
    function deletePayroll(payrollId) {
        $.ajax({
            url: "{{ route('payrolls.destroy', ':payrollId') }}".replace(':payrollId', payrollId),
            method: 'DELETE',
            success: function(response) {
                $('#deletePayrollModal').addClass('hidden');
                $('#payrollsDataTable').DataTable().ajax.reload(null, false);
                alert('Payroll deleted successfully');
            },
            error: function(xhr, status, error) {
                alert("Error deleting payroll: " + error);
            }
        });
    }
</script>
<script>
    $(document).ready(function() {
        var batch_id = "{{ $batch_id }}";
        var status = "{{ $status }}";

        var table = $('#payrollsDataTable').DataTable({
            processing: true,
            serverSide: false, // client-side search only
            ajax: "{{ route('payroll.get', ['id' => $batch_id, 'status' => $status]) }}",
            columns: [{
                    data: 'employee.id',
                    name: 'employee.id'
                },
                {
                    data: function(row) {
                        return row.employee.first_name + ' ' + row.employee.middle_name + ' ' +
                            row.employee.last_name;
                    },
                    name: 'employee.first_name'
                },
                {
                    data: 'rate',
                    name: 'rate'
                },
                {
                    data: 'earnings',
                    name: 'earnings'
                },
                {
                    data: 'deduct',
                    name: 'deduct'
                },
                {
                    data: 'net_pay123',
                    name: 'net_pay123'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false,
                    width: '10%'
                },
                // 🔴 hidden searchable column for all extra fields
                {
                    data: function(row) {
                        return [
                            row.loan_deductions,
                            row.constant_deduction,
                            row.benefits,
                            row.remarks,
                            row.basic_salary,
                            row.others,
                            row.bank,
                            row.plus_adjustment,
                            row.deduct_adjustment
                        ].join(" ");
                    },
                    visible: false, // hide column
                    searchable: true // allow searching
                }
            ],
            order: [
                [0, 'asc']
            ],
            search: {
                smart: true,
                caseInsensitive: true
            },
            rowCallback: function(row, data, index) {
                $(row).off('click').on('click', function() {
                    var tableRow = table.row(row);
                    var detailRow = table.row(row).child;

                    if (detailRow.isShown()) {
                        tableRow.child.hide();
                        $(row).removeClass('shown');
                    } else {
                        var loanDeductionsHtml = data.loan_deductions;
                        var constantDeductionsHtml = data.constant_deduction;
                        var remarks = data.remarks;
                        var basic_salary = data.basic_salary;
                        var others = data.others;
                        var bank = data.bank;
                        var plus_adjustment = data.plus_adjustment;
                        var deduct_adjustment = data.deduct_adjustment;

                        var plus_adjustment_html = (parseFloat(plus_adjustment) > 0) ?
                            `<br>Adjustment - ${plus_adjustment}` : '';
                        var deduct_adjustment_html = (parseFloat(deduct_adjustment) > 0) ?
                            `<br>Deduction - ${deduct_adjustment}` : '';

                        // ✅ Now pulled directly from backend
                        var benefitsOnly = data.benefits;
                        var deductionFromBenefits = data.deductions_from_benefits;

                        // 🟢 1. Gross Pay & Allowances
                        var grossPaySection = (basic_salary || others ||
                                plus_adjustment_html) ?
                            `<div class="flex flex-col items-start">
                    <span class="font-semibold">Gross Pay & Allowances:</span>
                    ${basic_salary} ${others} ${plus_adjustment_html}
                </div>` : '';

                        var benefitsSection = benefitsOnly ?
                            `<div class="flex flex-col items-start">
                    <span class="font-semibold">Benefits:</span>
                    ${benefitsOnly}
                </div>` : '';

                        // 🔵 2. Deductions (excluding loans)
                        var deductionsSection = (constantDeductionsHtml ||
                                deduct_adjustment_html || deductionFromBenefits) ?
                            `<div class="flex flex-col items-start">
                    <span class="font-semibold">Deductions:</span>
                    ${constantDeductionsHtml} ${deduct_adjustment_html} ${deductionFromBenefits}
                </div>` : '';

                        // 🟠 3. Loans (separate section)
                        var loansSection = loanDeductionsHtml ?
                            `<div class="flex flex-col items-start">
                    <span class="font-semibold">Loans:</span>
                    ${loanDeductionsHtml}
                </div>` : '';

                        // 🟡 5. Remarks
                        var remarksSection = remarks ?
                            `<div class="flex flex-col items-start break-words">
                    <span class="font-semibold">Remarks:</span> ${remarks}
                </div>` : '';

                        // 🚀 Final Order: Gross Pay → Deductions → Loans → Benefits → Remarks
                        var gridContent = [
                            grossPaySection,
                            benefitsSection,
                            deductionsSection,
                            loansSection,
                            remarksSection
                        ].filter(Boolean).join('');

                        var childRowHtml = `
<div>
    <p>${bank}</p>
    <div class="flex items-center justify-center">
        <div class="grid grid-cols-1 p-3 gap-20 uppercase md:grid-cols-4 lg:grid-cols-4">
            ${gridContent}
        </div>
    </div>
</div>`;

                        tableRow.child(childRowHtml).show();
                        $(row).addClass('shown');
                    }
                });
            },
            drawCallback: function(settings) {
                var api = this.api();
                api.rows().every(function() {
                    var row = this.node();
                    if (!$(row).hasClass('shown')) {
                        $(row).trigger('click');
                    }
                });
            },
            footerCallback: function(row, data, start, end, display) {
                var api = this.api();

                var totalRate = 0;
                var totalEarnings = 0;
                var totalDeductions = 0;
                var totalNetPay = 0;

                api.column(2).data().each(function(value) {
                    totalRate += parseFloat(value) || 0;
                });
                api.column(3).data().each(function(value) {
                    totalEarnings += parseFloat(value) || 0;
                });
                api.column(4).data().each(function(value) {
                    totalDeductions += parseFloat(value) || 0;
                });
                api.column(5).data().each(function(value) {
                    totalNetPay += parseFloat(value) || 0;
                });

                $(api.table().footer()).find('#totalRate').text(totalRate.toFixed(2));
                $(api.table().footer()).find('#totalEarnings').text(totalEarnings.toFixed(2));
                $(api.table().footer()).find('#totalDeductions').text(totalDeductions.toFixed(2));
                $(api.table().footer()).find('#totalNetPay').text(totalNetPay.toFixed(2));
            }
        });
    });
</script>
