@extends('layouts.sidebar')

@section('title', 'Payroll for checking')
@section('content')
    @if (in_array('Payroll Checking', $privileges))

        <div class="flex flex-col justify-between py-5 md:flex-row">
            <h1 class="mb-4 font-bold">Payroll Creation</h1>
            @if (in_array('Create Payroll', $privileges))
                <button type="button" onclick="openModal('payrollModal')"
                    class="modal-button w-40 h-10 bg-[#1d1d1d] text-white rounded-md text-xs cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700">
                    Create Payroll
                </button>
            @endif
        </div>
        <script>
            function openModal(modalId) {
                var modal = document.getElementById(modalId);
                modal.classList.remove('hidden');
                modal.classList.add('flex');
            }

            // Function to close a modal
            function closeModal(modalId) {
                var modal = document.getElementById(modalId);
                modal.classList.add('hidden');
                modal.classList.remove('flex');
            }
        </script>

        <div class="">
            <div>
                @include('Admin.Payroll.modal')
            </div>
            <div class="col-span-4 ">
                @if (session('success'))
                    <div class="p-4 mb-4 text-sm text-white bg-green-500">
                        {{ session('success') }}
                    </div>
                @endif
                @if (session('error'))
                    <div class="p-4 mb-4 text-sm text-white bg-red-500">
                        {{ session('error') }}
                    </div>
                @endif
                <div class="p-2 overflow-auto border-2 border-black rounded-md ">
                    <table id="billing-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                        <thead>
                            <tr class="text-sm leading-normal text-white bg-black">
                                <th class="px-6 py-3">Batch Code</th>
                                <th class="px-6 py-3">Client</th>
                                <th class="px-6 py-3">Pay Period </th>

                                <th class="px-6 py-3">Number of Employee</th>
                                <th class="px-6 py-3">Description</th>
                                <th class="px-6 py-3">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-sm font-light text-center text-gray-600">
                            <!-- Data will be populated here by DataTables -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>

    @endif

    <script>
        $(document).ready(function() {
            // Initialize DataTable
            var employedTable = $('#billing-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('payrolls.index') }}",
                    data: function(d) {
                        // Custom data if needed
                    }
                },
                columns: [{
                        data: 'id',
                        name: 'id',
                        width: '10%'
                    },
                    {
                        data: 'client.department_name',
                        name: 'client.department_name',
                        width: '10%'
                    },
                    {
                        data: 'pay_period',
                        name: 'pay_period',
                        width: '10%'
                    },
                    {
                        data: 'employee_count',
                        name: 'employee_count',
                        width: '10%'
                    },
                    {
                        data: 'description',
                        name: 'description',
                        width: '10%'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false,
                        width: '10%'
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });

            $('form').on('submit', function(e) {
                e.preventDefault(); // Prevent default form submission

                var formData = $(this).serialize(); // Serialize form data
                var errorContainer = $(
                    "#error-container"); // Ensure you have a div with this ID in your HTML
                var successContainer = $("#success-container"); // Add a success message container
                var loadingOverlay = $("#loading-overlay");

                // Show the loading spinner
                loadingOverlay.show();

                $.ajax({
                    url: "{{ route('payrolls.store') }}", // Your Laravel store route
                    type: "POST",
                    data: formData,
                    success: function(response) {
                        loadingOverlay.hide(); // Hide loading spinner

                        if (response.success) {
                            // Show success message dynamically
                            successContainer.html('<div class="alert alert-success">' + response
                                .message + '</div>').fadeIn();

                            $('#successModal').removeClass('hidden'); // Show success modal
                            $('#payrollModal').addClass('hidden');
                            $('form')[0].reset(); // Reset form
                            $('#deleteModal').addClass('hidden'); // Close modal

                            // Reload DataTable
                            employedTable.ajax.reload(null, false);

                            // Hide success message after 5 seconds
                            setTimeout(function() {
                                successContainer.fadeOut();
                            }, 5000);
                        } else {
                            // Show error message if payroll already exists
                            errorContainer.html('<div class="alert alert-warning">' + response
                                .message + '</div>').fadeIn();
                        }
                    },
                    error: function(xhr) {
                        loadingOverlay.hide(); // Hide loading spinner

                        var errorMessage =
                            "Error occurred! Please check the form and try again.";

                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }

                        // Show error message dynamically
                        errorContainer.html('<div class="alert alert-danger">' + errorMessage +
                            '</div>').fadeIn();
                    }
                });
            });


        });
    </script>





@endsection
