@extends('layouts.sidebar')
@section('title', 'Payroll')
@section('content')
    @if (in_array('Payroll Checking', $privileges))


        <div class="py-5 text-left">
            <h1 class="font-bold ">DAVAO MANPOWER, INC. </h1>
            <p class="font-bold ">
                Payroll Deduction
            </p>
            {{-- <p class="font-bold ">
                {{ $data->client->business_name }} {{ $batch_id }}
            </p> --}}
            <p class="font-bold ">Period Cover: {{ \Carbon\Carbon::parse($data->pay_period_start)->format('F j, Y') }}
                to
                {{ \Carbon\Carbon::parse($data->pay_period_end)->format('F j, Y') }}</p>

            <p class="text-xs">
                client({{ $data->client->business_name }}) Payroll Batch: {{ $batch_id }}
            </p>
        </div>

        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif

        <div class="overflow-auto ">
            <table id="payrollsDataTable"
                class="min-w-full bg-white border border-collapse border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal uppercase ">
                        <th>Employee Name</th>
                        <th>Capital</th>
                        <th>Loans</th>
                        <th>CLoans</th>
                        <th>Mortuary</th>
                        <th class="bg-[#00b050] text-red-700">Total Deduction</th>

                        <th>Action</th>

                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                </tbody>
                <tfoot>
                    <tr>
                        <th>Grand Total</th>
                        <th></th> <!-- Placeholder for Capital total -->
                        <th></th> <!-- Placeholder for Loans total -->
                        <th></th> <!-- Placeholder for CLoans total -->
                        <th></th> <!-- Placeholder for Mortuary total -->
                        <th></th> <!-- Placeholder for Total Deduction -->
                        <th></th> <!-- Empty cell for Action column -->
                    </tr>
                </tfoot>
            </table>
        </div>
        <style>
            table.dataTable thead th {
                border-bottom: 2px solid #d1d5db;
                border-left: 1px solid #d1d5db;
                /* Left side border */
                border-right: 1px solid #d1d5db;
                /* Right side border */
                font-size: 12px;
                /* Text size for header cells */
                font-weight: bold;
                /* Optional for bold headers */
            }

            /* Optional: Remove the border for the first header cell to prevent double borders */
            table.dataTable thead th:first-of-type {
                border-left: none;
            }

            table.dataTable td {
                border-bottom: 2px solid #d1d5db;
                border-left: 1px solid #d1d5db;
                /* Left side border */
                border-right: 1px solid #d1d5db;
                /* Right side border */
                font-size: 12px;
                /* Text size for header cells */
                font-weight: bold;
                /* Text size for body cells */
            }
        </style>

        <form id="payrollForm" method="POST" action="{{ route('update.batch.status') }}">
            @csrf
            <div class="hidden mb-4">
                <label for="id" class="block text-sm font-medium text-gray-700">Batch ID:</label>
                <input type="text" name="id" id="id"
                    class="block w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                    required value="{{ $batch_id }}">
            </div>


        </form>

        <!-- Confirmation Modal -->
        <div id="confirmationModal"
            class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50">
            <div class="w-auto p-6 mt-10 bg-white rounded-lg shadow-lg">
                <h2 class="mb-4 text-lg font-bold">Confirm Action</h2>
                <p class="mb-6 text-gray-700">Are you sure you want to save this as the final payroll?</p>
                <div class="flex justify-end gap-4">
                    <button onclick="closeConfirmationModal()"
                        class="px-4 py-2 text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 focus:outline-none">
                        Cancel
                    </button>
                    <button onclick="submitPayrollForm1()"
                        class="px-4 py-2 text-white bg-blue-600 rounded-md hover:bg-blue-700 focus:outline-none">
                        Confirm
                    </button>
                </div>
            </div>
        </div>

        <script>
            // Open the confirmation modal
            function openConfirmationModal() {
                document.getElementById('confirmationModal').classList.remove('hidden');
            }

            // Close the confirmation modal
            function closeConfirmationModal() {
                document.getElementById('confirmationModal').classList.add('hidden');
            }

            // Submit the form upon confirmation
            function submitPayrollForm1() {
                document.getElementById('payrollForm').submit();
            }
        </script>
        @include('Admin.Payroll.deduction.modal')
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif
@endsection
