<div class="relative w-full ">
    <div id="subscribe-form-modal"
        class="pd-overlay  hidden w-full h-full fixed top-0 left-0 z-[100]  overflow-x-hidden overflow-y-auto bg-black bg-opacity-80">
        <div
            class="w-full m-5 transition-all ease-out opacity-0 md:w-1/2 sm:mx-auto modal-open:opacity-100 modal-open:duration-500">
            <div class="flex flex-col px-5 py-4 bg-white rounded-2xl">
                <div class="flex items-center justify-between pb-4 border-b border-gray-200">
                    <h4 class="text-sm font-medium text-gray-900">Create Payroll</h4>
                    <button class="block cursor-pointer close-modal-button" data-pd-overlay="#subscribe-form-modal"
                        data-modal-target="subscribe-form-modal">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.75732 7.75739L16.2426 16.2427M16.2426 7.75739L7.75732 16.2427" stroke="black"
                                stroke-width="1.6" stroke-linecap="round" />
                        </svg>
                    </button>
                </div>
                <div class="w-full p-8 mx-auto mb-10 bg-white border border-gray-200 rounded-lg shadow-md">
                    <form action="{{ route('payrolls.store') }}" method="POST">
                        @csrf
                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">

                            <div class="mb-2">
                                <label for="client_selection" class="block text-sm font-medium text-gray-700">Apply
                                    Payroll To</label>
                                <select name="client_selection" id="client_selection" required
                                    class="block w-full h-8 mt-1 border-2 border-black rounded-md shadow-sm"
                                    onchange="toggleClientDropdown()">
                                    <option value="">Select Option</option>
                                    <option value="all">All Clients</option>
                                    <option value="specific">Specific Client</option>
                                    <option value="department">Per Department</option> <!-- Added this option -->
                                </select>

                            </div>
                            <div class="mb-2" id="department_div" style="display: none;">
                                <label for="department_id" class="block text-sm font-medium text-gray-700">Select
                                    Department</label>
                                <select name="department_id" id="department_id"
                                    class="block w-full h-8 mt-1 border-2 border-black rounded-md shadow-sm">
                                    <option value="">Select a Department</option>
                                    @foreach ($departments as $department)
                                        <option value="{{ $department->id }}">{{ $department->department_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="mb-2" id="specific_client_div" style="display: none;">
                                <label for="client_id" class="block text-sm font-medium text-gray-700">Select
                                    Client</label>
                                <select name="client_id" id="client_id"
                                    class="block w-full h-8 mt-1 border-2 border-black rounded-md shadow-sm">
                                    <option value="">Select a Client</option>
                                    @foreach ($clients as $client)
                                        <option value="{{ $client->id }}">{{ $client->business_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-span-2 ">
                                <label for="pay_period_start" class="block mb-1 text-sm font-medium text-gray-700">Pay
                                    Scope of Payroll</label>
                                <div class="grid grid-cols-1 gap-10 md:grid-cols-2">
                                    <div class="mb-2 ">
                                        <input type="date" name="pay_period_start" id="pay_period_start" required
                                            class="block w-full h-8 px-4 py-2 text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent"
                                            placeholder="Select start date">
                                    </div>
                                    <div class="mb-2 ">
                                        <input type="date" name="pay_period_end" id="pay_period_end" required
                                            class="block w-full h-8 px-4 py-2 text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent"
                                            placeholder="Select end date">
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-2 ">
                                <label for="" class="block mb-1 text-sm font-medium text-gray-700">Scope
                                    of Contribution</label>
                                <div class="grid grid-cols-1 gap-10 md:grid-cols-2">
                                    <div class="mb-2 ">

                                        <input type="date" name="" id=""
                                            class="block w-full h-8 px-4 py-2 text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent"
                                            placeholder="Select start date">
                                    </div>
                                    <div class="mb-2 ">

                                        <input type="date" name="" id=""
                                            class="block w-full h-8 px-4 py-2 text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent"
                                            placeholder="Select end date">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <p id="error_message" style="color: red; display: none;">Please select at least one option (1st
                            Half or 2nd Half).</p>
                        <div class="p-5">
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="first" value="1"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="first_checkbox" />
                                <label for="first_checkbox" class="ml-3 text-sm text-gray-700">Include 1st Half
                                    Contributions and/or Deductions</label>
                            </div>
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="second" value="2"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="second_checkbox" />
                                <label for="second_checkbox" class="ml-3 text-sm text-gray-700">Include 2nd Half
                                    Contributions and/or Deductions</label>
                            </div>
                        </div>
                        <div class="flex justify-center ">
                            <button type="submit" id="submit_button"
                                class="px-4 py-2 mt-4 text-white bg-green-600 rounded-md">Create
                                Payroll</button>
                        </div>
                    </form>
                    <script>
                        document.getElementById('submit_button').addEventListener('click', function(event) {
                            var firstChecked = document.getElementById('first_checkbox').checked;
                            var secondChecked = document.getElementById('second_checkbox').checked;
                            var errorMessage = document.getElementById('error_message');
                            if (!firstChecked && !secondChecked) {
                                event.preventDefault();
                                errorMessage.style.display = 'block';
                            } else {
                                errorMessage.style.display = 'none';
                            }
                        });
                    </script>
                    @include('Admin.Payroll.check.js')
                </div>
            </div>
        </div>
    </div>
</div>
<div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-60">
    <div class="max-w-md mx-auto mt-20 overflow-hidden bg-white rounded-lg shadow-md">
        <!-- Modal Header -->
        <div class="flex items-center justify-between p-4 bg-gray-700 rounded-t-lg">
            <h5 class="text-lg font-semibold text-white">Confirm Deletion</h5>
            <button onclick="closeModal('deleteModal')" class="text-xl font-semibold text-white">&times;</button>
        </div>

        <!-- Modal Body -->
        <div class="px-6 py-4">
            <p class="text-sm text-gray-700">Are you sure you want to permanently delete this payroll batch? This
                action cannot be undone.</p>
        </div>

        <!-- Modal Footer -->
        <div class="flex justify-end px-6 py-4 space-x-4 rounded-b-lg bg-gray-50">
            <!-- Cancel Button -->
            <button onclick="closeModal('deleteModal')"
                class="px-4 py-2 text-sm text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 focus:outline-none">
                Cancel
            </button>

            <!-- Delete Button -->
            <form id="deleteForm" action="" method="POST" class="inline">
                @csrf
                @method('DELETE')
                <button type="submit"
                    class="px-4 py-2 text-sm text-white bg-red-500 rounded-md hover:bg-red-600 focus:outline-none">
                    Delete
                </button>
            </form>
        </div>
    </div>
</div>



<script>
    function openDeleteModal(paymentId, actionUrl) {
        // Set the action URL in the delete form
        document.getElementById('deleteForm').action = actionUrl;

        // Show the modal
        document.getElementById('deleteModal').classList.remove('hidden');
    }

    function closeModal(modalId) {
        document.getElementById(modalId).classList.add('hidden');
    }
</script>
