@extends('layouts.sidebar')
@section('title', 'Payroll')
@section('content')
    <div class="grid grid-cols-1 gap-5 lg:grid-cols-5">
        <div class="flex flex-col col-span-2 gap-5 md:flex-row">
            <div class="p-6 bg-gray-100 rounded-lg shadow ">

                {{-- <h1 class="mb-4 text-2xl font-bold">Create Group Code</h1>
                <form action="{{ route('trx_groupcodes.store') }}" method="POST" class="">
                    @csrf
                    <div class="mb-4">
                        <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                        <input type="text" name="description" id="description"
                            class="block w-full p-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                            required>
                    </div>
                    <div class="flex justify-end">
                        <button type="submit"
                            class="px-4 py-2 font-bold text-white bg-blue-500 rounded hover:bg-blue-600">Save</button>
                    </div>
                </form>
                <br><br> --}}

                <h2 class="mb-4 font-semibold">Select Options</h2>


                <form action="{{ route('trx_codes.store') }}" method="POST" class="grid grid-cols-1 gap-2 md:grid-cols-2 ">
                    @csrf

                    <div>
                        <div class="mb-4">
                            <label for="group_code_id" class="block text-sm font-medium text-gray-700">Group Code</label>
                            <select name="group_code_id" id="group_code_id"
                                class="block w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                <option value="" disabled selected>Select a Group Code</option>
                                @foreach ($groupcodes as $groupcode)
                                    <option value="{{ $groupcode->id }}">{{ $groupcode->description }}</option>
                                @endforeach
                            </select>
                            @error('group_code_id')
                                <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Description -->
                        <div class="mb-4">
                            <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                            <input type="text" name="description" id="description"
                                class="block w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            @error('description')
                                <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Abbreviation -->
                        <div class="mb-4">
                            <label for="abbreviation" class="block text-sm font-medium text-gray-700">Abbreviation</label>
                            <input type="text" name="abbreviation" id="abbreviation"
                                class="block w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            @error('abbreviation')
                                <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Percentage -->
                        <div class="mb-4">
                            <label for="percentage" class="block text-sm font-medium text-gray-700">Percentage</label>
                            <input type="text" name="percentage" id="percentage"
                                class="block w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            @error('percentage')
                                <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Entry Order -->
                        <div class="mb-4">
                            <label for="entry_order" class="block text-sm font-medium text-gray-700">Entry Order</label>
                            <input type="text" name="entry_order" id="entry_order"
                                class="block w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            @error('entry_order')
                                <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Sub Category -->
                        <div class="mb-4">
                            <label for="sub_category" class="block text-sm font-medium text-gray-700">Sub Category</label>
                            <input type="text" name="sub_category" id="sub_category"
                                class="block w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                            @error('sub_category')
                                <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    <div>
                        <div class="mb-4">

                            @foreach ($options as $op)
                                <div class="flex items-center mb-3">
                                    <input type="checkbox" name="option_ids[]" value="{{ $op->id }}"
                                        class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2" />
                                    <label for="option_ids[]"
                                        class="ml-3 text-sm text-gray-700">{{ $op->name }}</label>
                                </div>
                            @endforeach
                            @error('option_ids')
                                <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="flex justify-end">
                        <button type="submit"
                            class="px-4 py-2 font-bold text-white bg-blue-500 rounded hover:bg-blue-600">Save</button>
                    </div>
                </form>
            </div>
            <div>
                {{-- <form action="{{ route('trx_options.updateStatus') }}" method="POST" class="">
                    @csrf
                    @method('POST') <!-- Ensure method matches your route -->

                    <div class="mb-4">
                        <p class="block my-10 text-sm font-medium text-gray-700">Options</p>
                        @foreach ($options as $op)
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="option_ids[]" value="{{ $op->id }}"
                                    {{ $op->status ? 'checked' : '' }}
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2" />
                                <label for="option_ids[]" class="ml-3 text-sm text-gray-700">{{ $op->name }}</label>
                            </div>
                        @endforeach
                        @error('option_ids')
                            <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="flex justify-end">
                        <button type="submit"
                            class="px-4 py-2 font-bold text-white bg-blue-500 rounded hover:bg-blue-600">Update</button>
                    </div>
                </form> --}}

            </div>

        </div>
        <div class="col-span-3">
            <div>
                <h1 class="mb-4 text-2xl font-bold">Group Codes</h1>

                <table id="groupCodesTable" class="w-full text-center table-auto">
                    <thead>
                        <tr>
                            <th class="px-4 py-2">ID</th>
                            <th class="px-4 py-2">Description</th>
                            <th class="px-4 py-2">Actions</th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
            <div>
                <h1 class="mb-4 text-2xl font-bold"> Codes</h1>

                <table id="CodesTable" class="w-full text-center table-auto">
                    <thead>
                        <tr>
                            <th class="px-4 py-2">Description</th>
                            <th class="px-4 py-2">abbreviation</th>
                            <th class="px-4 py-2">percentage</th>
                            <th class="px-4 py-2">entry_order</th>
                            <th class="px-4 py-2">sub_category</th>
                            <th class="px-4 py-2">Actions</th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>

        </div>
    </div>
    <script>
        $(document).ready(function() {
            var employedTable = $('#CodesTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('trx_codes.index') }}",
                    data: function(d) {

                    }
                },
                columns: [{
                        data: 'description',
                        name: 'description'
                    },
                    {
                        data: 'abbreviation',
                        name: 'abbreviation'
                    },
                    {
                        data: 'percentage',
                        name: 'percentage'
                    },
                    {
                        data: 'entry_order',
                        name: 'entry_order'
                    },
                    {
                        data: 'sub_category',
                        name: 'sub_category'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            var employedTable = $('#groupCodesTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('trx_groupcodes.index') }}",
                    data: function(d) {

                    }
                },
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'description',
                        name: 'description'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });
        });
    </script>
    <script>
        const modal = document.getElementById('imageModal');
        const closeModalButton = document.getElementById('closeModal');

        closeModalButton.addEventListener('click', () => {
            modal.classList.add('hidden');
        });

        window.addEventListener('click', (event) => {
            if (event.target === modal) {
                modal.classList.add('hidden');
            }
        });
    </script>
    @include('Admin.Payroll.TRX.modal')
@endsection
