<div id="requestModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-60">
    <div class="bg-white rounded-xl h-[60rem] overflow-auto shadow-2xl w-auto  p-6 mx-4 relative animate-fadeIn">
        <!-- Header -->
        <div class="flex justify-between items-center border-b pb-4 mb-6">
            <h2 class="text-lg font-semibold text-gray-800">New Overtime / Undertime Request</h2>
            <button type="button" onclick="closeModal('requestModal')" aria-label="Close"
                class="text-gray-500 hover:text-red-600">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-10">
            <div>
                <div class="col-span-4 p-2 mt-2 border-2 border-black rounded-md">
                    <p class="pb-5">Employee List</p>
                    <table id="employed-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                        <thead>
                            <tr class="text-sm leading-normal text-white bg-[#1d1d1d]">
                                <th class="px-6 py-1">Assign ID</th>
                                <th class="px-6 py-1">Agency</th>
                                <th class="px-6 py-1">Company</th>
                                <th class="px-6 py-1">Client</th>
                                <th class="px-6 py-1">Name</th>
                                <th class="px-6 py-1">Status</th>
                            </tr>
                        </thead>
                        <tbody class="text-sm font-light text-center text-gray-600">
                        </tbody>
                    </table>
                </div>

                <!-- Table Row Click Script & Styling -->
                <style>
                    .clickable-row {
                        cursor: pointer;
                    }

                    .clickable-row:hover {
                        background-color: #f0f0f0;
                    }

                    .selected-row {
                        background-color: #e2e8f0 !important;
                        /* light blue-gray */
                        border-left: 4px solid #1d4ed8;
                        /* blue border */
                    }
                </style>

                <script type="text/javascript">
                    $(document).ready(function() {
                        var employedTable = $('#employed-table').DataTable({
                            processing: true,
                            serverSide: true,
                            ajax: {
                                url: "{{ route('benefits.customeemployeelist') }}",
                                data: function(d) {
                                    d.status = '1';
                                    d.office_id = $('#office_id').val();
                                    d.store_id = $('#store_id').val();
                                    d.pwd_filter = $('#pwd_filter').val();
                                }
                            },
                            columns: [{
                                    data: 'employee_id',
                                    name: 'employee_id',
                                    width: '8%'
                                },
                                {
                                    data: 'agency',
                                    name: 'agency',
                                    width: '12%'
                                },
                                {
                                    data: 'company',
                                    name: 'company',
                                    width: '12%'
                                },
                                {
                                    data: 'client',
                                    name: 'client',
                                    width: '12%'
                                },
                                {
                                    data: 'employee_name',
                                    name: 'employee_name',
                                    width: '20%'
                                },
                                {
                                    data: 'status',
                                    name: 'status',
                                    width: '10%'
                                },
                            ],
                            order: [
                                [0, 'desc']
                            ],
                            createdRow: function(row, data) {
                                $(row).addClass('clickable-row');
                                $(row).attr('data-employee-id', data
                                    .employee_id);
                                $(row).attr('data-department-id', data
                                    .department_id);
                            }
                        });


                        $('#employed-table tbody').on('click', '.clickable-row', function() {
                            $('#employed-table tbody tr').removeClass('selected-row');
                            $(this).addClass('selected-row');

                            var employeeId = $(this).data('employee-id');
                            var departmentId = $(this).data('department-id');

                            if (employeeId) {
                                $('input[name="employee_id"]').val(employeeId);
                            }
                            if (departmentId) {
                                $('input[name="department_id"]').val(departmentId);
                            }
                        });
                    });
                </script>

            </div>
            <div>
                <form id="request-form" class="bg-white border border-gray-200 rounded-xl p-6 shadow-sm space-y-6">
                    @csrf

                    <div id="form-errors"
                        class="hidden text-sm text-red-600 bg-red-50 border border-red-200 rounded-md p-3"></div>
                    <div>
                        <label for="type" class="block text-sm font-medium text-gray-700 mb-1">Request Type <span
                                class="text-red-500">*</span></label>
                        <select name="type" id="type" required
                            class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                            <option value="">Select Type</option>
                            <option value="overtime" {{ old('type') == 'overtime' ? 'selected' : '' }}>Overtime</option>
                            <option value="undertime" {{ old('type') == 'undertime' ? 'selected' : '' }}>Undertime
                            </option>
                        </select>
                        @error('type')
                            <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Section: Basic Info -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label for="employee_id" class="block text-sm font-medium text-gray-700 mb-1">Employee ID
                                <span class="text-red-500">*</span></label>
                            <input type="text" name="employee_id" id="employee_id" required readonly
                                value="{{ old('employee_id') }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                            @error('employee_id')
                                <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label for="department_id" class="block text-sm font-medium text-gray-700 mb-1">Department
                                <span class="text-red-500">*</span></label>
                            <input type="text" name="department_id" id="department_id" required readonly
                                value="{{ old('department_id') }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                            @error('department_id')
                                <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label for="position" class="block text-sm font-medium text-gray-700 mb-1">Position <span
                                    class="text-red-500">*</span></label>
                            <input type="text" name="position" id="position" required value="{{ old('position') }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                            @error('position')
                                <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <!-- Section: Date -->
                    <div>
                        <label for="request_date" class="block text-sm font-medium text-gray-700 mb-1">Request Date
                            <span class="text-red-500">*</span></label>
                        <input type="date" name="request_date" id="request_date" required
                            value="{{ old('request_date') }}"
                            class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        @error('request_date')
                            <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Section: Time Info -->
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div>
                            <label for="regular_start" class="block text-sm font-medium text-gray-700 mb-1">Regular
                                Start</label>
                            <input type="time" name="regular_start" id="regular_start"
                                value="{{ old('regular_start') }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        </div>
                        <div>
                            <label for="regular_end" class="block text-sm font-medium text-gray-700 mb-1">Regular
                                End</label>
                            <input type="time" name="regular_end" id="regular_end" value="{{ old('regular_end') }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        </div>
                        <div>
                            <label for="actual_start" class="block text-sm font-medium text-gray-700 mb-1">Actual
                                Start</label>
                            <input type="time" name="actual_start" id="actual_start"
                                value="{{ old('actual_start') }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        </div>
                        <div>
                            <label for="actual_end" class="block text-sm font-medium text-gray-700 mb-1">Actual
                                End</label>
                            <input type="time" name="actual_end" id="actual_end" value="{{ old('actual_end') }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        </div>
                    </div>

                    <!-- Section: Total Hours -->
                    <div>
                        <label for="total_hours" class="block text-sm font-medium text-gray-700 mb-1">Total Hours
                            <span class="text-red-500">*</span></label>
                        <input type="number" step="0.01" name="total_hours" id="total_hours" required
                            value="{{ old('total_hours') }}"
                            class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        @error('total_hours')
                            <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Section: Reason -->
                    <div>
                        <label for="reason" class="block text-sm font-medium text-gray-700 mb-1">Reason</label>
                        <textarea name="reason" id="reason" rows="3"
                            class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">{{ old('reason') }}</textarea>
                        @error('reason')
                            <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Submit -->
                    <div class="flex justify-end">
                        <button type="button" id="submit-btn"
                            class="px-6 py-2 bg-indigo-600 text-white text-sm font-medium rounded-md hover:bg-indigo-700 transition">
                            Submit Request
                        </button>
                    </div>
                </form>
            </div>
        </div>

    </div>
</div>

<div id="success-modal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p id="success-modal-message" class="mt-2 text-center text-gray-700"></p>

        <div class="mt-4 text-center">
            <button onclick="closeModal('success-modal')"
                class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>
<script>
    document.getElementById('submit-btn').addEventListener('click', function() {
        const errorContainer = document.getElementById('form-errors');
        errorContainer.classList.add('hidden');
        errorContainer.innerHTML = ''; // Clear previous errors

        let formData = new FormData(document.getElementById('request-form'));

        axios.post("{{ route('over_under_time_request.store') }}", formData)
            .then(response => {
                document.getElementById('success-modal-message').innerText = response.data.message;
                openModal('success-modal');
                closeModal('requestModal');
                $('#request_table').DataTable().ajax.reload(null, false);
                document.getElementById('request-form').reset();
            })
            .catch(error => {
                let messageHTML = '';

                if (error.response?.data?.errors) {
                    const errors = error.response.data.errors;
                    for (const key in errors) {
                        if (errors.hasOwnProperty(key)) {
                            messageHTML += `<p>• ${errors[key][0]}</p>`;
                        }
                    }
                } else if (error.response?.data?.message) {
                    messageHTML = `<p>• ${error.response.data.message}</p>`;
                } else {
                    messageHTML = `<p>• Something went wrong. Please try again.</p>`;
                }

                errorContainer.innerHTML = messageHTML;
                errorContainer.classList.remove('hidden');
            });
    });
</script>



<div id="confirm-modal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Confirm Deletion</h2>
        <p class="mt-2 text-center text-gray-700">Are you sure you want to delete this request?</p>

        <div class="mt-4 flex justify-center gap-3">

            <button onclick="closeModal('confirm-modal')"
                class="px-4 py-2 text-white bg-gray-500 rounded-lg hover:bg-gray-700">
                Cancel
            </button>
            <button id="confirm-delete" class="px-4 py-2 text-white bg-red-500 rounded-lg hover:bg-red-700">
                Delete
            </button>
        </div>
    </div>
</div>
<script>
    let deleteId = null;

    function openDeleteModal(id) {
        deleteId = id;
        openModal('confirm-modal');
    }

    document.getElementById('confirm-delete').addEventListener('click', function() {
        if (deleteId) {
            axios.delete("{{ route('over_under_time_request.destroy', '') }}/" + deleteId)
                .then(response => {
                    closeModal('confirm-modal');
                    document.getElementById('success-modal-message').innerText =
                        "Leave record deleted successfully!";
                    openModal('success-modal');
                    $('#request_table').DataTable().ajax.reload(null, false);
                })
                .catch(error => {
                    alert("Something went wrong. Please try again.");
                });
        }
    });
</script>








<script>
    function openModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    // Function to close a modal
    function closeModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>
