@extends('layouts.sidebar')
@section('title', 'Edit Overtime Request')
@section('content')

    @if (in_array('Manage Employee', $privileges))

        <div class="relative flex flex-col items-end justify-end mb-2 mr-10 text-center">

            <div>
                <button type="button"
                    class="inline-flex justify-center w-60 px-4 py-2 text-sm font-medium text-white bg-[#1d1d1d]  border border-gray-300 rounded-md shadow-sm hover:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-100 focus:ring-blue-500"
                    id="menu-button" aria-expanded="false" aria-haspopup="true" onclick="toggleDropdown()">
                    Menu
                    <svg class="w-5 h-5 ml-2 -mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"
                        aria-hidden="true">
                        <path fill-rule="evenodd"
                            d="M5.23 7.21a.75.75 0 011.06 0L10 10.44l3.71-3.23a.75.75 0 111.04 1.08l-4.25 3.5a.75.75 0 01-1.04 0l-4.25-3.5a.75.75 0 010-1.08z"
                            clip-rule="evenodd" />
                    </svg>
                </button>

                <div class="absolute right-0 z-10 hidden w-56 mt-2 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                    role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1"
                    id="dropdown-menu">
                    <div class="py-1" role="none">
                        <div class="flex flex-col items-center justify-center ">

                            <button id="showeditform"
                                class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                Edit
                            </button>
                            <button id="showView"
                                class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                View
                            </button>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="editformshow" class="hidden w-full p-4 lg:w-full">
            <div class="p-2 overflow-auto border-2 border-black rounded-md">
                <form id="request-form" class="bg-white border border-gray-200 rounded-xl p-6 shadow-sm space-y-6"
                    method="POST" action="{{ route('over_under_time_request.update', $request->id) }}">
                    @csrf
                    @method('PUT')

                    <!-- Errors -->
                    @if ($errors->any())
                        <div id="form-errors" class="text-sm text-red-600 bg-red-50 border border-red-200 rounded-md p-3">
                            @foreach ($errors->all() as $error)
                                <p>• {{ $error }}</p>
                            @endforeach
                        </div>
                    @endif

                    <!-- Request Type -->
                    <div>
                        <label for="type" class="block text-sm font-medium text-gray-700 mb-1">
                            Request Type <span class="text-red-500">*</span>
                        </label>
                        <select name="type" id="type" required
                            class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                            <option value="">Select Type</option>
                            <option value="overtime" {{ (old('type') ?? $request->type) == 'overtime' ? 'selected' : '' }}>
                                Overtime</option>
                            <option value="undertime"
                                {{ (old('type') ?? $request->type) == 'undertime' ? 'selected' : '' }}>
                                Undertime</option>
                        </select>
                        @error('type')
                            <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Basic Info -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label for="employee_id" class="block text-sm font-medium text-gray-700 mb-1">
                                Employee ID <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="employee_id" id="employee_id" required readonly
                                value="{{ old('employee_id') ?? $request->employee_id }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm">
                            @error('employee_id')
                                <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="department_id" class="block text-sm font-medium text-gray-700 mb-1">
                                Department <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="department_id" id="department_id" required readonly
                                value="{{ old('department_id') ?? $request->department_id }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm">
                            @error('department_id')
                                <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="position" class="block text-sm font-medium text-gray-700 mb-1">
                                Position <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="position" id="position" required
                                value="{{ old('position') ?? $request->position }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm">
                            @error('position')
                                <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <!-- Request Date -->
                    <div>
                        <label for="request_date" class="block text-sm font-medium text-gray-700 mb-1">
                            Request Date <span class="text-red-500">*</span>
                        </label>
                        <input type="date" name="request_date" id="request_date" required
                            value="{{ old('request_date') ?? $request->request_date }}"
                            class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm">
                        @error('request_date')
                            <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Time Info -->
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div>
                            <label for="regular_start" class="block text-sm font-medium text-gray-700 mb-1">Regular
                                Start</label>
                            <input type="time" name="regular_start" id="regular_start"
                                value="{{ old('regular_start') ?? $request->regular_start }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm">
                        </div>
                        <div>
                            <label for="regular_end" class="block text-sm font-medium text-gray-700 mb-1">Regular
                                End</label>
                            <input type="time" name="regular_end" id="regular_end"
                                value="{{ old('regular_end') ?? $request->regular_end }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm">
                        </div>
                        <div>
                            <label for="actual_start" class="block text-sm font-medium text-gray-700 mb-1">Actual
                                Start</label>
                            <input type="time" name="actual_start" id="actual_start"
                                value="{{ old('actual_start') ?? $request->actual_start }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm">
                        </div>
                        <div>
                            <label for="actual_end" class="block text-sm font-medium text-gray-700 mb-1">Actual
                                End</label>
                            <input type="time" name="actual_end" id="actual_end"
                                value="{{ old('actual_end') ?? $request->actual_end }}"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm">
                        </div>
                    </div>

                    <!-- Total Hours -->
                    <div>
                        <label for="total_hours" class="block text-sm font-medium text-gray-700 mb-1">
                            Total Hours <span class="text-red-500">*</span>
                        </label>
                        <input type="number" step="0.01" name="total_hours" id="total_hours" required
                            value="{{ old('total_hours') ?? $request->total_hours }}"
                            class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm">
                        @error('total_hours')
                            <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Reason -->
                    <div>
                        <label for="reason" class="block text-sm font-medium text-gray-700 mb-1">Reason</label>
                        <textarea name="reason" id="reason" rows="3"
                            class="w-full rounded-md border border-gray-300 px-3 py-2 shadow-sm">{{ old('reason') ?? $request->reason }}</textarea>
                        @error('reason')
                            <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Submit -->
                    <div class="flex justify-end">
                        <button type="submit"
                            class="px-6 py-2 bg-indigo-600 text-white text-sm font-medium rounded-md hover:bg-indigo-700 transition">
                            Update Request
                        </button>
                    </div>
                </form>

            </div>
        </div>


        <div id="viewshow" class="w-full md:p-4 lg:w-full">


            <div
                class="max-w-3xl mx-auto bg-white border border-gray-300 shadow-md rounded print:shadow-none print:border-none print:p-0 print:bg-white">

                <div class="mt-8 flex justify-end print:hidden px-4">
                    <a href="{{ route('over_under_time_request.index') }}"
                        class="mr-4 px-4 py-2 text-sm text-white bg-gray-700 rounded hover:bg-gray-800">Back</a>

                    <a href="{{ route('printRequest', ['id' => $request->id]) }}"
                        class="px-4 py-2 text-sm text-white bg-blue-600 rounded hover:bg-blue-700">
                        Download
                    </a>

                </div>
                <div class=" p-10">
                    <div class="text-center mb-8">
                        <h1 class="text-2xl font-bold uppercase tracking-wider">
                            {{ ucfirst($request->type) }} Request Form
                        </h1>
                        <p class="text-sm text-gray-600">Document ID: OT-{{ str_pad($request->id, 5, '0', STR_PAD_LEFT) }}
                        </p>
                    </div>

                    <div class="space-y-6 text-sm text-gray-900 leading-6">
                        <table class="w-full table-fixed border border-gray-400">
                            <tbody>
                                <tr class="border-b border-gray-400">
                                    <td class="p-2 font-semibold w-1/3 bg-gray-100">Employee Name:</td>
                                    <td class="p-2">
                                        @if ($request->employee)
                                            {{ $request->employee->last_name }},
                                            {{ $request->employee->first_name }}
                                            {{ $request->employee->middle_name ? strtoupper(substr($request->employee->middle_name, 0, 1)) . '.' : '' }}
                                        @else
                                            N/A
                                        @endif
                                    </td>

                                </tr>
                                <tr class="border-b border-gray-400">
                                    <td class="p-2 font-semibold bg-gray-100">Employee ID:</td>
                                    <td class="p-2">{{ $request->employee_id ?? 'N/A' }}</td>
                                </tr>
                                <tr class="border-b border-gray-400">
                                    <td class="p-2 font-semibold bg-gray-100">Department:</td>
                                    <td class="p-2">{{ $request->department->department_name ?? 'N/A' }}</td>
                                </tr>
                                <tr class="border-b border-gray-400">
                                    <td class="p-2 font-semibold bg-gray-100">Position:</td>
                                    <td class="p-2">{{ $request->position }}</td>
                                </tr>
                                <tr class="border-b border-gray-400">
                                    <td class="p-2 font-semibold bg-gray-100">Request Date:</td>
                                    <td class="p-2">
                                        {{ \Carbon\Carbon::parse($request->request_date)->format('F d, Y') }}
                                    </td>
                                </tr>
                                <tr class="border-b border-gray-400">
                                    <td class="p-2 font-semibold bg-gray-100">Regular Time:</td>
                                    <td class="p-2">
                                        {{ $request->regular_start ?? '--:--' }} to {{ $request->regular_end ?? '--:--' }}
                                    </td>
                                </tr>
                                <tr class="border-b border-gray-400">
                                    <td class="p-2 font-semibold bg-gray-100">Actual Time:</td>
                                    <td class="p-2">
                                        {{ $request->actual_start ?? '--:--' }} to {{ $request->actual_end ?? '--:--' }}
                                    </td>
                                </tr>
                                <tr class="border-b border-gray-400">
                                    <td class="p-2 font-semibold bg-gray-100">Total Hours:</td>
                                    <td class="p-2">{{ $request->total_hours }} hrs</td>
                                </tr>
                                <tr class="border-b border-gray-400">
                                    <td class="p-2 font-semibold bg-gray-100">Reason:</td>
                                    <td class="p-2">{{ $request->reason ?? 'N/A' }}</td>
                                </tr>
                                <tr class="border-b border-gray-400">
                                    <td class="p-2 font-semibold bg-gray-100">Status:</td>
                                    <td class="p-2">
                                        {{ $request->is_approved === 1 ? 'Approved' : ($request->is_approved === 0 ? 'Pending' : 'Rejected') }}
                                    </td>
                                </tr>
                                @if ($request->is_approved && $request->approver)
                                    <tr class="border-b border-gray-400">
                                        <td class="p-2 font-semibold bg-gray-100">Approved By:</td>
                                        <td class="p-2">{{ $request->approver->name }} on
                                            {{ \Carbon\Carbon::parse($request->approved_at)->format('F d, Y h:i A') }}</td>
                                    </tr>
                                @endif
                                @if ($request->payroll_notes)
                                    <tr>
                                        <td class="p-2 font-semibold bg-gray-100">Payroll Notes:</td>
                                        <td class="p-2">{{ $request->payroll_notes }}</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>

                        <div class="mt-10 grid grid-cols-2 gap-10 text-sm">
                            <div class="text-center">
                                <p class="mb-8 border-b border-gray-400 h-10"></p>
                                <p class="text-gray-700">Employee Signature</p>
                            </div>
                            <div class="text-center">
                                <p class="mb-8 border-b border-gray-400 h-10"></p>
                                <p class="text-gray-700">Approver Signature</p>
                            </div>
                        </div>

                        <div class="text-right mt-10 text-xs text-gray-500">
                            Printed on: {{ now()->format('F d, Y') }}
                        </div>
                    </div>

                    <div class="flex items-center justify-center gap-4">
                        @if ($request->is_approved == null)
                            <form action="{{ route('overtime-request.updateStatus', ['id' => $request->id]) }}"
                                method="POST" style="display:inline;">
                                @csrf
                                <input type="hidden" name="is_approved" value="1" />
                                <button type="submit"
                                    class="px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500">
                                    Approve
                                </button>
                            </form>

                            <form action="{{ route('overtime-request.updateStatus', ['id' => $request->id]) }}"
                                method="POST" style="display:inline;">
                                @csrf
                                <input type="hidden" name="is_approved" value="-1" />
                                <button type="submit"
                                    class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-500">
                                    Reject
                                </button>
                            </form>
                        @endif
                    </div>
                </div>


            </div>

        </div>




        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Buttons that trigger the sections
                const sections = {
                    showeditform: 'editformshow',
                    showView: 'viewshow'
                };

                // Function to show a section and hide others
                function showSection(sectionToShow) {
                    Object.values(sections).forEach(section => {
                        document.getElementById(section).classList.add('hidden');
                    });
                    document.getElementById(sectionToShow).classList.remove('hidden');
                }

                // Attach event listeners to buttons
                Object.keys(sections).forEach(buttonId => {
                    const button = document.getElementById(buttonId);
                    if (button) {
                        button.addEventListener('click', function() {
                            showSection(sections[buttonId]);
                        });
                    }
                });

                // Dropdown toggle
                const menuButton = document.getElementById('menu-button');
                const dropdownMenu = document.getElementById('dropdown-menu');

                if (menuButton && dropdownMenu) {
                    menuButton.addEventListener('click', function() {
                        dropdownMenu.classList.toggle('hidden');
                    });
                }
            });
        </script>


    @endif
@endsection
