@extends('layouts.sidebar')

@section('title', 'Payroll for checking')
@section('content')
    @if (in_array('Regions', $privileges) || in_array('wage management', $privileges))
        <div class="flex flex-col justify-between py-5 md:flex-row">
            <h1 class="mb-4 font-bold">Rate List</h1>

        </div>

        <div class="grid grid-cols-1 lg:grid-cols-5 gap-6 p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
            <!-- Minimum Wage Form -->
            <div class="lg:col-span-1 bg-white p-6 rounded-lg shadow border">
                <h2 class="text-lg font-bold mb-4 text-gray-700">Add Rate</h2>
                <form id="RegionForm">
                    <input type="hidden" id="region_id">

                    <div class="mb-4">
                        <label for="name" class="block text-sm font-semibold mb-1">Name</label>
                        <input type="text" id="name"
                            class="w-full p-2 border border-gray-300 rounded focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div class="mb-4">
                        <label for="rate" class="block text-sm font-semibold mb-1">Default Rate</label>
                        <input type="number" id="rate"
                            class="w-full p-2 border border-gray-300 rounded focus:ring-2 focus:ring-blue-500">
                    </div>

                    <button type="button" id="submitBtn" onclick="submitMinimumWage()"
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 rounded font-semibold">
                        Save
                    </button>
                    <button type="button" id="cancelBtn" onclick="resetForm()"
                        class="w-full mt-2 bg-gray-300 hidden hover:bg-gray-400 text-black py-2 rounded font-semibold">
                        Cancel
                    </button>
                </form>
            </div>

            <div class="lg:col-span-4 overflow-x-auto bg-white p-6 rounded-lg shadow border">
                <h2 class="text-lg font-bold mb-4 text-gray-700">Minimum Wage Table</h2>
                <table id="region"
                    class="min-w-full text-nowrap border border-gray-200 text-sm text-center text-gray-700">
                    <thead class="bg-gray-800 text-white ">
                        <tr>
                            <th class="px-6 py-3">Name</th>
                            <th class="px-6 py-3">Default Rate</th>
                            <th class="px-6 py-3">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 text-center">
                    </tbody>
                </table>
            </div>
        </div>
        <style>
            .clickable-row {
                cursor: pointer;
            }

            .clickable-row:hover {
                background-color: #f0f0f0;
            }

            .selected-row {
                background-color: #e2e8f0 !important;
                /* light blue-gray */
                border-left: 4px solid #1d4ed8;
                /* blue border */
            }
        </style>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif

    <script>
        $(document).ready(function() {
            var employedTable = $('#region').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('regiontable.get') }}",
                columns: [{
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'default_rate',
                        name: 'default_rate'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ],
                createdRow: function(row, data) {
                    $(row).attr('data-id', data.id);
                    $(row).attr('data-name', data.name);
                    $(row).attr('data-default_rate', data.default_rate);
                    $(row).addClass('clickable-row');
                }
            });

            // Handle row click to populate form
            $('#region tbody').on('click', 'tr.clickable-row', function() {
                var id = $(this).data('id');
                var name = $(this).data('name');
                var rate = $(this).data('default_rate');

                $('#region_id').val(id);
                $('#name').val(name);
                $('#rate').val(rate);

                // Update UI
                $('#submitBtn').text('Update');
                $('#cancelBtn').removeClass('hidden');
            });
        });

        function submitMinimumWage() {
            var id = $('#region_id').val();
            var url = id ? "{{ route('updaterate', ':id') }}" : "{{ route('storerate') }}";
            var method = id ? 'PUT' : 'POST';

            if (id) {
                url = url.replace(':id', id);
            }

            $.ajax({
                url: url,
                type: method,
                data: {
                    name: $('#name').val(),
                    default_rate: $('#rate').val(),
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    resetForm(); // Reset form and UI
                    $('#successModal').removeClass('hidden'); // Show success modal
                    $('#successModalMessage').text(response.message);
                    $('#region').DataTable().ajax.reload(); // Refresh table
                },
                error: function(xhr) {
                    alert('Something went wrong');
                }
            });
        }

        function resetForm() {
            $('#RegionForm')[0].reset();
            $('#region_id').val('');
            $('#submitBtn').text('Save');
            $('#cancelBtn').addClass('hidden');
            $('#region tbody tr').removeClass('selected-row');
        }
    </script>

    <div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
            <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
            <p>Are you sure you want to delete this record?</p>
            <form id="deleteForm">
                @csrf
                <input type="hidden" id="deleteRecordId" name="id">
                <div class="flex justify-end mt-6">
                    <button type="button" onclick="closeModal('deleteModal')"
                        class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
                </div>
            </form>
        </div>
    </div>
    <div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
        <div class="p-5 bg-white rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-bold text-center">Success</h2>
            <p id="successModalMessage" class="mt-2 text-center text-gray-700"></p>
            <div class="mt-4 text-center">
                <button onclick="closeModal('successModal')"
                    class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                    OK
                </button>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            // Open Delete Modal
            window.openDeleteModal = function(recordId) {
                $('#deleteRecordId').val(recordId);
                $('#deleteModal').removeClass('hidden');
            };

            // Submit Delete Form
            $('#deleteForm').on('submit', function(e) {
                e.preventDefault();
                let recordId = $('#deleteRecordId').val();
                let deleteUrl = "{{ route('deletedefaultrate', ':id') }}".replace(':id', recordId);

                $.ajax({
                    url: deleteUrl,
                    type: "DELETE",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#successModal').removeClass('hidden'); // Show success modal
                            $('#successModalMessage').text(response.message);
                            $('#deleteForm')[0].reset(); // Reset form
                            $('#deleteModal').addClass('hidden'); // Close modal
                            $('#region').DataTable().ajax.reload(null,
                                false); // Reload table without resetting pagination
                        }
                    },
                    error: function(xhr) {
                        alert('Error deleting record.');
                    }
                });
            });

            // Close Modal Function
            window.closeModal = function(modalId) {
                $('#' + modalId).addClass('hidden');
            };
        });
    </script>
@endsection
