@extends('layouts.sidebar')

@section('title', 'Payroll for checking')
@section('content')
    @if (in_array('Wage Assigning', $privileges) || in_array('wage management', $privileges))
        <div class="flex flex-col justify-between py-5 md:flex-row">
            <h1 class="mb-4 font-bold"> Wage Assignments</h1>

        </div>
        <div class="col-span-3 p-2 mt-2 border-2 p-6 bg-white rounded-md">
            <p class="pb-5">Employee List</p>
            <table id="employed-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal text-white bg-[#1d1d1d]">
                        <th class="px-6 py-1">Assign ID</th>
                        <th class="px-6 py-1">Agency</th>
                        <th class="px-6 py-1">Company</th>
                        <th class="px-6 py-1">Client</th>
                        <th class="px-6 py-1">Rate Name</th>
                        <th class="px-6 py-1">Default Rate</th>
                        <th class="px-6 py-1">Name</th>

                        <th class="px-6 py-1">Status</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                </tbody>
            </table>
        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif

    @include('Admin.Employee.wage.assignwagejs')
@endsection
