<div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p id="successMessage" class="mt-2 text-center text-gray-700"></p>
        <div class="mt-4 text-center">
            <button onclick="closeModal('successModal')"
                class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $('#shiftForm').on('submit', function(e) {
            e.preventDefault(); // Prevent default form submission

            var formData = $(this).serialize(); // Serialize form data
            var errorContainer = $("#error-container");
            var loadingOverlay = $("#loading-overlay");

            // Clear previous messages
            errorContainer.html("");
            loadingOverlay.removeClass("hidden"); // Show loading

            $.ajax({
                url: "{{ route('shifts.store') }}", // Ensure Laravel parses this route correctly
                type: "POST",
                data: formData,
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr(
                        "content") // CSRF protection
                },
                success: function(response) {
                    if (response.success) {
                        $('#successMessage').text(response.message);
                        $('#successModal').removeClass('hidden'); // Show success modal
                        $('#shiftForm')[0].reset(); // Reset form
                        $('#shiftTable').DataTable().ajax.reload(null,
                            false); // Reload DataTable if exists
                    }
                    loadingOverlay.addClass("hidden"); // Hide loading
                },
                error: function(xhr) {
                    loadingOverlay.addClass("hidden"); // Hide loading

                    if (xhr.status === 422) { // Laravel validation error
                        let errors = xhr.responseJSON.errors;
                        let errorMessages = Object.values(errors).map(err =>
                            `<p>${err[0]}</p>`).join("");
                        errorContainer.html(errorMessages);
                    } else {
                        alert('Error occurred! Please try again.');
                    }
                }

            });
        });

        // Close Success Modal
        $("#closeModal").on("click", function() {
            $("#successModal").addClass("hidden");
        });
    });
</script>







<div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
        <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
        <p>Are you sure you want to delete this record?</p>
        <form id="deleteForm">
            @csrf
            <input type="hidden" id="deleteRecordId" name="id">
            <div class="flex justify-end mt-6">
                <button type="button" onclick="closeModal('deleteModal')"
                    class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
            </div>
        </form>
    </div>
</div>



<script>
    $(document).ready(function() {
        // Open Delete Modal
        window.openDeleteModal = function(recordId) {
            $('#deleteRecordId').val(recordId);
            $('#deleteModal').removeClass('hidden');
        };

        // Submit Delete Form
        $('#deleteForm').on('submit', function(e) {
            e.preventDefault();
            let recordId = $('#deleteRecordId').val();
            let deleteUrl = "{{ route('shifts.destroy', ':id') }}".replace(':id', recordId);

            $.ajax({
                url: deleteUrl,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        $('#successMessage').text(response.message);
                        $('#successModal').removeClass('hidden'); // Show success modal
                        $('#deleteForm')[0].reset(); // Reset form
                        $('#deleteModal').addClass('hidden'); // Close modal
                        $('#shiftTable').DataTable().ajax.reload(null,
                            false); // Reload table without resetting pagination
                    }
                },
                error: function(xhr) {
                    alert('Error deleting record.');
                }
            });
        });

        // Close Modal Function
        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };

    });
</script>
