<div class="overflow-auto">
    <div class="flex items-center justify-end gap-2 mb-2">
        <input type="checkbox" id="useSchedule" name="useSchedule" class="w-5 h-5 text-blue-600 border-gray-300 rounded">
        <label for="useSchedule" class="font-medium text-gray-700">Check to use this schedule</label>
    </div>


    <div class="grid grid-cols-1 gap-4 md:grid-cols-4">
        <div>
            <form id="schedform" class="max-w-md p-6 mx-auto border-2 border-black rounded-lg">
                <h2 class="mb-4 font-semibold">Create Schedule</h2>
                <div id="loading-overlay" class="flex items-center justify-center hidden mt-4 mb-4">
                    <div
                        class="inline-block w-12 h-12 border-4 border-blue-600 rounded-full spinner-border animate-spin border-t-transparent">
                    </div>
                    <p class="ml-3 text-gray-700">Processing...</p>
                </div>
                <input type="hidden" name="employee_id" value="{{ $employee->id }}">
                <label class="block mt-4 mb-2 text-gray-700">Shift</label>
                <select name="shift_id" required
                    class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300">
                    <option value="">Select Shift</option>
                    </option>
                    @foreach ($shift as $shift)
                        <option value="{{ $shift->id }}">Time-in/out: {{ $shift->shift_start }} - {{ $shift->shift_end }} Break:  {{ $shift->break_out }} - {{ $shift->break_in }} </option>
                    @endforeach
                </select>


                <label class="block mt-4 mb-2 text-gray-700">Start Date</label>
                <input type="date" name="start_date" required
                    class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300" />

                <!-- Shift End -->
                <label class="block mt-4 mb-2 text-gray-700">End Date</label>
                <input type="date" name="end_date" required
                    class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300" />

                <button type="submit"
                    class="w-full py-2 mt-6 text-white transition bg-blue-500 rounded-lg hover:bg-blue-600">
                    Submit
                </button>

                <!-- Message Display -->
                <p id="message" class="mt-4 text-sm text-center"></p>

                <!-- Loading Overlay -->


                <!-- Error Container -->
                <div id="error-container" class="mt-4 text-sm text-red-500"></div>
            </form>

        </div>
        <div class="w-full col-span-3 p-6 mx-auto border-2 border-black rounded-lg">
            <div class="overflow-x-auto">
                <table id="schedTable" class="min-w-full border border-collapse border-gray-200 table-auto">
                    <thead class="bg-[#1d1d1d] text-white">
                        <tr>

                            <th class="px-4 py-2 border">Shift</th>
                            <th class="px-4 py-2 border">Break</th>
                            <th class="px-4 py-2 border">Start Date</th>
                            <th class="px-4 py-2 border">End Date</th>
                            <th class="px-4 py-2 border">Status</th>
                            </th>

                            <th class="px-4 py-2 border">Action</th>
                        </tr>
                    </thead>
                    <tbody class="text-center"></tbody>
                </table>
            </div>



        </div>

    </div>
    {{-- <!-- FullCalendar CSS -->
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.js"></script>

    <div id="calendar" style="max-width: 900px; margin: 40px auto;"></div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const calendarEl = document.getElementById('calendar');

            const calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                plugins: [FullCalendar.dayGridPlugin], // 👈 required!
                events: @json($events),
                eventDidMount: function(info) {
                    const shiftStart = info.event.extendedProps.shift_start;
                    const shiftEnd = info.event.extendedProps.shift_end;
                    info.el.title = `Shift Time: ${shiftStart} - ${shiftEnd}`;
                }
            });

            calendar.render();
        });
    </script> --}}
    <script>
        $(document).ready(function() {
            var employeeid = {{ $employee->id }};

            var departmentTable = $('#schedTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('employee_worksched', ['id' => ':id']) }}".replace(':id', employeeid),
                    data: function(d) {
                        d.employee_id = employeeid;
                    }
                },
                columns: [{
                        data: 'time',
                        name: 'time'
                    },
                    {
                        data: 'break',
                        name: 'break'
                    },
                    {
                        data: 'start_date',
                        name: 'start_date'
                    },
                    {
                        data: 'end_date',
                        name: 'end_date'
                    },
                    {
                        data: 'status123',
                        name: 'status123'
                    },

                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });
        });
    </script>

    <div id="successModalsched"
        class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
        <div class="p-5 bg-white rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-bold text-center">Success</h2>
            <p class="mt-2 text-center text-gray-700">Added successfully!</p>
            <div class="mt-4 text-center">
                <button onclick="closeModal('successModalsched')"
                    class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                    OK
                </button>
            </div>
        </div>
    </div>
    <div id="successModalupdated"
        class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
        <div class="p-5 bg-white rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-bold text-center">Success</h2>
            <p class="mt-2 text-center text-gray-700">updated successfully!</p>
            <div class="mt-4 text-center">
                <button onclick="closeModal('successModalupdated')"
                    class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                    OK
                </button>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('#schedform').on('submit', function(e) {
                e.preventDefault(); // Prevent default form submission

                var formData = $(this).serialize(); // Serialize form data
                var errorContainer = $("#error-container");
                var loadingOverlay = $("#loading-overlay");

                // Clear previous messages
                errorContainer.html("");
                loadingOverlay.removeClass("hidden"); // Show loading

                $.ajax({
                    url: "{{ route('work-schedule.store') }}", // Ensure Laravel parses this route correctly
                    type: "POST",
                    data: formData,
                    headers: {
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr(
                            "content") // CSRF protection
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#successModalsched').removeClass('hidden'); // Show success modal
                            $('#schedform')[0].reset(); // Reset form
                            $('#schedTable').DataTable().ajax.reload(null,
                                false); // Reload DataTable if exists
                        }
                        loadingOverlay.addClass("hidden"); // Hide loading
                    },
                    error: function(xhr) {
                        loadingOverlay.addClass("hidden"); // Hide loading

                        if (xhr.status === 422) { // Laravel validation error
                            let errors = xhr.responseJSON.errors;
                            let errorMessages = Object.values(errors).map(err =>
                                `<p>${err[0]}</p>`).join("");
                            errorContainer.html(errorMessages);
                        } else {
                            alert('Error occurred! Please try again.');
                        }
                    }




                });
            });

            // Close Success Modal
            $("#closeModal").on("click", function() {
                $("#successModalsched").addClass("hidden");
            });
        });
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", async function() {
            let checkbox = document.getElementById("useSchedule");

            try {
                // Fetch employee's current is_shift value
                let response = await fetch("{{ route('employee.getShiftStatus', ['id' => $employee->id]) }}");
                let data = await response.json();

                console.log("Fetched is_shift value:", data.is_shift); // Debugging line

                // Ensure value is properly converted to boolean
                checkbox.checked = data.is_shift == 1;

            } catch (error) {
                console.error("Error fetching shift status:", error);
            }

            // Handle checkbox change event
            checkbox.addEventListener("change", async function() {
                let isChecked = this.checked ? 1 : 0;

                try {
                    let updateResponse = await fetch("{{ route('employee.updateShiftStatus') }}", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json",
                            "X-CSRF-TOKEN": "{{ csrf_token() }}"
                        },
                        body: JSON.stringify({
                            employee_id: "{{ $employee->id }}",
                            is_shift: isChecked
                        })
                    });

                    let updateData = await updateResponse.json();
                    console.log("Update Response:", updateData); // Debugging line

                    $('#successModalupdated').removeClass('hidden');

                } catch (error) {
                    console.error("Error updating:", error);
                }
            });
        });
    </script>







    <div id="deleteschedModal"
        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
            <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
            <p>Are you sure you want to delete this record?</p>
            <form id="deleteschedForm">
                @csrf
                <input type="hidden" id="deleteRecordId" name="id">
                <div class="flex justify-end mt-6">
                    <button type="button" onclick="closeModal('deleteschedModal')"
                        class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
                </div>
            </form>
        </div>
    </div>



    <script>
        $(document).ready(function() {
            // Open Delete Modal
            window.openDeleteModalsched = function(recordId) {
                $('#deleteRecordId').val(recordId);
                $('#deleteschedModal').removeClass('hidden');
            };

            // Submit Delete Form
            $('#deleteschedForm').on('submit', function(e) {
                e.preventDefault();
                let recordId = $('#deleteRecordId').val();
                let deleteUrl = "{{ route('work-schedule.destroy', ':id') }}".replace(':id', recordId);

                $.ajax({
                    url: deleteUrl,
                    type: "DELETE",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#successModalsched').removeClass('hidden'); // Show success modal
                            $('#deleteschedForm')[0].reset(); // Reset form
                            $('#deleteschedModal').addClass('hidden'); // Close modal
                            $('#schedTable').DataTable().ajax.reload(null,
                                false); // Reload table without resetting pagination
                        }
                    },
                    error: function(xhr) {
                        alert('Error deleting record.');
                    }
                });
            });

            // Close Modal Function
            window.closeModal = function(modalId) {
                $('#' + modalId).addClass('hidden');
            };

        });
    </script>
</div>
