<div class="overflow-auto">



    <table id="constantloan-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
        <thead>
            <tr class="text-xs leading-normal text-nowrap ">

                <th>1st</th>
                <th>2nd</th>
                <th>DR</th>
                <th>Active</th>
                <th>TRX Name</th>
                <th>Employee</th>
                <th>Employer</th>
                <th>EC</th>
                <th>Applicable Months</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody class="font-light text-center text-gray-600 ">
        </tbody>
    </table>
</div>


<script>
    $(document).ready(function() {
        var employeeid = {{ $employee->id }};
        var departmentTable = $('#constantloan-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('employee_constantloans.index', ['id' => ':id']) }}".replace(':id',
                    employeeid),
                data: function(d) {
                    d.employee_id = employeeid;
                }
            },
            columns: [{
                    data: '1st',
                    name: '1st',
                    width: '10px'
                },
                {
                    data: '2st',
                    name: '2st',
                    width: '10px'
                },
                {
                    data: 'dr',
                    name: 'dr',
                    width: '10px'
                },
                {
                    data: 'status',
                    name: 'status',
                    width: '10px'
                },

                {
                    data: 'description_code',
                    name: 'description_code'
                },

                {
                    data: 'employee',
                    name: 'employee'
                },
                {
                    data: 'employer',
                    name: 'employer'
                },
                {
                    data: 'ec',
                    name: 'ec'
                },
                {
                    data: 'description',
                    name: 'description'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [0, 'desc']
            ],

            "createdRow": function(row, data, dataIndex) {

                $('td:eq(0)', row).html(data['1st'] == 1 ?
                    '<input type="checkbox" class="1st-checkbox" data-id="' + data.id +
                    '" checked />' : '<input type="checkbox" class="1st-checkbox" data-id="' +
                    data.id + '" />');
                $('td:eq(1)', row).html(data['2st'] == 1 ?
                    '<input type="checkbox" class="2st-checkbox" data-id="' + data.id +
                    '" checked />' : '<input type="checkbox" class="2st-checkbox" data-id="' +
                    data.id + '" />');
                $('td:eq(2)', row).html(data.dr == 1 ?
                    '<input type="checkbox" class="dr-checkbox" data-id="' + data.id +
                    '" checked />' :
                    '<input type="checkbox" class="dr-checkbox" data-id="' + data.id +
                    '" />');
                $('td:eq(3)', row).html(data.status == 1 ?
                    '<input type="checkbox" class="status-checkbox" data-id="' + data.id +
                    '" checked />' :
                    '<input type="checkbox" class="status-checkbox" data-id="' + data.id +
                    '" />');
            }
        });

        // Event listeners for checkbox changes
        $('body').on('change', '.status-checkbox', function() {
            var trxLoanId = $(this).data('id');
            var status = $(this).is(':checked') ? 1 : 0;
            updateCheckbox(trxLoanId, 'status', status);
        });

        $('body').on('change', '.1st-checkbox', function() {
            var trxLoanId = $(this).data('id');
            var status = $(this).is(':checked') ? 1 : 0;
            updateCheckbox(trxLoanId, '1st', status);
        });

        $('body').on('change', '.2st-checkbox', function() {
            var trxLoanId = $(this).data('id');
            var status = $(this).is(':checked') ? 1 : 0;
            updateCheckbox(trxLoanId, '2st', status);
        });
        $('body').on('change', '.dr-checkbox', function() {
            var trxLoanId = $(this).data('id');
            var status = $(this).is(':checked') ? 1 : 0;
            updateCheckbox(trxLoanId, 'dr', status);
        });


        function updateCheckbox(id, column, value) {
            $.ajax({
                url: "{{ route('trx-constantloans.update-checkbox', ':id') }}".replace(':id', id),
                method: 'POST',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'),
                    column: column,
                    value: value
                },
                success: function(response) {
                    if (response.success) {
                        openSuccessModal12('The checkbox has been updated successfully!');
                    } else {
                        console.log('Failed to update.');
                    }
                },
                error: function() {
                    console.log('An error occurred.');
                }
            });
        }
    });
</script>
<div id="openModal12" class="fixed inset-0 z-50 flex items-start justify-center z-[100] hidden bg-gray-900 bg-opacity-50">
    <div class="w-11/12 p-6 mt-20 bg-white rounded-lg shadow-lg md:w-1/2">
        <h2 class="mb-4 text-2xl font-bold">Add New Constant</h2>
        <!-- Modal Form -->
        <form id="trxLoanForm12" action="{{ route('trx_constants.store') }}" method="POST">
            @csrf
            <div class="grid grid-cols-1 gap-2 text-xs md:grid-cols-3">
                <div class="hidden mb-4 form-group">
                    <label for="employee_id" class="block font-medium text-gray-700">Employee ID</label>
                    <input type="number" name="employee_id"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" id="employee_id" required
                        value="{{ $employee->id }}">
                </div>
                <div class="mb-4 form-group">
                    <label for="group_code_id" class="block font-medium text-gray-700">Transaction Name</label>

                    <select name="group_code_id" id="trx_name"
                        class="w-full p-2 border border-gray-300 rounded-md form-control">
                        <option value="" disabled selected>Select a Transaction</option>
                        @foreach ($trx as $transaction)
                            <option value="{{ $transaction->id }}">{{ $transaction->description }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- 1st -->
                {{-- <div class="flex flex-col">
                    <label for="first" class="block text-sm font-medium text-gray-700">1st</label>
                    <input type="number" name="1st"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" id="first" required>
                </div>

                <!-- 2nd -->
                <div class="flex flex-col">
                    <label for="second" class="block text-sm font-medium text-gray-700">2nd</label>
                    <input type="number" name="2st"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" id="second" required>
                </div> --}}

                <!-- DR -->
                {{-- <div class="flex flex-col">
                    <label for="dr" class="block text-sm font-medium text-gray-700">DR</label>
                    <input type="number" name="dr"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" id="dr" required>
                </div> --}}

                <!-- Status -->
                {{-- <div class="flex flex-col">
                    <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                    <select name="status" id="status"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" required>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div> --}}

                <!-- Employee -->
                <div class="flex flex-col">
                    <label for="employee" class="block font-medium text-gray-700">Employee</label>
                    <input type="text" name="employee"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" id="employee" required>
                </div>

                <!-- Employer -->
                <div class="flex flex-col">
                    <label for="employer" class="block font-medium text-gray-700">Employer</label>
                    <input type="text" name="employer"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" id="employer" required>
                </div>

                <!-- EC -->
                <div class="flex flex-col">
                    <label for="ec" class="block font-medium text-gray-700">EC</label>
                    <input type="text" name="ec"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" id="ec" required>
                </div>
            </div>
            <!-- Description -->
            <div class="flex flex-col">
                <label for="description" class="block font-medium text-gray-700">Description</label>
                <textarea name="description" id="description" class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control"
                    rows="4" required></textarea>
            </div>


            <button type="submit"
                class="w-full px-4 py-2 mt-4 text-white bg-blue-500 rounded-md btn btn-primary">Save</button>
            <button type="button" onclick="closeModal('openModal12')"
                class="w-full px-4 py-2 mt-4 text-white bg-gray-500 rounded-md btn btn-secondary">Cancel</button>
        </form>
    </div>
</div>
<script>
    function openModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }


    function closeModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }


    $('#trxLoanForm12').submit(function(e) {
        e.preventDefault();

        var formData = new FormData(this);

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                // Close the modal
                closeModal('openModal');

                // Optionally, show a success message
                alert('TrxLoan Added Successfully!');

                // Refresh the DataTable to show the new record
                $('#constantloan-table').DataTable().ajax.reload();
            },
            error: function(xhr, status, error) {
                // Handle error (e.g., show an error message)
                alert('Error: ' + xhr.responseText);
            }
        });
    });
</script>
<script>
    $(document).ready(function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Delete button click handler
        $(document).on('click', '.delete-btn', function() {
            const deleteUrl = $(this).data('url');
            const loanId = $(this).data('id');

            // Open the modal
            $('#deleteModal12').removeClass('hidden');

            // Confirm delete
            $('#confirmDelete12').on('click', function() {
                $.ajax({
                    url: deleteUrl,
                    type: 'DELETE',
                    success: function(response) {
                        // Close the modal
                        $('#deleteModal12').addClass('hidden');

                        // Reload the DataTable (refreshes the table after deletion)
                        $('#constantloan-table').DataTable().ajax.reload();
                    },
                    error: function(xhr, status, error) {
                        alert('An error occurred while deleting the loan.');
                    }
                });
            });

            // Cancel delete action
            $('#cancelDelete12').on('click', function() {
                $('#deleteModal12').addClass('hidden');
            });
        });
    });
</script>

<div id="deleteModal12" class="fixed inset-0 flex items-start justify-center hidden bg-black bg-opacity-50 z-[100]">
    <div class="w-full max-w-md p-6 mt-20 transition-all transform scale-95 bg-white rounded-lg shadow-lg ">
        <h2 class="mb-6 text-lg font-semibold text-gray-700">Are you sure you want to delete this loan?</h2>
        <div class="flex justify-end space-x-4">
            <button id="cancelDelete12" class="px-4 py-2 text-white bg-gray-400 rounded-md">Cancel</button>
            <button id="confirmDelete12" class="px-4 py-2 text-white bg-red-600 rounded-md">Delete</button>
        </div>
    </div>
</div>

<!-- Success Modal -->
<div id="successModal12" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-500 bg-opacity-75">
    <div class="w-1/3 p-6 mt-20 bg-white rounded-lg shadow-lg">
        <h2 class="text-xl font-semibold text-green-600">Success</h2>
        <p id="successMessage" class="mt-4 text-gray-700">The operation was successful!</p>
        <div class="flex justify-end mt-4">
            <button onclick="closeSuccessModal12()"
                class="px-4 py-2 text-white bg-blue-600 rounded-md btn btn-primary">Close</button>
        </div>
    </div>
</div>
<script>
    // Function to open the success modal
    function openSuccessModal12(message) {
        // Set the success message dynamically
        document.getElementById("successMessage").innerText = message;

        // Show the modal by removing the 'hidden' class and adding 'flex' class
        document.getElementById("successModal12").classList.remove("hidden");
        document.getElementById("successModal12").classList.add("flex");
    }

    // Function to close the success modal
    function closeSuccessModal12() {
        document.getElementById("successModal12").classList.add("hidden");
        document.getElementById("successModal12").classList.remove("flex");
    }
</script>
