<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Leave Request Form</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            background-color: #fff;
            margin: 40px auto;
            color: #000;
            max-width: 800px;
            padding: 40px 60px;
            border: 1px solid #333;
            box-shadow: 0 0 8px rgba(0, 0, 0, 0.15);
        }

        header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }

        header img {
            max-height: 60px;
            margin-bottom: 10px;
        }

        header h1 {
            font-size: 24px;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin: 0;
            font-weight: bold;
        }

        header p {
            margin: 4px 0 0 0;
            font-size: 12px;
            font-style: italic;
        }

        section {
            margin-top: 20px;
        }

        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 16px;
        }

        .details-table td {
            padding: 10px 12px;
            vertical-align: top;
            border: 1px solid #555;
        }

        .details-table td.label {
            width: 30%;
            font-weight: bold;
            background-color: #f5f5f5;
            border-right: 2px solid #000;
        }

        .signature-section {
            margin-top: 60px;
            display: flex;
            justify-content: space-between;
        }

        .signature-box {
            width: 40%;
            text-align: center;
        }

        .signature-line {
            border-bottom: 2px solid #000;
            margin: 0 auto 8px auto;
            height: 30px;
            width: 100%;
            max-width: 250px;
        }

        .signature-label {
            font-weight: bold;
            letter-spacing: 1px;
        }

        .footer {
            margin-top: 50px;
            font-size: 12px;
            text-align: right;
            border-top: 1px solid #333;
            padding-top: 8px;
            color: #555;
            font-style: italic;
        }

        @media print {
            body {
                margin: 0;
                padding: 0;
                box-shadow: none;
                border: none;
                max-width: 100%;
            }

            .footer {
                page-break-after: avoid;
            }
        }
    </style>
</head>

<body>
    <header>
        {{-- Optional logo: uncomment & replace src --}}
        {{-- <img src="{{ asset('images/company-logo.png') }}" alt="Company Logo"> --}}
        <h1 class="title">Leave Request Form</h1>
        <p class="doc-id">Document ID: LV-{{ str_pad($leave->id, 5, '0', STR_PAD_LEFT) }}</p>

    </header>

    <section>
        <table class="info-table">
            <tbody>
                <tr>
                    <td class="label">Employee Name:</td>
                    <td>{{ $leave->employee->last_name }},
                        {{ $leave->employee->first_name }}{{ $leave->employee->middle_name ? ' ' . substr($leave->employee->middle_name, 0, 1) . '.' : '' }}
                    </td>
                </tr>
                <tr>
                    <td class="label">Employee ID:</td>
                    <td>{{ $leave->employee_id ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td class="label">Type of Leave:</td>
                    <td>{{ $leave->leave_type }}</td>
                </tr>
                <tr>
                    <td class="label">Start Date:</td>
                    <td>{{ \Carbon\Carbon::parse($leave->start_date)->format('F d, Y') }}</td>
                </tr>
                <tr>
                    <td class="label">End Date:</td>
                    <td>{{ \Carbon\Carbon::parse($leave->end_date)->format('F d, Y') }}</td>
                </tr>
                <tr>
                    <td class="label">Total Days:</td>
                    <td>{{ $leave->days }}</td>
                </tr>
                <tr>
                    <td class="label">Reason:</td>
                    <td>{{ $leave->reason }}</td>
                </tr>
                <tr>
                    <td class="label">Paid Leave:</td>
                    <td>{{ $leave->paid ? 'Yes' : 'No' }}</td>
                </tr>
                <tr>
                    <td class="label">Status:</td>
                    <td>
                        @if ($leave->is_approved === 1)
                            Approved
                        @elseif ($leave->is_approved === 0)
                            Pending
                        @else
                            Rejected
                        @endif
                    </td>
                </tr>
                @if ($leave->approved_at && $leave->approver)
                    <tr>
                        <td class="label">Approved By:</td>
                        <td>{{ $leave->approver->name }} on
                            {{ \Carbon\Carbon::parse($leave->approved_at)->format('F d, Y h:i A') }}</td>
                    </tr>
                @endif
            </tbody>
        </table>


    </section>

    <section class="signature-section">
        <div class="signature-box">
            <div class="signature-line"></div>
            <div class="signature-label">Employee Signature</div>
        </div>
        <div class="signature-box">
            <div class="signature-line"></div>
            <div class="signature-label">Approver Signature</div>
        </div>
    </section>

    <footer class="footer">
        Printed on: {{ now()->format('F d, Y') }}
    </footer>
</body>

</html>
