@extends('layouts.sidebar')
@section('title', 'leave')
@section('content')

    @if (in_array('Manage Employee', $privileges))
        @include('Admin.Employee.leave.modal')

        <div class="flex justify-between py-5 text-sm">
            <h1 class="mb-4 font-bold">Leave</h1>
            @if (in_array('leave form', $privileges))
                <button type="button"
                    class="modal-button py-2.5 px-5 h-10 text-xs bg-[#1d1d1d] text-white rounded-md cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700"
                    onclick="openModal('addLeaveModal')">
                    File Leave
                </button>
            @endif
        </div>

        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        <div class="overflow-auto bg-white p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
            <table id="agencyTable" class="min-w-full bg-white border border-collapse border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal text-white bg-[#1d1d1d]">
                        <th>Employee Name</th>
                        <th>Leave Type</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Days</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Reason</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                    <!-- DataTables will populate this body -->
                </tbody>
            </table>
        </div>

        <script>
            $(document).ready(function() {
                let table = $('#agencyTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "{{ route('leaves.index') }}",
                    columns: [{
                            data: 'employee',
                            name: 'employee'
                        },
                        {
                            data: 'leave_type',
                            name: 'leave_type'
                        },
                        {
                            data: 'start_date',
                            name: 'start_date'
                        },
                        {
                            data: 'end_date',
                            name: 'end_date'
                        },
                        {
                            data: 'days',
                            name: 'days'
                        },
                        {
                            data: 'paid',
                            name: 'paid'
                        },
                        {
                            data: 'status',
                            name: 'status',
                            render: function(data, type, row) {
                                let buttonClass =
                                    data == 1 ? 'bg-green-500 text-white' :
                                    data == 2 ? 'bg-gray-500 text-white' :

                                    'bg-gray-400 text-black';

                                let buttonText =

                                    data == 2 ? 'Leave Applied to Payroll' :
                                    data == 1 ? 'Approved' :
                                    'Approve';

                                return `<button class="approve-btn px-2 py-1 rounded ${buttonClass}" 
                        data-id="${row.id}" ${data == 1 || data == 2 ? 'disabled' : ''}>
                    ${buttonText}
                </button>`;
                            }
                        },
                        {
                            data: 'reason',
                            name: 'reason'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ]
                });

                // Handle Approve Button Click
                $(document).on('click', '.approve-btn', function() {
                    let leaveId = $(this).data('id');

                    $.ajax({
                        url: "{{ route('leaves.approve', ':id') }}".replace(':id',
                            leaveId), // Using named route
                        type: 'POST',
                        data: {
                            _token: "{{ csrf_token() }}"
                        },
                        success: function(response) {
                            table.ajax.reload(); // Reload DataTable after approval
                            alert('Leave Approved Successfully!');
                        },
                        error: function(xhr) {
                            alert('Error approving leave. Please try again.');
                        }
                    });
                });
            });
        </script>

    @endif
@endsection
