<div class="overflow-auto">
    <table id="payroll-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
        <thead>
            <tr class="text-sm leading-normal uppercase ">
                <th>ID</th>
                <th>Client Name</th>
                <th class="">Rate</th>
                <th class="">Earnings</th>
                <th class="">Deductions</th>
                <th class="">netpay</th>

            </tr>
        </thead>
        <tbody class="text-sm font-light text-center text-gray-600">
        </tbody>
        <tfoot class="text-sm">
            <tr>
                <th colspan="2" class="text-center">Total</th>
                <th class="text-center" id="totalRate">0</th>
                <th class="text-center" id="totalEarnings">0</th>
                <th class="text-center" id="totalDeductions">0</th>
                <th class="text-center" id="totalNetPay">0</th>

            </tr>
        </tfoot>
    </table>
</div>

<script>
    $(document).ready(function() {
        var employeeid = {{ $employee->id }};

        var departmentTable = $('#payroll-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('pay_roll.index', ['id' => ':id']) }}".replace(':id', employeeid),
                data: function(d) {
                    d.employee_id = employeeid;
                }
            },
            columns: [{
                    data: 'employee.id',
                    name: 'employee.id'
                },
                {
                    data: 'client.department_name',
                    name: 'client.department_name',

                },
                {
                    data: 'rate',
                    name: 'rate'
                },
                {
                    data: 'earnings',
                    name: 'earnings'
                },
                {
                    data: 'deduct',
                    name: 'deduct'
                },
                {
                    data: 'net_pay123',
                    name: 'net_pay123'
                }
            ],
            order: [
                [0, 'asc']
            ],
            rowCallback: function(row, data, index) {
                // Corrected to use departmentTable
                $(row).on('click', function() {
                    var tableRow = departmentTable.row(row); // Corrected table instance
                    var detailRow = departmentTable.row(row).child;

                    if (detailRow.isShown()) {
                        // If the row is already open, close it
                        tableRow.child.hide();
                        $(row).removeClass('shown');
                    } else {
                        // Open the child row with loan deductions and benefits details
                        var loanDeductionsHtml = data.loan_deductions;
                        var constantDeductionsHtml = data.constant_deduction;
                        var benefitsHtml = data.benefits;
                        var basic_salary = data.basic_salary;
                        var others = data.others;
                        var batch = data.batch;
                        var remarks = data.remarks;
                        // Format the child row HTML content
                        var childRowHtml = `
                            <div class="flex flex-col items-center justify-center">
                                <p >${batch}</p>
                                <div class="grid grid-cols-1 p-5 uppercase gap-60 md:grid-cols-3 lg:grid-cols-3">
                                    <div class="flex flex-col items-start">${basic_salary} ${loanDeductionsHtml}</div> 
                                    <div class="flex flex-col items-start">${constantDeductionsHtml} ${benefitsHtml} ${others}</div> 
                                    <div class="flex flex-col items-start"><div class="flex flex-col items-start max-w-xs  break-words">
        <span class="font-semibold">Remarks:</span> ${remarks}
    </div> </div> 
                                </div>
                            </div>`;

                        tableRow.child(childRowHtml).show();
                        $(row).addClass('shown');
                    }
                });
            },
            footerCallback: function(row, data, start, end, display) {
                var api = this.api();

                var totalRate = 0;
                var totalEarnings = 0;
                var totalDeductions = 0;
                var totalNetPay = 0;

                // Calculate totals for relevant columns
                api.column(2).data().each(function(value) {
                    totalRate += parseFloat(value) || 0;
                });

                api.column(3).data().each(function(value) {
                    totalEarnings += parseFloat(value) || 0;
                });

                api.column(4).data().each(function(value) {
                    totalDeductions += parseFloat(value) || 0;
                });

                api.column(5).data().each(function(value) {
                    totalNetPay += parseFloat(value) || 0;
                });

                // Update the footer row with calculated totals
                $(api.table().footer()).find('#totalRate').text(totalRate.toFixed(2));
                $(api.table().footer()).find('#totalEarnings').text(totalEarnings.toFixed(2));
                $(api.table().footer()).find('#totalDeductions').text(totalDeductions.toFixed(2));
                $(api.table().footer()).find('#totalNetPay').text(totalNetPay.toFixed(2));
            }
        });
    });
</script>
