<div class="w-full text-sm">


    @if (!is_null($employee1) && count($employee1) > 0)
        @foreach ($employee1 as $current)
            <div>
                <div class="grid grid-cols-1 gap-2 p-5 mt-10 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
                    <div class="p-2 ">
                        <label for="dateHired" class="w-1/3 mr-2">Date Hired:</label>
                        <input type="date" id="dateHired" name="date_hired"
                            class="w-full p-2 border border-black rounded-md" value="{{ $current->date_hired }}" />
                    </div>

                    <div class="p-2 ">
                        <label for="supervisor" class="w-1/3 mr-2">Supervisor:</label>
                        <input type="text" id="supervisor" name="supervisor" placeholder="Enter supervisor's name"
                            class="w-full p-2 border border-black rounded-md">
                    </div>
                    <div class="mt-2">

                        <div class="p-2 ">
                            <label for="bank_number" class="block mb-1 text-sm">Bank Name
                                :</label>
                            <input type="text" id="bank_number" name="bank_number" value="{{ $employee->bank_name }}"
                                placeholder="Enter your bank account number"
                                class="w-full p-2 border border-black rounded-md">
                        </div>
                    </div>
                    <div class="mt-2">

                        <div class="p-2 ">
                            <label for="bank_number" class="block mb-1 text-sm">Bank Account
                                Number:</label>
                            <input type="text" id="bank_number" name="bank_number"
                                value="{{ $employee->bank_number }}" placeholder="Enter your bank account number"
                                class="w-full p-2 border border-black rounded-md">
                        </div>
                    </div>

                    <div class="p-2">
                        <label for="company_name" class="block text-sm font-medium text-gray-700">Current Company
                            Name</label>
                        <input type="text" name="company_name" id="company_name"
                            class="w-full p-2 border border-black rounded-md"
                            value="{{ $current->department->client->business_name }}" />
                        @if ($errors->has('company_name'))
                            <span class="text-sm text-red-500">{{ $errors->first('company_name') }}</span>
                        @endif
                    </div>
                    <div class="p-2 ">
                        <label for="employment_start_date" class="block text-sm font-medium text-gray-700">Employment
                            Start
                            Date</label>
                        <input type="date" name="employment_start_date" id="employment_start_date"
                            class="w-full p-2 border border-black rounded-md"
                            value="{{ $current->employment_start_date }}" />
                        @if ($errors->has('employment_start_date'))
                            <span class="text-sm text-red-500">{{ $errors->first('employment_start_date') }}</span>
                        @endif
                    </div>

                    <div class="p-2 ">
                        <label for="employment_end" class="block text-sm font-medium text-gray-700">Employment
                            End
                            Date</label>
                        <input type="date" name="employment_end_date" id="employment_end_date"
                            class="w-full p-2 border border-black rounded-md"
                            value="{{ $current->employment_end_date }}" />
                        @if ($errors->has('employment_end_date'))
                            <span class="text-sm text-red-500">{{ $errors->first('employment_end_date') }}</span>
                        @endif
                    </div>

                    <div class="p-2 ">
                        <label for="position" class="block text-sm font-medium text-gray-700">Current Position</label>
                        <input type="text" name="position" id="position"
                            class="w-full p-2 border border-black rounded-md" value="{{ $current->position }}">
                        @if ($errors->has('position'))
                            <span class="text-sm text-red-500">{{ $errors->first('position') }}</span>
                        @endif
                    </div>
                </div>

            </div>
        @endforeach

    @endif



    <div class="grid grid-cols-1 gap-2 p-5 mt-10 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
        <div class="p-2 ">
            <label for="dtr_id" class="block mb-1">DTR ID:</label>
            <input type="text" name="dtr_id" id="dtr_id" class="w-full p-2 border border-black rounded-md"
                value="{{ $employee->dtr_id }}" />
            @error('dtr_id')
                <span class="text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
        <div class="p-2 ">
            <label for="position_applied" class="block mb-1">Position Applied For:</label>
            <input type="text" name="position_applied" id="position_applied"
                class="w-full p-2 border border-black rounded-md" value="{{ $employee->position_applied }}" />
            @error('position_applied')
                <span class="text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
        <div class="p-2 ">
            <label for="desired_working_area" class="block mb-1">Desired Working Area:</label>
            <input type="text" name="desired_working_area" id="desired_working_area"
                class="w-full p-2 border border-black rounded-md" value="{{ $employee->desired_working_area }}" />
            @error('desired_working_area')
                <span class="text-sm text-red-500">{{ $message }}</span>
            @enderror
        </div>
    </div>
    <div class="grid grid-cols-1 gap-2 p-5 my-10 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
        <div class="p-2 ">
            <label for="sss_no" class="block text-sm font-medium text-gray-700">SSS
                No.</label>
            <input type="text" name="sss_no" id="sss_no" class="w-full p-2 border border-black rounded-md"
                value="{{ $employee->sss_no }}" />
            @if ($errors->has('sss_no'))
                <span class="text-sm text-red-500">{{ $errors->first('sss_no') }}</span>
            @endif
        </div>

        <div class="p-2 ">
            <label for="tin_no" class="block text-sm font-medium text-gray-700">TIN
                No.</label>
            <input type="text" name="tin_no" id="tin_no" class="w-full p-2 border border-black rounded-md"
                value="{{ $employee->tin_no }}" />
            @if ($errors->has('tin_no'))
                <span class="text-sm text-red-500">{{ $errors->first('tin_no') }}</span>
            @endif
        </div>
        <div class="p-2 ">
            <label for="pagibig_no" class="block text-sm font-medium text-gray-700">Pag-IBIG
                No.</label>
            <input type="text" name="pagibig_no" id="pagibig_no"
                class="w-full p-2 border border-black rounded-md" value="{{ $employee->pagibig_no }}" />
            @if ($errors->has('pagibig_no'))
                <span class="text-sm text-red-500">{{ $errors->first('pagibig_no') }}</span>
            @endif
        </div>
        <div class="p-2 ">
            <label for="philhealth_no" class="block text-sm font-medium text-gray-700">Phil
                No.</label>
            <input type="text" name="philhealth_no" id="philhealth_no"
                class="w-full p-2 border border-black rounded-md" value="{{ $employee->philhealth_no }}" />
            @if ($errors->has('pagibig_no'))
                <span class="text-sm text-red-500">{{ $errors->first('philhealth_no') }}</span>
            @endif
        </div>
    </div>

</div>
