<div class="overflow-auto ">
    <table id="benefits-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
        <thead>
            <tr class="text-sm leading-normal  text-white uppercase bg-[#1d1d1d]">
                <th class="px-6 py-3">Agency</th>

                <th class="px-6 py-3">Company</th>
                <th class="px-6 py-3">Client</th>

                <th class="px-6 py-3">Type</th>
                <th class="px-6 py-3">Period</th>
                </th>
                <th class="px-6 py-3">Employee Share</th>
                <th class="px-6 py-3">Employer Share</th>

            </tr>
        </thead>
        <tbody class="text-sm font-light text-center text-gray-600">
        </tbody>
        <tfoot>
            <tr class="font-bold bg-gray-100">
                <th colspan="5" class="text-right px-6 py-3">Total:</th>
                <th class="px-6 py-3" id="total-employee-share"></th>
                <th class="px-6 py-3" id="total-employer-share"></th>
            </tr>
        </tfoot>
    </table>
</div>

<script>
    $(document).ready(function() {
        var employeeid = {{ $employee->id }};

        var departmentTable = $('#benefits-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('benefits.index', ['id' => ':id']) }}".replace(':id', employeeid),
                data: function(d) {
                    d.employee_id = employeeid;
                }
            },
            columns: [{
                    data: 'agency',
                    name: 'agency'
                },
                {
                    data: 'company',
                    name: 'company'
                },
                {
                    data: 'client',
                    name: 'client'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'batch_code',
                    name: 'batch_code'
                },
                {
                    data: 'employee_share',
                    name: 'employee_share'
                },
                {
                    data: 'employer_share',
                    name: 'employer_share'
                },
            ],
            order: [
                [0, 'desc']
            ],
            footerCallback: function(row, data, start, end, display) {
                var api = this.api();

                // Helper function to sum a column
                var sumColumn = function(index) {
                    return api
                        .column(index, {
                            page: 'current'
                        })
                        .data()
                        .reduce(function(a, b) {
                            return (parseFloat(a) || 0) + (parseFloat(b) || 0);
                        }, 0)
                        .toFixed(2);
                };

                // Calculate totals
                var totalEmployeeShare = sumColumn(5);
                var totalEmployerShare = sumColumn(6);

                // Update footer
                $(api.column(5).footer()).html('Total: ' + totalEmployeeShare);
                $(api.column(6).footer()).html('Total: ' + totalEmployerShare);
            }
        });
    });
</script>
