<div class="overflow-auto">
    <table id="attendance-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
        <thead>
            <tr class="text-sm leading-normal text-white  bg-[#1d1d1d]">

                <th>Date</th>
                <th>Time In</th>
                <th>Break Out</th>
                <th>Break In</th>
                <th>Time Out</th>
                <th>Notes</th>
                <th>status</th>

            </tr>
        </thead>
        <tbody class="text-sm font-light text-center text-gray-600">
            <!-- DataTables will populate this body -->
        </tbody>
    </table>
</div>


<script>
    $(document).ready(function() {
        var employeeid = {{ $employee->id }};

        var departmentTable = $('#attendance-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('em_attendance.index', ['id' => ':id']) }}".replace(':id', employeeid),
                data: function(d) {
                    d.employee_id = employeeid;
                }
            },
            columns: [{
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'time_in',
                    name: 'time_in'
                },
                {
                    data: 'break_out',
                    name: 'break_out'
                },
                {
                    data: 'break_in',
                    name: 'break_in'
                },
                {
                    data: 'time_out',
                    name: 'time_out'
                },
                {
                    data: 'notes',
                    name: 'notes'
                },
                {
                    data: 'approve',
                    name: 'approve'
                },

            ],
            order: [
                [0, 'desc']
            ]
        });



    });
</script>
