@extends('layouts.sidebar')

@section('title', 'Employee')
@section('content')

    <div class="mx-auto">
        <div class="flex flex-col justify-between px-2 md:flex-row">

            <div class="flex flex-col items-center gap-5 lg:flex-row">

                <div class="relative flex flex-col items-end justify-end mb-2 mr-10 text-center">

                    <div>
                        <button type="button"
                            class="inline-flex justify-center w-60 px-4 py-2 text-sm font-medium text-white bg-[#1d1d1d]  border border-gray-300 rounded-md shadow-sm hover:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-100 focus:ring-blue-500"
                            id="menu-button" aria-expanded="false" aria-haspopup="true" onclick="toggleDropdown()">
                            Menu
                            <svg class="w-5 h-5 ml-2 -mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                fill="currentColor" aria-hidden="true">
                                <path fill-rule="evenodd"
                                    d="M5.23 7.21a.75.75 0 011.06 0L10 10.44l3.71-3.23a.75.75 0 111.04 1.08l-4.25 3.5a.75.75 0 01-1.04 0l-4.25-3.5a.75.75 0 010-1.08z"
                                    clip-rule="evenodd" />
                            </svg>
                        </button>
                        @if (in_array('Employee UserInterface', $privileges))
                            <div class="absolute right-0 z-10 hidden w-56 mt-2 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                                role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1"
                                id="dropdown-menu">
                                <div class="py-1" role="none">
                                    <div class="flex flex-col items-center justify-center ">

                                        <button id="showpayroll"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Payroll
                                        </button>
                                        <button id="showbenefits"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Deductions
                                        </button>

                                        <button id="showemployeedetails"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Profile
                                        </button>
                                        <button id="showattendance"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Attendance
                                        </button>
                                        <button id="history"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Employment History
                                        </button>
                                        <button id="leave"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Leave
                                        </button>
                                        <p id="loans"></p>
                                        <p id="constant"></p>
                                        <p id="rate"></p>
                                        <p id="documentbutton"></p>
                                        @if (in_array('Employee Schedule', $privileges))
                                            <button id="schedule"
                                                class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                                Work Shedule
                                            </button>
                                        @endif
                                        <p id="customsetup"></p>

                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="absolute right-0 z-10 hidden w-56 mt-2 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                                role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1"
                                id="dropdown-menu">
                                <div class="py-1" role="none">
                                    <div class="flex flex-col items-center justify-center ">

                                        <button id="showpayroll"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Payroll
                                        </button>
                                        <button id="showbenefits"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Deductions
                                        </button>

                                        <button id="showemployeedetails"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Profile
                                        </button>
                                        <button id="showattendance"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Attendance
                                        </button>
                                        <button id="history"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Employment History
                                        </button>
                                        <button id="leave"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Leave
                                        </button>

                                        <button id="loans"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Loans
                                        </button>
                                        <button id="constant"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Constant
                                        </button>
                                        <button id="rate"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Rate
                                        </button>
                                        @if (in_array('Employee Schedule', $privileges))
                                            <button id="schedule"
                                                class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                                Work Shedule
                                            </button>
                                        @endif
                                        <button id="customsetup"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Benefits Custom Setup
                                        </button>
                                        <button id="documentbutton"
                                            class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                            Documents
                                        </button>

                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            <div>
                <p class="text-sm font-bold text-gray-800">Employee Name: {{ $employee->first_name }}
                    {{ $employee->last_name }}
                    {{ $employee->middle_name }}</p>
            </div>
        </div>

        <div class="hidden w-full p-4 lg:w-full" id="payrollshow">
            @if ($employee->status == '3')
                <p class="text-xl text-center">This employee is currently undergoing pre-employment processes</p>
            @else
                <h2 class="mb-6 text-sm font-bold">Payroll List</h2>
                @include('Admin.Employee.info.payrollhistory')
            @endif
        </div>
        <div class="hidden w-full p-4 lg:w-full" id="leaveshow">
            @if ($employee->status == '3')
                <p class="text-xl text-center">This employee is currently undergoing pre-employment processes</p>
            @else
                <div class="flex justify-between py-5">
                    <h2 class="mb-6 text-2xl font-bold">Leave</h2>
                    @if (in_array('leave form', $privileges))
                        <button type="button"
                            class="modal-button py-2.5 px-5 h-10 text-xs bg-[#1d1d1d] text-white rounded-md cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700"
                            onclick="openModal('addLeaveModal')">
                            File Leave
                        </button>
                    @endif
                </div>

                @include('Admin.Employee.info.employeeleave')
            @endif
        </div>



        <div class="hidden w-full p-4 lg:w-full" id="benefitsshow">
            @if ($employee->status == '3')
                <p class="text-xl text-center">This employee is currently undergoing pre-employment processes</p>
            @else
                <h2 class="mb-6 text-xl font-bold">Deduction List</h2>
                @include('Admin.Employee.info.benefits')
            @endif
        </div>



        <div id="attendanceshow" class="hidden w-full p-4 lg:w-full">
            @if ($employee->status == '3')
                <p class="text-xl text-center">This employee is currently undergoing pre-employment processes</p>
            @else
                <h2 class="mb-6 text-xl font-bold">Attendance List</h2>
                @include('Admin.Employee.info.attendance')
            @endif
        </div>


        <div id="loanshow" class="hidden w-full p-4 lg:w-full">
            @if ($employee->status == '3')
                <p class="text-xl text-center">This employee is currently undergoing pre-employment processes</p>
            @else
                <div class="flex justify-between p-2">
                    <div>
                        <h2 class="mb-6 text-xl font-bold">Loans</h2>
                    </div>

                    <div class="flex items-end justify-end my-2 mr-2"> <button onclick="openModal('openModal')"
                            class="btn border-2 rounded-md hover:scale-105 border-[#1d1d1d] text-sm btn-primary px-3 py-2 transition-all duration-200">Add
                            New
                        </button>
                    </div>
                </div>
                @include('Admin.Employee.loans.loans')
            @endif
        </div>


        <div id="othershow" class="hidden w-full p-4 lg:w-full">
            @if ($employee->status == '3')
                <p class="text-xl text-center">This employee is currently undergoing pre-employment processes</p>
            @else
                <div class="flex justify-between p-2">
                    <div>
                        <h2 class="mb-6 text-xl font-bold">Others</h2>
                    </div>

                    <div class="flex items-end justify-end my-2 mr-2"> <button onclick="openModal('openModal_others')"
                            class="btn border-2 rounded-md hover:scale-105 border-[#1d1d1d] text-sm btn-primary px-3 py-2 transition-all duration-200">Add
                            New
                        </button>
                    </div>
                </div>
                @include('Admin.Employee.loans.others')
            @endif
        </div>

        <div id="constantshow" class="hidden w-full p-4 lg:w-full">
            @if ($employee->status == '3')
                <p class="text-xl text-center">This employee is currently undergoing pre-employment processes</p>
            @else
                <div class="flex justify-between p-2">
                    <div>
                        <h2 class="mb-6 text-xl font-bold">Constant</h2>
                    </div>

                    <div class="flex items-end justify-end my-2 mr-2"> <button onclick="openModal('openModal12')"
                            class="btn border-2 rounded-md hover:scale-105 border-[#1d1d1d] text-sm btn-primary px-3 py-2 transition-all duration-200">Add
                            New
                        </button>
                    </div>
                </div>
                @include('Admin.Employee.loans.constantloan')
            @endif
        </div>


        <div id="rateshow" class="hidden w-full p-4 lg:w-full">
            @if ($employee->status == '3')
                <p class="text-xl text-center">This employee is currently undergoing pre-employment processes</p>
            @else
                <div class="flex justify-between p-2">
                    <div>
                        <h2 class="mb-6 text-xl font-bold">Rate</h2>
                    </div>

                    <div class="flex items-end justify-end my-2 mr-2"> <button onclick="openModal('openModal_rate')"
                            class="btn border-2 rounded-md hover:scale-105 border-[#1d1d1d] text-sm btn-primary px-3 py-2 transition-all duration-200">
                            Add New Rate
                        </button>
                    </div>
                </div>
                @include('Admin.Employee.Rate.index')
            @endif
        </div>



        <div id="scheduleshow" class="hidden w-full p-4 lg:w-full">
            @if ($employee->status == '3')
                <p class="text-xl text-center">This employee is currently undergoing pre-employment processes</p>
            @else
                <div class="flex justify-between p-2">
                    <div>
                        <h2 class="mb-6 text-xl font-bold">Work Schedule</h2>
                    </div>


                </div>


                @include('Admin.Employee.shedule.employeeshift')
            @endif
        </div>

        <div id="customsetupshow" class="hidden w-full p-4 lg:w-full">
            @if ($employee->status == '3')
                <p class="text-xl text-center">This employee is currently undergoing pre-employment processes</p>
            @else
                <div class="flex justify-between p-2">
                    <div>
                        <h2 class="mb-6 text-xl font-bold">Custom Setup</h2>
                    </div>


                </div>

                @include('Admin.Employee.Custombenefitssetup.index')
            @endif
        </div>

        <div id="documentshow" class=" hidden w-full md:p-4 lg:w-full">
            <h2 class="mb-6 text-xl font-bold">Employee Documents</h2>
            @include('Admin.Employee.Documents.index')
        </div>

        <div id="historyshow" class="hidden w-full p-4 lg:w-full">
            <h2 class="mb-6 text-xl font-bold">Deployment History</h2>
            @include('Admin.Employee.info.history')
        </div>


        <div id="employeedetailsshow" class="w-full md:p-4 lg:w-full">

            @include('Admin.Employee.profilecredentials')
        </div>






    </div>


    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Buttons that trigger the sections
            const sections = {
                showemployeedetails: 'employeedetailsshow',
                showpayroll: 'payrollshow',
                showattendance: 'attendanceshow',
                history: 'historyshow',
                showbenefits: 'benefitsshow',
                leave: 'leaveshow',
                loans: 'loanshow',
                constant: 'constantshow',
                rate: 'rateshow',
                others: 'othershow',
                schedule: 'scheduleshow',
                customsetup: 'customsetupshow',
                documentbutton: 'documentshow'
            };

            // Function to show a section and hide others
            function showSection(sectionToShow) {
                Object.values(sections).forEach(section => {
                    document.getElementById(section).classList.add('hidden');
                });
                document.getElementById(sectionToShow).classList.remove('hidden');
            }

            // Attach event listeners to buttons
            Object.keys(sections).forEach(buttonId => {
                const button = document.getElementById(buttonId);
                if (button) {
                    button.addEventListener('click', function() {
                        showSection(sections[buttonId]);
                    });
                }
            });

            // Dropdown toggle
            const menuButton = document.getElementById('menu-button');
            const dropdownMenu = document.getElementById('dropdown-menu');

            if (menuButton && dropdownMenu) {
                menuButton.addEventListener('click', function() {
                    dropdownMenu.classList.toggle('hidden');
                });
            }
        });
    </script>

    <script>
        function filterTable() {
            const input = document.getElementById('searchInput');
            const filter = input.value.toLowerCase();
            const table = document.getElementById('employeeTable');
            const trs = table.getElementsByTagName('tr');

            for (let i = 1; i < trs.length; i++) { // Start from 1 to skip the header
                const tds = trs[i].getElementsByTagName('td');
                let rowContainsMatch = false;

                // Check the field name and value for a match
                if (tds.length > 0) {
                    const fieldName = tds[0].textContent.toLowerCase(); // First column (Field name)
                    const fieldValue = tds[1].textContent.toLowerCase(); // Second column (Value)

                    // Match against both field name and value
                    if (fieldName.includes(filter) || fieldValue.includes(filter)) {
                        rowContainsMatch = true; // Found a match
                    }
                }

                // Show or hide the row based on the match
                trs[i].style.display = rowContainsMatch ? '' : 'none';
            }
        }
    </script>
@endsection
