<p class="mt-10 text-xl font-bold text-nowrap md:text-3xl mr-44">PERSONAL DATA</p>
<div class="text-sm ">
    <div class="p-4 ">
        <div class="grid grid-cols-1 gap-10 lg:grid-cols-5 ">
            <div class="p-2 bg-white border-2 border-black rounded-xl">
                <div class="flex flex-row items-center justify-center gap-2 ">

                    <div id="imagePreview" class="mt-2">

                        <img id="preview"
                            src="{{ $employee->profile ? Storage::disk('spaces')->url($employee->profile) : '' }}"
                            name="" alt="Image Preview"
                            class="object-cover w-full border-2 border-black h-[17rem] rounded-xl" />


                    </div>

                </div>
            </div>

            <div
                class="grid grid-cols-1 col-span-4 gap-4 p-5 mb-4 bg-white border-2 border-black rounded-md lg:grid-cols-2 md:grid-cols-4">
                <div class="p-2 mt-4 ">
                    <label class="block mb-1 text-gray-600" for="office_id">Select Office</label>
                    <select id="office_id" name="office_id" class="w-full p-2 border border-black rounded-md">
                        <option value="" disabled {{ old('office_id') ? '' : 'selected' }}>Select an Office
                        </option>
                        @foreach ($offices as $office)
                            <option value="{{ $office->id }}"
                                {{ $employee->office_id == $office->id ? 'selected' : '' }}>
                                {{ $office->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('office_id')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>

                <!-- Select Store -->
                <div class="p-2 mt-4 ">
                    <label class="block mb-1 text-gray-600" for="store_id">Select Store</label>
                    <select id="store_id" name="store_id" class="w-full p-2 border border-black rounded-md">
                        <option value="" disabled {{ old('store_id') ? '' : 'selected' }}>Select a Store
                        </option>
                        @foreach ($stores as $store)
                            <option value="{{ $store->id }}"
                                {{ $employee->store_id == $store->id ? 'selected' : '' }}>
                                {{ $store->name }}
                            </option>
                        @endforeach
                    </select>

                </div>


                <div class="p-2 mt-4 ">

                    <label for="last_name" class="block mb-1">Last Name:</label>
                    <p class="w-full p-2 border border-black rounded-md"> {{ $employee->last_name }} </p>

                </div>
                <div class="p-2 mt-4 ">

                    <label for="first_name" class="block mb-1">First Name:</label>
                    <p class="w-full p-2 border border-black rounded-md">{{ $employee->first_name }} </p>

                </div>
                <div class="p-2 mt-4 ">

                    <label for="middle_name" class="block mb-1">Middle Name (optional):</label>
                    <p class="w-full p-2 border border-black rounded-md"> {{ $employee->middle_name }} </p>

                </div>
                <div class="p-2 mt-4 ">

                    <label for="email" class="block mb-1">Email:</label>
                    <p class="w-full p-2 border border-black rounded-md">{{ $employee->user->email }} </p>

                </div>

            </div>
        </div>
        <div class="grid grid-cols-1 gap-4 p-5 mt-5 mb-4 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
            <div class="p-2 ">
                <label for="present_address" class="block mb-1">Present Address:</label>
                <p class="w-full p-2 border border-black rounded-md">{{ $employee->present_address }}</p>

            </div>
            <div class="p-2 ">
                <label for="provincial_address" class="block mb-1">Provincial Address:</label>
                <p class="w-full p-2 border border-black rounded-md">{{ $employee->provincial_address }} </p>

            </div>
            <div class="p-2 ">
                <label for="mobile_number" class="block mb-1">Mobile No:</label>
                <p class="w-full p-2 border border-black rounded-md">{{ $employee->mobile_number }} </p>

            </div>
            <div class="p-2 ">
                <label for="alternative_number" class="block mb-1">Alternative Number:</label>
                <p class="w-full p-2 border border-black rounded-md">{{ $employee->alternative_number }}</p>

            </div>
        </div>

        <div class="grid grid-cols-1 col-span-3 gap-4 p-5 bg-white border-2 border-black rounded-xl lg:grid-cols-2">


            <div class="p-2 ">
                <label for="date_of_birth" class="block mb-1">Date of Birth:</label>
                <p class="w-full p-2 border border-black rounded-md">{{ $employee->date_of_birth }}</p>

            </div>
            <div class="p-2 ">
                <label for="age" class="block mb-1">Age:</label>
                <p class="w-full p-2 border border-black rounded-md"> {{ $employee->age }} </p>

            </div>
            <div class="p-2 ">
                <label for="place_of_birth" class="block mb-1">Place of Birth:</label>
                <p class="w-full p-2 border border-black rounded-md"{{ $employee->place_of_birth }} </p>

            </div>
            <div class="p-2 ">
                <label for="nationality" class="block mb-1">Civil Status:</label>
                <p class="w-full p-2 border border-black rounded-md"> {{ $employee->civil_status }}</p>

            </div>
        </div>





        <div class="grid grid-cols-1 gap-10 lg:grid-cols-2">
            <div class="grid grid-cols-1 gap-4 p-5 mt-10 mb-4 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
                <div class="p-2 ">
                    <label for="nationality" class="block mb-1">Nationality:</label>
                    <p class="w-full p-2 border border-black rounded-md"> {{ $employee->nationality }}</p>

                </div>
                <div class="p-2 ">
                    <label for="religion" class="block mb-1">Religion:</label>
                    <p class="w-full p-2 border border-black rounded-md"> {{ $employee->religion }} </p>

                </div>
                <div class="p-2 ">
                    <label for="height" class="block mb-1">Height:</label>
                    <p class="w-full p-2 border border-black rounded-md"> {{ $employee->height }} </p>

                </div>
                <div class="p-2 ">
                    <label for="weight" class="block mb-1">Weight:</label>
                    <p class="w-full p-2 border border-black rounded-md"> {{ $employee->weight }} </p>

                </div>
            </div>
            <div class="grid grid-cols-1 gap-4 p-5 mt-10 mb-4 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
                <div class="p-2 ">
                    <label for="spouse_name" class="block mb-1">Name of Spouse (if married):</label>
                    <p class="w-full p-2 border border-black rounded-md">{{ $employee->spouse_name }}</p>

                </div>
                <div class="p-2 ">
                    <label for="spouse_occupation" class="block mb-1">Occupation:</label>
                    <p class="w-full p-2 border border-black rounded-md"> {{ $employee->spouse_occupation }} </p>

                </div>
                <div class="p-2 ">
                    <label for="mother_maiden_name" class="block text-sm font-medium text-gray-700">Mother's
                        Maiden
                        Name</label>
                    <p class="w-full p-2 border border-black rounded-md">{{ $employee->mother_maiden_name }} </p>

                </div>

                <div class="p-2 ">
                    <label for="mother_occupation" class="block text-sm font-medium text-gray-700">Mother's
                        Occupation</label>
                    <p class="w-full p-2 border border-black rounded-md">
                        {{ $employee->mother_occupation }} </p>

                </div>
            </div>
        </div>
        <div class="grid grid-cols-1 gap-10 lg:grid-cols-2">
            <div
                class="grid grid-cols-1 gap-4 p-5 mt-10 mb-4 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
                <div class="p-2 ">
                    <label for="mother_maiden_name" class="block text-sm font-medium text-gray-700">Mother's
                        Maiden
                        Name</label>
                    <p class="w-full p-2 border border-black rounded-md">{{ $employee->mother_maiden_name }} </p>

                </div>

                <div class="p-2">
                    <label for="mother_occupation" class="block text-sm font-medium text-gray-700">Mother's
                        Occupation</label>
                    <p class="w-full p-2 border border-black rounded-md">
                        {{ $employee->mother_occupation }} </p>

                </div>

                <div class="p-2 ">
                    <label for="father_name" class="block text-sm font-medium text-gray-700">Father's
                        Name</label>
                    <p class="w-full p-2 border border-black rounded-md"> {{ $employee->father_name }}</p>

                </div>

                <div class="p-2 ">
                    <label for="father_occupation" class="block text-sm font-medium text-gray-700">Father's
                        Occupation</label>
                    <p class="w-full p-2 border border-black rounded-md">
                        {{ $employee->father_occupation }} </p>

                </div>
            </div>
            <div
                class="grid
                        grid-cols-1 gap-4 p-5 mt-10 mb-4 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
                <div class="p-2 ">
                    <label for="dependents" class="block text-sm font-medium text-gray-700">Dependents</label>
                    <p class="w-full p-2 border border-black rounded-md"> {{ $employee->dependents }} </p>

                </div>

                <div class="p-2 ">
                    <label for="philhealth_no" class="block text-sm font-medium text-gray-700">PhilHealth
                        No.</label>
                    <p class="w-full p-2 border border-black rounded-md"> {{ $employee->philhealth_no }} </p>

                </div>
                <div class="p-2 ">
                    <label for="blood_type" class="block text-sm font-medium text-gray-700">Blood
                        Type</label>
                    <p class="w-full p-2 border border-black rounded-md">
                        {{ $employee->blood_type }}</p>

                </div>
            </div>
        </div>
    </div>
</div>`




<script>
    function previewImage(event) {
        const preview = document.getElementById('preview');
        const imagePreview = document.getElementById('imagePreview');

        // Get the file from the input
        const file = event.target.files[0];

        if (file) {
            // Create a FileReader to read the file
            const reader = new FileReader();

            // Set the image source when the file is loaded
            reader.onload = function(e) {
                preview.src = e.target.result;
                preview.classList.remove('hidden'); // Show the image
            };

            // Read the file as a data URL
            reader.readAsDataURL(file);
        } else {
            // If no file is selected, hide the image
            preview.src = "#";
            preview.classList.add('hidden');
        }
    }
</script>
