<!-- Modal structure -->
<div id="statusModal" class="hidden fixed inset-0 flex items-start justify-center bg-gray-500 bg-opacity-75 z-50">
    <div class="bg-white p-6 rounded-lg max-w-screen-2xl mt-20">
        <p class="text-lg text-gray-700" id="employeeName">Employee: </p>

        <!-- Form for updating status -->
        <form id="updateForm">
            @csrf
            @method('POST')
            <input type="hidden" id="employeeId" name="employee_id">
            <div class="flex items-start justify-center gap-10 mt-10">
                <div>
                    <p class="mb-5">Clearance Status</p>

                    <div class=" border-2 border-black p-5 rounded-md">

                        <div class="mb-4">
                            <label for="date" class="block text-gray-700">Date</label>
                            <input type="datetime-local" id="date" name="date"
                                class="w-full p-2 border rounded">
                        </div>

                        <!-- Status -->
                        <div class="mb-4">
                            <label for="status" class="block text-gray-700">Status</label>
                            <select id="status" name="status" class="w-full p-2 border rounded">
                                @if (in_array('Forwarded to HR', $privileges))
                                    <option value="Forwarded to HR">Forwarded to HR</option>
                                @endif
                                @if (in_array('Forwarded to Audit', $privileges))
                                    <option value="Forwarded to Audit">Forwarded to Audit</option>
                                @endif
                                @if (in_array('Forwarded to Billing', $privileges))
                                    <option value="Forwarded to Billing">Forwarded to Billing</option>
                                @endif
                                @if (in_array('Forwarded to Payroll', $privileges))
                                    <option value="Forwarded to Payroll">Forwarded to Payroll</option>
                                @endif
                                @if (in_array('Forwarded to AP', $privileges))
                                    <option value="Forwarded to AP">Forwarded to AP</option>
                                @endif
                                @if (in_array('Forwarded to HR', $privileges))
                                    <option value="Forwarded to HR">Forwarded to HR</option>
                                @endif


                            </select>
                        </div>


                        <!-- Remarks -->
                        <div class="mb-4">
                            <label for="remarks" class="block text-gray-700">Remarks</label>
                            <textarea id="remarks" name="remarks" class="w-full p-2 border rounded" rows="4" maxlength="300"></textarea>
                        </div>
                    </div>
                </div>
                @if (in_array('Claims Status', $privileges))
                    <div>
                        <p class="mb-5">Claims Status</p>
                        <div class="border-2 border-black p-5 rounded-md">

                            <div class="mb-4">
                                <label for="cheque" class="block text-gray-700">Cheque #</label>
                                <input type="text" id="cheque" name="cheque" class="w-full p-2 border rounded">
                            </div>

                            <!-- Bank Number -->
                            <div class="mb-4">
                                <label for="amount" class="block text-gray-700">Amount</label>
                                <input type="text" id="amount" name="amount" class="w-full p-2 border rounded">
                            </div>

                            <div class="mb-4">
                                <label for="status_claim" class="block text-gray-700">Status of Claims</label>
                                <select id="status_claim" name="status_claim" class="w-full p-2 border rounded"
                                    onchange="toggleClaimType()">
                                    <option value="">Choose an option</option>
                                    <option value="PENDING">PENDING</option>
                                    <option value="RELEASE">RELEASE</option>
                                </select>
                            </div>

                            <!-- Initially hidden container -->
                            <div id="claimTypeContainer" class="mb-4 hidden">
                                <label for="claim_type" class="block text-gray-700">Type of Claims</label>
                                <select id="claim_type" name="claim_type" class="w-full p-2 border rounded">
                                    <option value="">Choose an option</option>
                                    <option value="REGULAR">REGULAR</option>
                                    <option value="DOLE_CASE">DOLE CASE</option>
                                    <option value="NLRC">NLRC</option>
                                    <option value="DECEASED">DECEASED</option>
                                </select>
                            </div>

                            <script>
                                function toggleClaimType() {
                                    var status = document.getElementById("status_claim").value;
                                    var claimTypeContainer = document.getElementById("claimTypeContainer");

                                    if (status === "RELEASE") {
                                        claimTypeContainer.classList.remove("hidden"); // Show dropdown
                                    } else {
                                        claimTypeContainer.classList.add("hidden"); // Hide dropdown
                                    }
                                }
                            </script>



                            <!-- File -->

                        </div>
                    </div>
                @endif
            </div>
            <!-- Bank Name -->


            <div class="flex justify-end mt-5">
                <div>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded">Save</button>
                    <button type="button" class="px-4 py-2 bg-gray-300 text-black rounded ml-2"
                        onclick="closeModal()">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>











<div id="detailsModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 flex items-start justify-center z-50 hidden">
    <div class="bg-white rounded-lg overflow-hidden shadow-lg max-w-6xl mt-20 w-full">
        <div class="flex justify-between items-center p-4  ">
            <h5 class="text-lg font-semibold">Employee Logs</h5>
            <button type="button" class="text-white" onclick="closeModal123()">
                <span>&times;</span>
            </button>
        </div>
        <div class="p-4">
            <table class="table-auto w-full text-sm text-left text-gray-600 border-separate border-spacing-0.5">
                <thead class="bg-gray-200 border-b-2 border-gray-300">
                    <tr>
                        <th class="px-6 py-3 font-semibold text-gray-800 text-left">User</th>
                        <th class="px-6 py-3 font-semibold text-gray-800 text-left">Date</th>
                        <th class="px-6 py-3 font-semibold text-gray-800 text-left">Action</th>
                        <th class="px-6 py-3 font-semibold text-gray-800 text-left">Remarks</th>
                        <th class="px-6 py-3 font-semibold text-gray-800 text-left">Cheque</th>
                        <th class="px-6 py-3 font-semibold text-gray-800 text-left">Amount</th>
                    </tr>
                </thead>
                <tbody id="logsBody" class="bg-white">
                    <!-- Example row with hover effect -->

                    <!-- You can add more rows dynamically -->
                </tbody>
            </table>

        </div>
        <div class="p-4 flex justify-end bg-gray-100">
            <button type="button" class="bg-gray-500 text-white rounded-lg px-4 py-2"
                onclick="closeModal123()">Close</button>
        </div>
    </div>
</div>
<script>
    // Variable to store the ID of the log to be deleted
    let logIdToDelete = null;

    // Open the modal to show logs
    function openDetailsModal(employeeId) {
        // Generate the URL using Laravel's route() helper for fetching logs
        var url = '{{ route('clearanceLogs', ':employeeId') }}';
        url = url.replace(':employeeId', employeeId); // Replace the placeholder with the actual employeeId

        // Fetch logs for the employee using AJAX
        $.ajax({
            url: url, // Now using the route-generated URL
            method: 'GET',
            success: function(data) {
                // Clear previous modal content
                $('#logsBody').empty();

                // Populate the modal with the logs
                data.forEach(function(log) {
                    // Format the date (assuming log.date is in 'YYYY-MM-DD' format)
                    var formattedDate = new Date(log.date);
                    var options = {
                        year: 'numeric',
                        month: 'long',
                        day: 'numeric',
                        hour: 'numeric',
                        minute: 'numeric',
                        second: 'numeric',
                        hour12: true
                    };
                    var dateString = formattedDate.toLocaleString('en-US', options);

                    // Append the row to the modal table, with a delete button
                    $('#logsBody').append(`
                        <tr data-id="${log.id}">
                             <td class="px-4 py-2">${log.user_name}</td>
                            <td class="px-4 py-2">${dateString}</td>
                            <td class="px-4 py-2">${log.action}</td>
                            <td class="px-4 py-2">${log.remarks}</td>
                            <td class="px-4 py-2">${log.cheque}</td>
                            <td class="px-4 py-2">${log.amount}</td>
                            
                        </tr>
                    `);
                });

                // Show the modal
                openModal();
            },
            error: function(xhr, status, error) {
                console.error(error);
                alert('Could not fetch logs. Please try again later.');
            }
        });
    }

    // Show the modal
    function openModal() {
        const modal = document.getElementById('detailsModal');
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    // Close the modal
    function closeModal123() {
        const modal = document.getElementById('detailsModal');
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }

    // Show the delete confirmation modal
    function showDeleteConfirmationModal(logId) {
        // Set the logId to delete
        logIdToDelete = logId;

        // Show the confirmation modal
        const deleteModal = document.getElementById('deleteConfirmationModal');
        deleteModal.classList.remove('hidden');
        deleteModal.classList.add('flex');
    }

    // Close the delete confirmation modal
    function closeDeleteModal() {
        const deleteModal = document.getElementById('deleteConfirmationModal');
        deleteModal.classList.add('hidden');
        deleteModal.classList.remove('flex');
    }

    // Handle the actual deletion of the log
    function deleteLog() {
        if (logIdToDelete !== null) {
            // Generate the URL for the delete action using the route name
            var deleteUrl = '{{ route('clearanceLogs.destroy', ':logId') }}';
            deleteUrl = deleteUrl.replace(':logId', logIdToDelete);

            // Send DELETE request to the backend
            $.ajax({
                url: deleteUrl, // Use the route URL
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // CSRF Token
                },
                success: function(response) {
                    // Remove the deleted row from the table
                    $(`#logsBody tr[data-id="${logIdToDelete}"]`).remove();
                    alert('Log deleted successfully.');

                    // Close the delete confirmation modal
                    closeDeleteModal();
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    alert('Could not delete the log. Please try again later.');
                }
            });
        }
    }

    // Make sure to bind the delete event when the modal is shown
    $('#confirmDeleteButton').on('click', function() {
        deleteLog();
    });
    // Attach the delete action to the confirmation button
    document.getElementById('confirmDeleteButton').addEventListener('click', deleteLog);
</script>


<div id="deleteConfirmationModal"
    class="fixed inset-0 bg-gray-600 bg-opacity-50 flex items-center justify-center z-50 hidden">
    <div class="bg-white rounded-lg overflow-hidden shadow-lg max-w-md w-full">
        <div class="p-4">
            <h5 class="text-lg font-semibold">Are you sure you want to delete this log?</h5>
            <p class="text-sm text-gray-600">This action cannot be undone.</p>
        </div>
        <div class="flex justify-end p-4 bg-gray-100">
            <button class="bg-gray-500 text-white px-4 py-2 rounded mr-2" onclick="closeDeleteModal()">Cancel</button>
            <button class="bg-red-500 text-white px-4 py-2 rounded" id="confirmDeleteButton">Delete</button>
        </div>
    </div>
</div>
