@extends('layouts.sidebar')

@section('title', 'Employee Clearance')
@section('content')
    @if (in_array('Manage Clearance', $privileges))
        @include('Admin.Employee.clearance.modal')<!-- Include your modal -->

        <div class="w-full overflow-x-auto" id="employee-details-section">
            <div class="">
                <h2 class="mb-6 font-bold">Clearance</h2>
            </div>

            @if (session('success'))
                <div class="text-center text-red-900 alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            <div class="overflow-auto bg-white p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
                <table id="employedbank-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                    <thead>
                        <tr class="text-sm leading-normal  text-white  bg-[#1d1d1d]">
                            <th class="px-6 py-1">ID</th>

                            <th class="px-6 py-1">Name</th>
                            <th class="px-6 py-1">Date of Birth</th>
                            <th class="px-6 py-1">Status</th>
                            <th class="px-6 py-1">Type of Claim</th>
                            <th class="px-6 py-1">Email</th>
                            <th class="px-6 py-1">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="text-sm font-light text-center text-gray-600">
                        <!-- Data will be populated here by DataTables -->
                    </tbody>
                </table>
            </div>
        </div>
        <!-- Success Modal -->
        <div id="successModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50">
            <div class="p-6 mt-20 text-center bg-white rounded-lg shadow-lg">
                <h3 class="text-xl font-semibold text-green-600">Success</h3>
                <p class="mt-2 text-gray-700">Employee information updated successfully!</p>
                <button onclick="closeSuccessModal()"
                    class="px-4 py-2 mt-4 text-white bg-green-500 rounded hover:bg-green-600">
                    OK
                </button>
            </div>
        </div>

        <script type="text/javascript">
            $(document).ready(function() {
                // Initialize DataTable for displaying employee bank details
                var preEmploymentTable = $('#employedbank-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('clearance.index') }}",
                        data: function(d) {
                            // Additional filters can be added here
                        }
                    },
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },

                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'date_of_birth',
                            name: 'date_of_birth'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                        {
                            data: 'claims',
                            name: 'claims'
                        },
                        {
                            data: 'user.email',
                            name: 'user.email'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ],
                    // Default sorting, prioritize status for "Forwarded to Accounting"
                    order: [
                        [4, 'asc']
                    ], // Sort by the status column in ascending order
                    columnDefs: [{
                        targets: 4, // Target the 'status' column
                        render: function(data, type, row) {
                            return data === 'Forwarded to Accounting' ? 'Forwarded to Accounting' :
                                data;
                        }
                    }]
                });

                // Function to open the modal and populate the form with employee data
                window.openStatusModal = function(employeeId, employeeFullName) {
                    $('#employeeId').val(employeeId);
                    $('#employeeName').text("Employee: " + employeeFullName);
                    $('#statusModal').removeClass('hidden'); // Show the modal
                };

                // Function to close the status update modal
                window.closeModal = function() {
                    $('#statusModal').addClass('hidden');
                };

                // Function to close the success modal
                window.closeSuccessModal = function() {
                    $('#successModal').addClass('hidden');
                };

                // AJAX form submission for updating employee information
                $('#updateForm').submit(function(e) {
                    e.preventDefault(); // Prevent default form submission

                    let formData = $(this).serialize(); // Serialize the form data

                    $.ajax({
                        url: '{{ route('clearance_store', ':employeeId') }}'.replace(':employeeId', $(
                            '#employeeId').val()),
                        method: 'POST',
                        data: formData,
                        success: function(response) {
                            $('#successModal').removeClass('hidden'); // Show the success modal
                            closeModal(); // Close the status update modal
                            preEmploymentTable.ajax.reload(); // Reload DataTable
                        },
                        error: function(xhr, status, error) {
                            alert('An error occurred: ' + error); // Handle error response
                        }
                    });
                });

            });
        </script>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i>
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif

@endsection
