<!-- Modal structure -->
<div id="statusModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-500 bg-opacity-75">
    <div class="p-6 mt-20 bg-white rounded-lg max-w-screen-2xl">
        <p class="text-lg text-gray-700" id="employeeName">Employee: </p>

        <!-- Form for updating status -->
        <form id="updateForm" enctype="multipart/form-data">
            @csrf
            @method('POST')
            <input type="hidden" id="employeeId" name="employee_id">
            <div class="flex items-start gap-10 mt-10">
                <div class="p-5 border-2 border-black rounded-md ">
                    <div class="mb-4">
                        <label for="date" class="block text-gray-700">Date</label>
                        <input type="datetime-local" id="date" name="date" class="w-full p-2 border rounded">
                    </div>

                    <!-- Status -->
                    <div class="mb-4">
                        <label for="status" class="block text-gray-700">Status</label>
                        <select id="status" name="status" class="w-full p-2 border rounded">
                            @if (in_array('Apply to Bank', $privileges))
                                <option value="Apply to Bank">Apply to Bank</option>
                            @endif
                            @if (in_array('Pending with Discrepancy', $privileges))
                                <option value="Pending with Discrepancy">Pending with Discrepancy</option>
                            @endif
                            @if (in_array('Available for Pickup', $privileges))
                                <option value="Available for Pickup">Available for Pickup</option>
                            @endif
                            @if (in_array('With Certification', $privileges))
                                <option value="With Certification">With Certification</option>
                            @endif
                            @if (in_array('Forwarded to Accounting', $privileges))
                                <option value="Forwarded to Accounting">Forwarded to Accounting</option>
                            @endif


                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="remarks" class="block text-gray-700">Remarks</label>
                        <textarea id="remarks" name="remarks" class="w-full p-2 border rounded" rows="4" maxlength="300"></textarea>
                    </div>
                </div>
                <div class="p-5 border-2 border-black rounded-md">
                    @if (in_array('Input Bank Info', $privileges))
                        <div class="mb-4">
                            <label for="bank_name" class="block text-gray-700">Bank Name</label>
                            <select id="bank_name" name="bank_name" class="w-full p-2 border rounded">
                                <option value="">Select Bank</option>
                                @foreach ($banks as $bank)
                                    <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-4">
                            <label for="bank_number" class="block text-gray-700">Bank Number</label>
                            <input type="text" id="bank_number" name="bank_number" class="w-full p-2 border rounded">
                        </div>
                    @endif

                    <div class="mb-4">
                        <label for="file" class="block text-gray-700">Upload File</label>
                        <input type="file" id="file" name="file" class="w-full p-2 border rounded">
                    </div>
                </div>
            </div>

            <div class="flex justify-end">
                <div>
                    <button type="submit" class="px-4 py-2 text-white bg-blue-600 rounded">Save</button>
                    <button type="button" class="px-4 py-2 ml-2 text-black bg-gray-300 rounded"
                        onclick="closeModal()">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>











<div id="detailsModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-600 bg-opacity-50">
    <div class="w-full max-w-4xl mt-20 overflow-hidden bg-white rounded-lg shadow-lg">
        <div class="flex items-center justify-between p-4 ">
            <h5 class="text-lg font-semibold">Employee Logs</h5>
            <button type="button" class="text-white" onclick="closeModal123()">
                <span>&times;</span>
            </button>
        </div>
        <div class="p-4">
            <table class="table-auto w-full text-sm text-left text-gray-600 border-separate border-spacing-0.5">
                <thead class="bg-gray-200 border-b-2 border-gray-300">
                    <tr>
                        <th class="px-6 py-3 font-semibold text-left text-gray-800">User</th>
                        <th class="px-6 py-3 font-semibold text-left text-gray-800">Date</th>
                        <th class="px-6 py-3 font-semibold text-left text-gray-800">Action</th>
                        <th class="px-6 py-3 font-semibold text-left text-gray-800">Remarks</th>
                        <th class="px-6 py-3 font-semibold text-left text-gray-800">File</th>
                    </tr>
                </thead>
                <tbody id="logsBody" class="bg-white">
                    <!-- Logs will be dynamically loaded here -->
                </tbody>
            </table>

        </div>
        <div class="flex justify-end p-4 bg-gray-100">
            <button type="button" class="px-4 py-2 text-white bg-gray-500 rounded-lg"
                onclick="closeModal123()">Close</button>
        </div>
    </div>
</div>
<script>
    function openDetailsModal(employeeId) {
        var url = '{{ route('bank-logs.get', ':employeeId') }}';
        url = url.replace(':employeeId', employeeId);

        $.ajax({
            url: url, 
            method: 'GET',
            success: function(data) {
                $('#logsBody').empty();
                var baseUrl = '{{ asset('') }}'; 
                data.forEach(function(log) {
                    $('#logsBody').append(`
                    <tr>
                         <td class="px-4 py-2">${log.user_name}</td>
                        <td class="px-4 py-2">${log.date}</td>
                        <td class="px-4 py-2">${log.action}</td>
                        <td class="px-4 py-2">${log.remarks}</td>
                        <td class="px-4 py-2">
                            <a href="${baseUrl}${log.file}" target="_blank" class="text-blue-600">View File</a>
                        </td>
                    </tr>
                `);
                });

                // Show the modal
                openModal();
            },
            error: function(xhr, status, error) {
                console.error(error);
                alert('Could not fetch logs. Please try again later.');
            }
        });
    }

    // Show the modal
    function openModal() {
        const modal = document.getElementById('detailsModal');
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    // Close the modal
    function closeModal123() {
        const modal = document.getElementById('detailsModal');
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>
