@extends('layouts.sidebar')

@section('title', 'Employee banks')
@section('content')
    @if (in_array('Manage Banks', $privileges))
        @include('Admin.Employee.bank.modal')<!-- Include your modal -->

        <div class="w-full overflow-x-auto " id="employee-details-section">
            <div class="flex justify-between">
                <h2 class="mb-6  font-bold">Bank Accounts Management</h2>
            </div>

            @if (session('success'))
                <div class="text-center text-red-900 alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            <div class="overflow-auto bg-white p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
                <div class="mb-4 w-[20rem] ">
                    <label for="bankStatusFilter" class="block text-gray-700">Filter by Status</label>
                    <select id="bankStatusFilter" class="w-full border-2 border-black p-2  rounded">
                        <option value="for_application">For Application</option>
                        <option value="Apply to Bank">Apply to Bank</option>
                        <option value="Pending with Discrepancy">Pending with Discrepancy</option>
                        <option value="Available for Pickup">Available for Pickup</option>
                        <option value="With Certification">With Certification</option>
                        <option value="Forwarded to Accounting">Forwarded to Accounting</option>
                    </select>
                </div>

                <table id="employedbank-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                    <thead>
                        <tr class="text-sm leading-normal  text-white  bg-[#1d1d1d]">
                            <th class="px-6 py-1">ID</th>
                            <th class="px-6 py-1">Agency</th>
                            <th class="px-6 py-1">Company</th>
                            <th class="px-6 py-1">Client</th>
                            <th class="px-6 py-1">Name</th>

                            <th class="px-6 py-1">Date of Birth</th>
                            <th class="px-6 py-1">Status</th>
                            <th class="px-6 py-1">Email</th>
                            <th class="px-6 py-1">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="text-sm font-light text-center text-gray-600">
                        <!-- Data will be populated here by DataTables -->
                    </tbody>
                </table>
            </div>
        </div>
        <div id="successModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50">
            <div class="p-6 mt-20 bg-white rounded-lg shadow-lg">
                <h2 class="text-lg font-bold">Success</h2>
                <p id="successMessage">Employee information updated successfully!</p>
                <button onclick="closeSuccessModal()" class="px-4 py-2 mt-4 text-white bg-green-500 rounded">OK</button>
            </div>
        </div>
        <script type="text/javascript">
            $(document).ready(function() {
                $('#bankStatusFilter').on('change', function() {
                    preEmploymentTable.ajax.reload(); // Reload DataTable on status change
                });
                var preEmploymentTable = $('#employedbank-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('bank.index') }}",
                        data: function(d) {
                            d.bank_status = $('#bankStatusFilter').val(); // Send selected status to server
                        }
                    },
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'agency',
                            name: 'agency'
                        },
                        {
                            data: 'company',
                            name: 'company'
                        },
                        {
                            data: 'client',
                            name: 'client'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },

                        {
                            data: 'employee.date_of_birth',
                            name: 'employee.date_of_birth'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                        {
                            data: 'employee.user.email',
                            name: 'employee.user.email'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ],
                    order: [
                        [4, 'asc']
                    ],
                });

                window.openStatusModal = function(employeeId, employeeFullName) {
                    $('#employeeId').val(employeeId);
                    $('#employeeName').text("Employee: " + employeeFullName);
                    $('#statusModal').removeClass('hidden');
                };

                window.closeModal = function() {
                    $('#statusModal').addClass('hidden');
                };

                window.closeSuccessModal = function() {
                    $('#successModal').addClass('hidden');
                };

                // Handle the form submission
                $('#updateForm').submit(function(e) {
                    e.preventDefault();

                    // Create a FormData object from the form
                    var formData = new FormData(this); // 'this' refers to the form element itself

                    // If no file is selected but required, show an alert


                    $.ajax({
                        url: '{{ route('bank.add', ':employeeId') }}'.replace(':employeeId', $(
                            '#employeeId').val()),
                        method: 'POST',
                        data: formData,
                        contentType: false, // Do not set contentType because it's handled by FormData
                        processData: false, // Prevent jQuery from processing the data
                        success: function(response) {
                            $('#successModal').removeClass('hidden');
                            closeModal();
                            preEmploymentTable.ajax.reload(); // Reload the table data
                        },
                        error: function(xhr, status, error) {
                            alert('An error occurred: ' + error);
                        }
                    });
                });
            });
        </script>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i>
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif

@endsection
