<form id="create-department-form" action="{{ route('charges.store1231') }}" class="w-full space-y-6" method="POST">
    @csrf
    @if ($errors->any())
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <div class="grid grid-cols-1 gap-10 lg:grid-cols-2">

        <div class="space-y-5 border-2 border-black p-4">
            <input name="department_id" class="" type="hidden" value="{{ $department->id }}">
            <div class="mb-4">
                <p class="mb-5 text-xl font-bold">ASF</p>
                <label class="block mb-2 font-bold text-gray-700" for="service_charge_type">Service
                    Charge
                    Type</label>
                <select name="service_charge_type" id="service_charge_type"
                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                    onchange="toggleServiceChargeInput()" required>
                    <option value="amount">Amount</option>
                    <option value="percentage">Percentage</option>
                </select>
            </div>


            <div class="mb-4" id="service_charge_amount_container">

                <label class="block mb-2 font-bold text-gray-700" for="charge_amount">Service Charge
                    (Amount)</label>
                <input type="number" name="charge_amount" id="service_charge_amount"
                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                    placeholder="Enter service charge amount">
            </div>

            <!-- Service Charge Percentage Field -->
            <div class="mb-4" id="service_charge_percentage_container" style="display: none;">
                <label class="block mb-2 font-bold text-gray-700" for="service_charge">Service
                    Charge
                    (Percentage)</label>
                <input type="number" name="service_charge" id="service_charge"
                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                    placeholder="Enter service charge percentage">
            </div>
            <div class="mb-4 border-2 border-black rounded-md p-5 ">
                <select id="selectOption1"
                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm">
                    <option value="default">Select an Option</option>
                    <option value="showDiv1">Default</option>
                    <option value="showDiv2">Special Set Up</option>
                </select>
                <div id="div11" class="p-4 mt-4 mb-4">
                    <div class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="s_camputation_for_all" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">all</label>

                        </div>
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="s_sss" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">SSS Default</label>

                        </div>
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="s_phil" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">Philhealth Default</label>

                        </div>
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="s_pagibig" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">Pagibig Default</label>

                        </div>
                    </div>

                    <div class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">

                        @foreach ($trx as $item)
                            <div class="flex items-center space-x-3">
                                <input type="checkbox" name="service_type[]" value="{{ $item->id }}"
                                    id="trx_{{ $item->id }}"
                                    class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                <label for="trx_{{ $item->id }}" class="">{{ $item->description }}</label>
                            </div>
                        @endforeach
                    </div>

                </div>

                <!-- Div 2 -->
                <div id="div22" class="hidden mb-4">
                    <label class="block mb-2 font-bold text-gray-700" for="vat">Special
                        Rate</label>
                    <input type="number" name="special_rate_service" id="special_rate_service"
                        class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                        placeholder="Enter VAT">
                </div>

                <script>
                    document.getElementById('selectOption1').addEventListener('change', function() {
                        const selectedValue = this.value;
                        const div1 = document.getElementById('div11');
                        const div2 = document.getElementById('div22');

                        // Hide both divs initially
                        div1.classList.add('hidden');
                        div2.classList.add('hidden');

                        // Show the selected div based on the option chosen
                        if (selectedValue === 'showDiv1') {
                            div1.classList.remove('hidden');
                            div1.classList.add('block');
                        } else if (selectedValue === 'showDiv2') {
                            div2.classList.remove('hidden');
                            div2.classList.add('block');
                        }
                    });
                </script>
            </div>

        </div>
        <div class="space-y-5 border-2 border-black p-4">
            <div class="mb-4">
                <label class="block mb-2 font-bold text-gray-700" for="vat">VAT</label>
                <input type="number" name="vat" id="vat"
                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                    placeholder="Enter VAT" required>
            </div>
            <div class="mb-4 rounded-md border-2 border-black p-5">
                <select id="selectOption"
                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-s">
                    <option value="default">Select an Option</option>
                    <option value="showDiv1">Default</option>
                    <option value="showDiv2">Special Set Up</option>
                </select>
                <div id="div1" class="p-4 mt-4 mb-4">
                    <div class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="v_camputation_for_all" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">all</label>

                        </div>
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="v_sss" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">SSS Default</label>

                        </div>
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="v_phil" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">Philhealth Default</label>

                        </div>
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="v_pagibig" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">Pagibig Default</label>

                        </div>
                    </div>

                    <div class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">

                        @foreach ($trx as $item)
                            <div class="flex items-center space-x-3">
                                <input type="checkbox" name="vat_type[]" value="{{ $item->id }}"
                                    id="trx_{{ $item->id }}"
                                    class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                <label for="trx_{{ $item->id }}" class="">{{ $item->description }}</label>
                            </div>
                        @endforeach
                    </div>

                </div>

                <!-- Div 2 -->
                <div id="div2" class="hidden mb-4">
                    <label class="block mb-2 font-bold text-gray-700" for="vat">Special
                        Rate</label>
                    <input type="number" name="special_rate_vat" id="special_rate_vat"
                        class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                        placeholder="Enter VAT">
                </div>

                <script>
                    document.getElementById('selectOption').addEventListener('change', function() {
                        const selectedValue = this.value;
                        const div1 = document.getElementById('div1');
                        const div2 = document.getElementById('div2');

                        // Hide both divs initially
                        div1.classList.add('hidden');
                        div2.classList.add('hidden');

                        // Show the selected div based on the option chosen
                        if (selectedValue === 'showDiv1') {
                            div1.classList.remove('hidden');
                            div1.classList.add('block');
                        } else if (selectedValue === 'showDiv2') {
                            div2.classList.remove('hidden');
                            div2.classList.add('block');
                        }
                    });
                </script>
            </div>
            <!-- Withholding Tax -->
            <div class="mb-4 rounded-md border-2 border-black p-5">
                <label class="block mb-2 font-bold text-gray-700" for="withholding_tax">Withholding
                    Tax</label>
                <input type="number" name="withholding_tax" id="withholding_tax"
                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                    placeholder="Enter withholding tax" required>
                <div class="p-4 mt-4 mb-4">
                    <div class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="w_camputation_for_all" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">all</label>

                        </div>
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="w_sss" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">SSS Default</label>

                        </div>
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="w_phil" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">Philhealth Default</label>

                        </div>
                        <div class="flex items-center space-x-3">

                            <input type="checkbox" name="w_pagibig" value="1" id="all"
                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                            <label for="ALL" class="">Pagibig Default</label>

                        </div>
                    </div>

                    <div class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">

                        @foreach ($trx as $item)
                            <div class="flex items-center space-x-3">
                                <input type="checkbox" name="withholding_type[]" value="{{ $item->id }}"
                                    id="trx_{{ $item->id }}"
                                    class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                <label for="trx_{{ $item->id }}" class="">{{ $item->description }}</label>
                            </div>
                        @endforeach
                    </div>

                </div>
            </div>

            <!-- Convert in Minute Checkbox -->
            <div class="mb-4">
                <label class="block mb-2 font-bold text-gray-700" for="convert_inminute">Convert
                    to
                    Minute</label>
                <input type="checkbox" name="convert_inminute" id="convert_inminute" value="1"
                    class="mr-2 leading-tight">
                <span class="text-gray-700">Convert Decimal Part As Minute</span>
            </div>
        </div>
    </div>
    <div class="p-5 border-2 border-black">
        <div class="mb-4">
            <label class="block mb-2 font-bold text-gray-700" for="withholding_tax">Start Date
            </label>
            <input type="date" name="start_date" id="start_date"
                class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                placeholder="Enter withholding tax" required>
        </div>
        <div class="mb-4">
            <label class="block mb-2 font-bold text-gray-700" for="withholding_tax">End Date
            </label>
            <input type="date" name="end_date" id="end_date"
                class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                placeholder="Enter withholding tax" required>
        </div>
    </div>

    <!-- Submit Button -->
    <div class="flex items-center justify-center">
        <button type="submit"
            class="inline-flex justify-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
            Create
        </button>
    </div>
</form>
<div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p class="mt-2 text-center text-gray-700">Attendance record added successfully!</p>
        <div class="mt-4 text-center">
            <button id="closeSuccessModal" class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        $("#create-department-form").submit(function(e) {
            e.preventDefault();

            let formData = new FormData(this);

            $.ajax({
                url: $(this).attr("action"), // Get form action URL
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        $('#successModal').removeClass('hidden');
                        $("#create-department-form")[0].reset();
                        $('#chargesTable').DataTable().ajax.reload(null,
                            false);
                    } else {
                        alert("Something went wrong!");
                    }
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON;
                    if (errors && errors.message) {
                        alert(errors.message);
                    }
                }
            });
        });

        function closeModal(modalId, reopenButtonId) {
            $(modalId).addClass('hidden');

        }
        $('#closeSuccessModal').click(function() {
            closeModal('#successModal');
        });

    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Select2 for company selection
        $('#client_id').select2({
            placeholder: "Select Company",
            allowClear: true,
            width: '100%' // Ensure it adapts to full width
        });

        // Initialize Select2 for service charge type
        $('#service_charge_type').select2({
            minimumResultsForSearch: Infinity, // Disable search bar for this dropdown
            width: '100%' // Ensure it adapts to full width
        });
    });

    // Function to toggle between the Amount and Percentage inputs
    function toggleServiceChargeInput() {
        var serviceChargeType = document.getElementById('service_charge_type').value;
        var amountContainer = document.getElementById('service_charge_amount_container');
        var percentageContainer = document.getElementById('service_charge_percentage_container');

        if (serviceChargeType === 'amount') {
            amountContainer.style.display = 'block';
            percentageContainer.style.display = 'none';
        } else if (serviceChargeType === 'percentage') {
            amountContainer.style.display = 'none';
            percentageContainer.style.display = 'block';
        }
    }
</script>
