<div class="grid grid-cols-1 gap-5 lg:grid-cols-6">
    <div>
        <form id="uploadFormfile" enctype="multipart/form-data">
            @csrf

            <input type="hidden" name="department_id" value="{{ $department->id }}" id="department_id">

            <div class="mb-4">
                <label for="name" class="block text-sm font-semibold text-gray-700">File Name</label>
                <input type="text" name="name" id="name" required
                    class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
            </div>

            <div class="mb-4">
                <label for="file" class="block text-sm font-semibold text-gray-700">Upload File</label>
                <input type="file" name="file" id="file"
                    class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
            </div>

            <button type="submit" class="w-full px-4 py-2 text-white bg-blue-600 rounded-md hover:bg-blue-700">
                Upload File
            </button>
        </form>
    </div>

    <div class="col-span-5 overflow-x-auto">
        <table id="department-files-table"
            class="min-w-full text-center bg-white border border-gray-200 rounded shadow-md">
            <thead>
                <tr class="text-sm leading-normal text-white text-nowrap bg-[#1d1d1d]">
                    <th>Name</th>
                    <th>File</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>
</div>

<!-- Delete Confirmation Modal with a unique ID -->
<div id="deleteFileModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-900 bg-opacity-50">
    <div class="p-6 mt-20 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-semibold">Confirm Deletion</h2>
        <p class="text-gray-700">Are you sure you want to delete this file?</p>
        <input type="hidden" id="deleteFileId">
        <div class="flex justify-end mt-4">
            <button id="cancelfileDelete"
                class="px-4 py-2 mr-2 text-gray-700 border border-gray-300 rounded-lg hover:bg-gray-100">
                Cancel
            </button>
            <button id="confirmfileDelete" type="submit"
                class="px-4 py-2 text-white bg-red-600 rounded-lg hover:bg-red-700">
                Delete
            </button>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        var department_id = {{ $department->id }};
        var table = $('#department-files-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route('index_file', ['id' => ':id']) }}'.replace(':id', department_id),
            columns: [{
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'file_link',
                    name: 'file_link'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });

        // Handle form submission via AJAX
        $('#uploadFormfile').submit(function(e) {
            e.preventDefault();
            var formData = new FormData(this);

            $.ajax({
                url: "{{ route('file_store') }}",
                method: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    alert("File uploaded successfully!");
                    $('#uploadFormfile')[0].reset();
                    // Reload the department files table
                    table.ajax.reload();
                },
                error: function(xhr) {
                    alert("An error occurred: " + xhr.responseText);
                }
            });
        });

        $(document).on('click', '.delete-file', function() {
            var fileId = $(this).data('id');
            $('#deleteFileId').val(fileId);
            $('#deleteFileModal').removeClass('hidden');
        });

        // Close Modal
        $('#cancelfileDelete').click(function() {
            $('#deleteFileModal').addClass('hidden');
        });

        // Confirm Delete
        $('#confirmfileDelete').click(function() {
            var fileId = $('#deleteFileId').val();
            $.ajax({
                url: "{{ route('delete_file', ':id') }}".replace(':id', fileId),
                method: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    alert("File deleted successfully!");
                    $('#deleteFileModal').addClass('hidden');
                    // Reload the department files table
                    table.ajax.reload();
                },
                error: function(xhr) {
                    alert("An error occurred: " + xhr.responseText);
                }
            });
        });
    });
</script>
