@extends('layouts.sidebar')

@section('title', 'Departments')
@section('content')
    @if (in_array('Manage Client', $privileges))

        @include('Admin.Department.modal')

        <div class="flex items-center justify-between py-5 text-sm">
            <h2 class="mb-6 font-bold">Client List and Work Schedule</h2>

            @if (in_array('Create Client', $privileges))
                <button type="button"
                    class="modal-button w-40 h-10 bg-[#1d1d1d] text-white rounded-md cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700"
                    onclick="openModal('departmentModal')">
                    Add Client
                </button>
            @endif
        </div>
        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        <div class="overflow-auto p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
            <table id="department-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
                <thead>
                    <tr class="text-sm leading-normal  text-white uppercase bg-[#1d1d1d]">
                        <th class="px-6 py-3">Agency</th>
                        <th class="px-6 py-3">Company</th>
                        <th class="px-6 py-3">Client</th>
                        <th class="px-6 py-3">Number of Employees</th>
                        <th class="px-6 py-3">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                </tbody>
            </table>
        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif


    <script>
        $(document).ready(function() {

            var departmentTable = $('#department-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('departments.index') }}",
                    data: function(d) {

                    }
                },
                columns: [{
                        data: 'client.agency.name',
                        name: 'client.agency.name'
                    },

                    {
                        data: 'client.business_name',
                        name: 'client.business_name'
                    },
                    {
                        data: 'department_name',
                        name: 'department_name'
                    },
                    {
                        data: 'employee_count',
                        name: 'employee_count'
                    },

                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });
        });
    </script>

@endsection
