@extends('layouts.sidebar')

@section('title', 'Departments')
@section('content')
    @if (in_array('Manage Payroll' || 'Client Interface', $privileges))
        <div class="mx-auto ">
            <div class="relative flex flex-col items-end justify-end mr-10 text-center">
                <div>
                    <button type="button"
                        class="inline-flex justify-center w-full px-4 py-2 text-sm font-medium text-white bg-[#1d1d1d] border border-gray-300 rounded-md shadow-sm hover:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-100 focus:ring-blue-500"
                        id="menu-button" aria-expanded="false" aria-haspopup="true">
                        Menu
                        <svg class="w-5 h-5 ml-2 -mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                            fill="currentColor" aria-hidden="true">
                            <path fill-rule="evenodd"
                                d="M5.23 7.21a.75.75 0 011.06 0L10 10.44l3.71-3.23a.75.75 0 111.04 1.08l-4.25 3.5a.75.75 0 01-1.04 0l-4.25-3.5a.75.75 0 010-1.08z"
                                clip-rule="evenodd" />
                        </svg>
                    </button>
                    <div class="absolute right-0 z-10 hidden w-56 mt-2 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                        role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1"
                        id="dropdown-menu">
                        <div class="py-1" role="none">
                            <div class="flex flex-col items-center justify-center">
                                <button id="showemployee"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                    Employees
                                </button>
                                @if (in_array('Create ASF', $privileges))
                                    <button id="showSettings"
                                        class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                        Settings
                                    </button>

                                    <button id="showCharges"
                                        class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                        Charges
                                    </button>
                                @else
                                    <div id="showSettings"></div>
                                    <div id="showCharges"></div>
                                @endif
                                <button id="showDocuments"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                    Documents
                                </button>
                                <button id="showStores"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                    Stores
                                </button>
                                <button id="showPayrolls"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                    Payrolls
                                </button>
                                <button id="showBilling"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                    Billing
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Employee Section -->

        <div class="grid grid-cols-1 gap-10 xl:grid-cols-6">

            <div class="w-full mb-3 bg-white border border-gray-200 rounded shadow-md h-[22rem]">
                <p class="h-10 p-2 text-md font-bold text-white bg-[#1d1d1d]">Client Profile</p>
                <div class="p-4 overflow-auto text-xs">
                    <table class="w-full border border-collapse border-gray-200 table-auto">
                        <tbody>
                            <tr class="border-b border-gray-200">
                                <td class="px-4 py-2 font-semibold">Agency Logo</td>
                                <td class="px-4 py-2 text-red-600"><img
                                        src="{{ asset($department->client->agency->contact_person) }}" width="50"
                                        height="50">
                                </td>
                            </tr>
                            <tr class="border-b border-gray-200">
                                <td class="px-4 py-2 font-semibold">Agency:</td>
                                <td class="px-4 py-2 text-red-600">{{ $department->client->agency->name }}</td>
                            </tr>
                            <tr class="border-b border-gray-200">
                                <td class="px-4 py-2 font-semibold">Company:</td>
                                <td class="px-4 py-2 text-red-600">{{ $department->client->business_name }}</td>
                            </tr>
                            <tr class="border-b border-gray-200">
                                <td class="px-4 py-2 font-semibold">Client:</td>
                                <td class="px-4 py-2 text-red-600">{{ $department->department_name }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div id="employeeshow" class="mt-4 bg-gray-100 rounded-lg lg:col-span-5">
                <!-- Employees Table -->
                <div class="overflow-x-auto">
                    <table id="department-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                        <thead>
                            <tr class="text-sm leading-normal text-white text-nowrap bg-[#1d1d1d]">
                                <th class="px-6 py-3">Employee Name</th>
                                <th class="px-6 py-3">Store</th>
                                <th class="px-6 py-3">Date Hired</th>
                                <th class="px-6 py-3">Position</th>
                                <th class="px-6 py-3">Dtr ID</th>
                                <th class="px-6 py-3">Start Date</th>
                                <th class="px-6 py-3">End Date</th>
                                <th class="px-6 py-3">Shift Start</th>
                                <th class="px-6 py-3">Shift End</th>
                                <th class="px-6 py-3">Status</th>
                                <th class="px-6 py-3">Action</th>
                            </tr>
                        </thead>
                        <tbody class="text-sm font-light text-center text-gray-600">
                            <!-- Employees data -->
                        </tbody>
                    </table>
                </div>
            </div>
<div id="deleteemployeeclientModal" class="fixed inset-0 flex z-50 items-center justify-center hidden bg-black bg-opacity-50">
    <div class="w-1/3 p-6 bg-white rounded-lg shadow-lg">
        <h2 class="mb-4 text-xl font-bold">Confirm Delete</h2>
        <p class="mb-4">Are you sure you want to delete this record? This action cannot be undone.</p>
        <div class="flex justify-end space-x-4">
            <button type="button" id="deleteCancelBtn" class="px-4 py-2 text-white bg-gray-500 rounded">Cancel</button>
            <button type="button" id="deleteConfirmBtn" class="px-4 py-2 text-white bg-red-500 rounded">Delete</button>
        </div>
    </div>
</div>

<script>
    let selectedPayrollId = null;

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Open modal and set current payrollId
    function openClientEmployeeDeleteModal(payrollId) {
        selectedPayrollId = payrollId;
        $('#deleteemployeeclientModal').removeClass('hidden');
    }

    // Cancel button
    $('#deleteCancelBtn').on('click', function () {
        $('#deleteemployeeclientModal').addClass('hidden');
        selectedPayrollId = null;
    });

    // Confirm delete button
    $('#deleteConfirmBtn').on('click', function () {
        if (selectedPayrollId) {
            deletePayroll(selectedPayrollId);
        }
    });

    // Perform AJAX delete
    function deletePayroll(payrollId) {
        $.ajax({
            url: "{{ route('department.employee.delete', ':id') }}".replace(':id', payrollId),
            type: 'DELETE',
            success: function (response) {
                $('#deleteemployeeclientModal').addClass('hidden');
                selectedPayrollId = null;

                // Reload datatable without resetting pagination
                $('#department-table').DataTable().ajax.reload(null, false);
            },
            error: function (xhr, status, error) {
                alert("Error deleting record: " + (xhr.responseJSON?.message || error));
            }
        });
    }
</script>


            <div id="settingsShow" class="hidden mt-4 bg-gray-100 rounded-lg lg:col-span-5">
                @include('Admin.Department.settings.set')
            </div>

            <div id="newSectionShow" class="hidden mt-4 bg-gray-100 rounded-lg lg:col-span-5">

                @include('Admin.Department.settings.charges')

            </div>

            <div id="reportsShow" class="hidden mt-4 bg-gray-100 rounded-lg lg:col-span-5">
                @include('Admin.Department.settings.docs')
            </div>

            <div id="payrollShow" class="hidden mt-4 bg-gray-100 rounded-lg lg:col-span-5">
                @include('Admin.Department.payroll.index')
            </div>

            <div id="billingShow" class="hidden mt-4 bg-gray-100 rounded-lg lg:col-span-5">
                @include('Admin.Department.billing.index')
            </div>
            <div id="storeShow" class="hidden mt-4 bg-gray-100 rounded-lg lg:col-span-5">
                @include('Admin.Department.store.index')
            </div>

        </div>

        <!-- Billing Section -->

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Menu button elements
                const showEmployeeBtn = document.getElementById('showemployee');
                const showSettingsBtn = document.getElementById('showSettings');
                const showChargesBtn = document.getElementById('showCharges');
                const showDocumentsBtn = document.getElementById('showDocuments');
                const showPayrollsBtn = document.getElementById('showPayrolls');
                const showBillingBtn = document.getElementById('showBilling');
                const showStoreBtn = document.getElementById('showStores');

                // Section elements
                const employeeSection = document.getElementById('employeeshow');
                const settingsSection = document.getElementById('settingsShow');
                const chargesSection = document.getElementById('newSectionShow');
                const documentsSection = document.getElementById('reportsShow');
                const payrollSection = document.getElementById('payrollShow');
                const billingSection = document.getElementById('billingShow');
                const storeSection = document.getElementById('storeShow');

                // Dropdown menu (if applicable)
                const menuButton = document.getElementById('menu-button');
                const dropdownMenu = document.getElementById('dropdown-menu');

                // Helper function to hide all sections
                function hideAllSections() {
                    employeeSection.classList.add('hidden');
                    settingsSection.classList.add('hidden');
                    chargesSection.classList.add('hidden');
                    documentsSection.classList.add('hidden');
                    payrollSection.classList.add('hidden');
                    billingSection.classList.add('hidden');
                    storeSection.classList.add('hidden');
                }

                // Event Listeners for menu buttons
                showEmployeeBtn.addEventListener('click', function() {
                    hideAllSections();
                    employeeSection.classList.remove('hidden');
                    if (dropdownMenu) dropdownMenu.classList.add('hidden');
                });

                showSettingsBtn.addEventListener('click', function() {
                    hideAllSections();
                    settingsSection.classList.remove('hidden');
                    if (dropdownMenu) dropdownMenu.classList.add('hidden');
                });

                showChargesBtn.addEventListener('click', function() {
                    hideAllSections();
                    chargesSection.classList.remove('hidden');
                    if (dropdownMenu) dropdownMenu.classList.add('hidden');
                });

                showDocumentsBtn.addEventListener('click', function() {
                    hideAllSections();
                    documentsSection.classList.remove('hidden');
                    if (dropdownMenu) dropdownMenu.classList.add('hidden');
                });

                showPayrollsBtn.addEventListener('click', function() {
                    hideAllSections();
                    payrollSection.classList.remove('hidden');
                    if (dropdownMenu) dropdownMenu.classList.add('hidden');
                });

                showBillingBtn.addEventListener('click', function() {
                    hideAllSections();
                    billingSection.classList.remove('hidden');
                    if (dropdownMenu) dropdownMenu.classList.add('hidden');
                });
                showStoreBtn.addEventListener('click', function() {
                    hideAllSections();
                    storeSection.classList.remove('hidden');
                    if (dropdownMenu) dropdownMenu.classList.add('hidden');
                });
                // Dropdown menu toggle (if using a dropdown)
                if (menuButton && dropdownMenu) {
                    menuButton.addEventListener('click', function() {
                        dropdownMenu.classList.toggle('hidden');
                    });

                    // Hide dropdown if clicked outside
                    document.addEventListener('click', function(event) {
                        if (!menuButton.contains(event.target) && !dropdownMenu.contains(event.target)) {
                            dropdownMenu.classList.add('hidden');
                        }
                    });
                }
            });
        </script>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif



    <script>
        let stores = [];
        var department_id = {{ $department->id }};
        document.addEventListener("DOMContentLoaded", function() {
            // Step 1: Fetch stores first
            fetch("{{ route('stores.select', ['id' => ':id']) }}".replace(':id', department_id))
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        stores = data.data;
                        initDepartmentTable(); // Initialize DataTable only after stores are fetched
                    } else {
                        console.error("Failed to fetch stores");
                    }
                })
                .catch(error => {
                    console.error("Error fetching stores:", error);
                });

            function initDepartmentTable() {


                var departmentTable = $('#department-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('departments.employees.show', ['id' => ':id']) }}".replace(':id',
                            department_id),
                        data: function(d) {
                            d.department_id = department_id;
                        }
                    },
                    columns: [{
                            data: 'employee_name',
                            name: 'employee_name',
                            width: '10%'
                        },

                        {
                            data: 'store_id',
                            name: 'store_id',
                            width: '10%',
                            render: function(data, type, row) {
                                let options = `<option value="">-- Select Store --</option>`;
                                stores.forEach(store => {
                                    const selected = store.id == data ? 'selected' : '';
                                    options +=
                                        `<option value="${store.id}" ${selected}>${store.name}</option>`;
                                });
                                return `<select class="border-2 border-black rounded-md editable" data-id="${row.id}" data-field="store_id">${options}</select>`;
                            }
                        },

                        {
                            data: 'date_hired',
                            name: 'date_hired',
                            width: '10%',
                            render: function(data, type, row) {
                                return `<input type="date" class="border-2 border-black rounded-md editable" data-id="${row.id}" data-field="date_hired" value="${data}">`;
                            }
                        },
                        {
                            data: 'position',
                            name: 'position',
                            width: '10%',
                            render: function(data, type, row) {
                                return `<input type="text" class="border-2 border-black rounded-md editable" data-id="${row.id}" data-field="position" value="${data}">`;
                            }
                        },
                        {
                            data: 'dtr_id',
                            name: 'dtr_id',
                            width: '10%',
                            render: function(data, type, row) {
                                return `<input type="text" class="border-2 border-black rounded-md editable" data-id="${row.id}" data-field="dtr_id" value="${data}">`;
                            }
                        },
                        {
                            data: 'employment_start_date',
                            name: 'employment_start_date',
                            width: '10%',
                            render: function(data, type, row) {
                                return `<input type="date" class="border-2 border-black rounded-md editable" data-id="${row.id}" data-field="employment_start_date" value="${data}">`;
                            }
                        },
                        {
                            data: 'employment_end_date',
                            name: 'employment_end_date',
                            width: '10%',
                            render: function(data, type, row) {
                                return `<input type="date" class="border-2 border-black rounded-md editable" data-id="${row.id}" data-field="employment_end_date" value="${data}">`;
                            }
                        },
                        {
                            data: 'entry_time',
                            name: 'entry_time',
                            width: '10%',
                            render: function(data, type, row) {
                                return `<input type="time" class="border-2 border-black rounded-md editable" data-id="${row.id}" data-field="entry_time" value="${data}">`;
                            }
                        },
                        {
                            data: 'exit_time',
                            name: 'exit_time',
                            width: '10%',
                            render: function(data, type, row) {
                                return `<input type="time" class="border-2 border-black rounded-md editable" data-id="${row.id}" data-field="exit_time" value="${data}">`;
                            }
                        },
                        {
                            data: 'status',
                            name: 'status',
                            width: '5%'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            width: '3%'
                        }
                    ],
                    columnDefs: [{
                        targets: '_all',
                        className: 'text-center'
                    }]
                });

                // Step 2: AJAX update on input/select change
                $(document).on('change', '.editable', function() {
                    var id = $(this).data('id');
                    var field = $(this).data('field');
                    var value = $(this).val();

                    $.ajax({
                        url: "{{ route('departments.employees.update') }}",
                        method: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}',
                            id: id,
                            field: field,
                            value: value
                        },
                        success: function(response) {
                            if (response.success) {
                                departmentTable.ajax.reload(null, false);
                            }
                        },
                        error: function() {
                            alert('Error updating field');
                        }
                    });
                });
            }
        });
    </script>


@endsection
