@extends('layouts.sidebar')
@section('title', 'Payroll')
@section('content')
    <div class="container mx-auto p-4">
        <h1 class="text-2xl font-bold mb-6">Edit Department</h1>
        <form id="edit-department-form" action="{{ route('departments.update', $department->id) }}" method="POST"
            class="w-full space-y-6">
            @csrf
            @method('PUT')

            <!-- Client Dropdown -->
            <div>
                <label for="client_id" class="block text-sm font-medium text-gray-700">Company:</label>
                <select name="client_id" id="client_id" required
                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                    <option value="" disabled>Select Company</option>
                    @foreach ($company as $client)
                        <option value="{{ $client->id }}" {{ $department->client_id == $client->id ? 'selected' : '' }}>
                            {{ $client->business_name }}
                        </option>
                    @endforeach
                </select>

                <!-- Display Validation Error -->
                @error('client_id')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Department Name -->
            <div>
                <label for="department_name" class="block text-sm font-medium text-gray-700">Department Name:</label>
                <input type="text" name="department_name" id="department_name" required
                    value="{{ old('department_name', $department->department_name) }}"
                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                    placeholder="Enter Department Name">

                <!-- Display Validation Error -->
                @error('department_name')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Submit Button -->
            <div>
                <button type="submit"
                    class="inline-flex justify-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    Update Department
                </button>
            </div>
        </form>

        <!-- Display General Errors -->
        @if ($errors->any())
            <div class="p-4 mt-4 text-red-700 bg-red-100 border border-red-400 rounded-md">
                <strong>Oops! Something went wrong:</strong>
                <ul class="mt-2 list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif


    @endsection
