<div class="w-full p-4 lg:w-full">
    <div class="p-2 overflow-auto border-2 border-black rounded-md ">
        <table id="billing-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
            <thead>
                <tr class="text-sm leading-normal text-white uppercase bg-black">
                    <th class="px-6 py-3">Batch Code</th>
                    <th class="px-6 py-3">Client</th>
                    <th class="px-6 py-3">Final Approval In charge</th>
                    <th class="px-6 py-3">Pay Period</th>
                    <th class="px-6 py-3">Actions</th>
                </tr>
            </thead>
            <tbody class="text-sm font-light text-center text-gray-600">
                <!-- Data will be populated here by DataTables -->
            </tbody>
        </table>
    </div>
</div>

<script>
    $(document).ready(function() {
        var department_id = {{ $department->id }};

        var employedTable = $('#billing-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route('clientbilling.index', ['id' => ':id']) }}'.replace(':id', department_id),
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'client_id',
                    name: 'client_id',
                    render: function(data, type, row) {
                        // Trim any extra spaces from client data if needed.
                        return typeof data === 'string' ? data.trim() : data;
                    }
                },
                {
                    data: 'approve_by',
                    name: 'approve_by',
                    render: function(data, type, row) {
                        return typeof data === 'string' ? data.trim() : data;
                    }
                },
                {
                    data: 'pay_period',
                    name: 'pay_period',
                    render: function(data, type, row) {
                        return typeof data === 'string' ? data.trim() : data;
                    }
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [0, 'desc']
            ]
        });
    });
</script>
