<div class="relative w-full ">
    <div id="subscribe-form-modal"
        class="pd-overlay  hidden w-full h-full fixed top-0 left-0 z-[100]  overflow-x-hidden overflow-y-auto bg-black bg-opacity-80">
        <div
            class="w-full transition-all ease-out opacity-0 md:w-1/2 sm:mx-auto modal-open:opacity-100 modal-open:duration-500 p-10">
            <div class="flex flex-col px-5 py-4 bg-white rounded-2xl">
                <div class="flex items-center justify-between pb-4 border-b border-gray-200">
                    <h4 class="text-sm font-medium text-gray-900">Create New Company</h4>
                    <button class="block cursor-pointer close-modal-button" data-pd-overlay="#subscribe-form-modal"
                        data-modal-target="subscribe-form-modal">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.75732 7.75739L16.2426 16.2427M16.2426 7.75739L7.75732 16.2427" stroke="black"
                                stroke-width="1.6" stroke-linecap="round" />
                        </svg>
                    </button>
                </div>
                <div class="w-full p-8 mx-auto my-10 bg-white border border-gray-200 rounded-lg shadow-md">

                    <form action="{{ route('companies.store') }}" method="POST">
                        @csrf
                        <div class="grid grid-cols-1 md:grid-cols-2  gap-4">
                            <div>
                                <label for="agency_id" class="block text-sm font-medium text-gray-700">Agency</label>
                                <select name="agency_id" id="agency_id"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('agency_id') border-red-500 @enderror"
                                    required>
                                    <option value="">Select an agency</option>
                                    @foreach ($agencies as $agency)
                                        <option value="{{ $agency->id }}">{{ $agency->name }}</option>
                                    @endforeach
                                </select>
                                @error('agency_id')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700">Company
                                    Name</label>
                                <input type="text" name="name" id="name"
                                    class="mt-1 block w-full  border-2 border-black h-10 rounded-md shadow-sm @error('name') border-red-500 @enderror"
                                    required>
                                @error('name')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div>
                                <label for="contact_person" class="block text-sm font-medium text-gray-700">Contact
                                    Person</label>
                                <input type="text" name="contact_person" id="contact_person"
                                    class="mt-1 block w-full  border-2 border-black h-10 rounded-md shadow-sm @error('contact_person') border-red-500 @enderror"
                                    required>
                                @error('contact_person')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div>
                                <label for="contact_phone" class="block text-sm font-medium text-gray-700">Contact
                                    Phone</label>
                                <input type="text" name="contact_phone" id="contact_phone"
                                    class="mt-1 block w-full  border-2 border-black h-10 rounded-md shadow-sm @error('contact_phone') border-red-500 @enderror"
                                    required>
                                @error('contact_phone')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div>
                                <label for="address" class="block text-sm font-medium text-gray-700">Address</label>
                                <input type="text" name="address" id="address"
                                    class="mt-1 block w-full  border-2 border-black h-10 rounded-md shadow-sm @error('address') border-red-500 @enderror">
                                @error('address')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div>
                                <label for="industry" class="block text-sm font-medium text-gray-700">Industry</label>
                                <input type="text" name="industry" id="industry"
                                    class="mt-1 block w-full  border-2 border-black h-10 rounded-md shadow-sm @error('industry') border-red-500 @enderror">
                                @error('industry')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="hidden">
                                <label for="email" class="block text-sm font-medium text-gray-700">Email</label>
                                <input type="email" name="email" id="email"
                                    class="mt-1 block w-full border-2  border-black h-10 rounded-md shadow-sm @error('email') border-red-500 @enderror"
                                    required value="1@gmail.com">
                                @error('email')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="hidden">
                                <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                                <input type="password" name="password" id="password"
                                    class="mt-1 block w-full border-2  border-black h-10  rounded-md shadow-sm @error('password') border-red-500 @enderror"
                                    required value="12345678">
                                @error('password')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="hidden">
                                <label for="password_confirmation"
                                    class="block text-sm font-medium text-gray-700">Confirm Password</label>
                                <input type="password" name="password_confirmation" id="password_confirmation"
                                    class="mt-1 block w-full border-2  border-black h-10 rounded-md shadow-sm @error('password_confirmation') border-red-500 @enderror"
                                    required value="12345678">
                                @error('password_confirmation')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="flex justify-center ">
                            <button type="submit" class="px-4 py-2 mt-4 text-white bg-green-600 rounded-md">Create
                                Company
                            </button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@foreach ($data as $com)
    <div id="deleteModal{{ $com->id }}"
        class="fixed inset-0 z-50 flex items-start justify-center bg-gray-800 bg-opacity-60 hidden">
        <div class="max-w-md mx-auto bg-white rounded-lg shadow-md overflow-hidden mt-20">
            <!-- Modal header -->
            <div class="flex justify-between items-center bg-gray-700 p-4 rounded-t-lg">
                <h5 class="font-semibold text-lg text-white">Confirm Delete</h5>
                <button onclick="closeModal('deleteModal{{ $com->id }}')" class="text-white">&times;</button>
            </div>

            <!-- Modal body -->
            <div class="px-6 py-4">
                <p class="text-sm text-gray-700">Are you certain you want to delete this Company
                    ({{ $com->name }})
                    ? Doing so will affect the
                    related
                    clients.</p>
            </div>


            <div class="flex justify-end space-x-4 px-6 py-4 bg-gray-50 rounded-b-lg">
                <button onclick="closeModal('deleteModal{{ $com->id }}')"
                    class="px-3 py-1 mr-2 text-gray-800 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>

                <!-- Form for delete -->
                <form id="deleteForm{{ $com->id }}" action="{{ route('companies.destroy', $com->id) }}"
                    method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit"
                        class="px-3 py-1 text-white bg-red-500 rounded hover:bg-red-600">Delete</button>
                </form>
            </div>
        </div>
    </div>




    <div id="updateModal{{ $com->id }}"
        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50 modal fade">
        <!-- Modal dialog -->
        <div class="w-1/2 mx-auto mt-10 overflow-hidden bg-white rounded-lg shadow-xl">
            <!-- Modal header -->
            <div class="flex items-center justify-between px-4 py-2 ">
                <h5 class="text-sm font-medium text-gray-900">Edit Company</h5>
                <button onclick="closeModal('updateModal{{ $com->id }}')" class="">&times;</button>
            </div>
            <div class="text-white modal-header bg-primary">
                <h5 class="modal-title" id="updateModal{{ $com->id }}">Update Client Information</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="w-full p-8 mx-auto my-10 bg-white border border-gray-200 rounded-lg shadow-md">
                <!-- Update Form -->
                <form action="{{ route('companies.update', $com->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="name{{ $com->id }}"
                                class="block text-sm font-medium text-gray-700">Name</label>
                            <input type="text"
                                class="block w-full h-10 mt-1 border-2 border-black rounded-md shadow-sm"
                                id="name{{ $com->id }}" name="name"
                                class="block w-full h-10 mt-1 border-2 border-black rounded-md shadow-sm"
                                value="{{ $com->name }}">
                        </div>
                        <div class="mb-3">
                            <label for="contact_person{{ $com->id }}"
                                class="block text-sm font-medium text-gray-700">Contact Person</label>
                            <input type="text"
                                class="block w-full h-10 mt-1 border-2 border-black rounded-md shadow-sm"
                                id="contact_person{{ $com->id }}" name="contact_person"
                                value="{{ $com->contact_person }}">
                        </div>
                        <div class="mb-3">
                            <label for="contact_phone{{ $com->id }}"
                                class="block text-sm font-medium text-gray-700">Contact Phone</label>
                            <input type="text"
                                class="block w-full h-10 mt-1 border-2 border-black rounded-md shadow-sm"
                                id="contact_phone{{ $com->id }}" name="contact_phone"
                                value="{{ $com->contact_phone }}">
                        </div>

                        <!-- Address Field -->
                        <div class="mb-3">
                            <label for="address{{ $com->id }}"
                                class="block text-sm font-medium text-gray-700">Address</label>
                            <input type="text"
                                class="block w-full h-10 mt-1 border-2 border-black rounded-md shadow-sm"
                                id="address{{ $com->id }}" name="address" value="{{ $com->address }}">
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="flex justify-center ">

                        <button type="submit"
                            class="px-4 py-2 mt-4 text-white bg-green-600 rounded-md">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endforeach
<script>
    function openModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    // Function to close a modal
    function closeModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>
